package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.OpenShiftItem;

@JsonPropertyOrder({
    "@odata.type", 
    "draftOpenShift", 
    "isStagedForDeletion", 
    "schedulingGroupId", 
    "sharedOpenShift"})
@JsonInclude(Include.NON_NULL)
public class OpenShift extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.openShift";
    }

    @JsonProperty("draftOpenShift")
    protected OpenShiftItem draftOpenShift;

    @JsonProperty("isStagedForDeletion")
    protected Boolean isStagedForDeletion;

    @JsonProperty("schedulingGroupId")
    protected String schedulingGroupId;

    @JsonProperty("sharedOpenShift")
    protected OpenShiftItem sharedOpenShift;

    protected OpenShift() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOpenShift() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private OpenShiftItem draftOpenShift;
        private Boolean isStagedForDeletion;
        private String schedulingGroupId;
        private OpenShiftItem sharedOpenShift;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder draftOpenShift(OpenShiftItem draftOpenShift) {
            this.draftOpenShift = draftOpenShift;
            this.changedFields = changedFields.add("draftOpenShift");
            return this;
        }

        public Builder isStagedForDeletion(Boolean isStagedForDeletion) {
            this.isStagedForDeletion = isStagedForDeletion;
            this.changedFields = changedFields.add("isStagedForDeletion");
            return this;
        }

        public Builder schedulingGroupId(String schedulingGroupId) {
            this.schedulingGroupId = schedulingGroupId;
            this.changedFields = changedFields.add("schedulingGroupId");
            return this;
        }

        public Builder sharedOpenShift(OpenShiftItem sharedOpenShift) {
            this.sharedOpenShift = sharedOpenShift;
            this.changedFields = changedFields.add("sharedOpenShift");
            return this;
        }

        public OpenShift build() {
            OpenShift _x = new OpenShift();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.openShift";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.draftOpenShift = draftOpenShift;
            _x.isStagedForDeletion = isStagedForDeletion;
            _x.schedulingGroupId = schedulingGroupId;
            _x.sharedOpenShift = sharedOpenShift;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="draftOpenShift")
    @JsonIgnore
    public Optional<OpenShiftItem> getDraftOpenShift() {
        return Optional.ofNullable(draftOpenShift);
    }

    public OpenShift withDraftOpenShift(OpenShiftItem draftOpenShift) {
        OpenShift _x = _copy();
        _x.changedFields = changedFields.add("draftOpenShift");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openShift");
        _x.draftOpenShift = draftOpenShift;
        return _x;
    }

    @Property(name="isStagedForDeletion")
    @JsonIgnore
    public Optional<Boolean> getIsStagedForDeletion() {
        return Optional.ofNullable(isStagedForDeletion);
    }

    public OpenShift withIsStagedForDeletion(Boolean isStagedForDeletion) {
        OpenShift _x = _copy();
        _x.changedFields = changedFields.add("isStagedForDeletion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openShift");
        _x.isStagedForDeletion = isStagedForDeletion;
        return _x;
    }

    @Property(name="schedulingGroupId")
    @JsonIgnore
    public Optional<String> getSchedulingGroupId() {
        return Optional.ofNullable(schedulingGroupId);
    }

    public OpenShift withSchedulingGroupId(String schedulingGroupId) {
        OpenShift _x = _copy();
        _x.changedFields = changedFields.add("schedulingGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openShift");
        _x.schedulingGroupId = schedulingGroupId;
        return _x;
    }

    @Property(name="sharedOpenShift")
    @JsonIgnore
    public Optional<OpenShiftItem> getSharedOpenShift() {
        return Optional.ofNullable(sharedOpenShift);
    }

    public OpenShift withSharedOpenShift(OpenShiftItem sharedOpenShift) {
        OpenShift _x = _copy();
        _x.changedFields = changedFields.add("sharedOpenShift");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openShift");
        _x.sharedOpenShift = sharedOpenShift;
        return _x;
    }

    public OpenShift withUnmappedField(String name, Object value) {
        OpenShift _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OpenShift patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OpenShift _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OpenShift put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OpenShift _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OpenShift _copy() {
        OpenShift _x = new OpenShift();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.draftOpenShift = draftOpenShift;
        _x.isStagedForDeletion = isStagedForDeletion;
        _x.schedulingGroupId = schedulingGroupId;
        _x.sharedOpenShift = sharedOpenShift;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OpenShift[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("draftOpenShift=");
        b.append(this.draftOpenShift);
        b.append(", ");
        b.append("isStagedForDeletion=");
        b.append(this.isStagedForDeletion);
        b.append(", ");
        b.append("schedulingGroupId=");
        b.append(this.schedulingGroupId);
        b.append(", ");
        b.append("sharedOpenShift=");
        b.append(this.sharedOpenShift);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
