package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AudioConferencing;
import odata.msgraph.client.beta.complex.BroadcastMeetingSettings;
import odata.msgraph.client.beta.complex.ChatInfo;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.JoinMeetingIdSettings;
import odata.msgraph.client.beta.complex.LobbyBypassSettings;
import odata.msgraph.client.beta.complex.MeetingParticipants;
import odata.msgraph.client.beta.entity.collection.request.MeetingAttendanceReportCollectionRequest;
import odata.msgraph.client.beta.entity.request.MeetingAttendanceReportRequest;
import odata.msgraph.client.beta.entity.request.MeetingRegistrationRequest;
import odata.msgraph.client.beta.enums.AccessLevel;
import odata.msgraph.client.beta.enums.MeetingCapabilities;
import odata.msgraph.client.beta.enums.MeetingChatMode;
import odata.msgraph.client.beta.enums.OnlineMeetingPresenters;

@JsonPropertyOrder({
    "@odata.type", 
    "accessLevel", 
    "allowAttendeeToEnableCamera", 
    "allowAttendeeToEnableMic", 
    "allowedPresenters", 
    "allowMeetingChat", 
    "allowTeamworkReactions", 
    "alternativeRecording", 
    "attendeeReport", 
    "audioConferencing", 
    "broadcastSettings", 
    "canceledDateTime", 
    "capabilities", 
    "chatInfo", 
    "creationDateTime", 
    "endDateTime", 
    "entryExitAnnouncement", 
    "expirationDateTime", 
    "externalId", 
    "isBroadcast", 
    "isCancelled", 
    "isEntryExitAnnounced", 
    "joinInformation", 
    "joinMeetingIdSettings", 
    "joinUrl", 
    "lobbyBypassSettings", 
    "participants", 
    "recordAutomatically", 
    "recording", 
    "startDateTime", 
    "subject", 
    "videoTeleconferenceId", 
    "attendanceReports", 
    "meetingAttendanceReport", 
    "registration"})
@JsonInclude(Include.NON_NULL)
public class OnlineMeeting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onlineMeeting";
    }

    @JsonProperty("accessLevel")
    protected AccessLevel accessLevel;

    @JsonProperty("allowAttendeeToEnableCamera")
    protected Boolean allowAttendeeToEnableCamera;

    @JsonProperty("allowAttendeeToEnableMic")
    protected Boolean allowAttendeeToEnableMic;

    @JsonProperty("allowedPresenters")
    protected OnlineMeetingPresenters allowedPresenters;

    @JsonProperty("allowMeetingChat")
    protected MeetingChatMode allowMeetingChat;

    @JsonProperty("allowTeamworkReactions")
    protected Boolean allowTeamworkReactions;

    @JsonProperty("alternativeRecording")
    protected String alternativeRecording;

    @JsonProperty("attendeeReport")
    protected String attendeeReport;

    @JsonProperty("audioConferencing")
    protected AudioConferencing audioConferencing;

    @JsonProperty("broadcastSettings")
    protected BroadcastMeetingSettings broadcastSettings;

    @JsonProperty("canceledDateTime")
    protected OffsetDateTime canceledDateTime;

    @JsonProperty("capabilities")
    protected List<MeetingCapabilities> capabilities;

    @JsonProperty("capabilities@nextLink")
    protected String capabilitiesNextLink;

    @JsonProperty("chatInfo")
    protected ChatInfo chatInfo;

    @JsonProperty("creationDateTime")
    protected OffsetDateTime creationDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("entryExitAnnouncement")
    protected Boolean entryExitAnnouncement;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("isBroadcast")
    protected Boolean isBroadcast;

    @JsonProperty("isCancelled")
    protected Boolean isCancelled;

    @JsonProperty("isEntryExitAnnounced")
    protected Boolean isEntryExitAnnounced;

    @JsonProperty("joinInformation")
    protected ItemBody joinInformation;

    @JsonProperty("joinMeetingIdSettings")
    protected JoinMeetingIdSettings joinMeetingIdSettings;

    @JsonProperty("joinUrl")
    protected String joinUrl;

    @JsonProperty("lobbyBypassSettings")
    protected LobbyBypassSettings lobbyBypassSettings;

    @JsonProperty("participants")
    protected MeetingParticipants participants;

    @JsonProperty("recordAutomatically")
    protected Boolean recordAutomatically;

    @JsonProperty("recording")
    protected String recording;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("videoTeleconferenceId")
    protected String videoTeleconferenceId;

    @JsonProperty("attendanceReports")
    protected List<MeetingAttendanceReport> attendanceReports;

    @JsonProperty("meetingAttendanceReport")
    protected MeetingAttendanceReport meetingAttendanceReport;

    @JsonProperty("registration")
    protected MeetingRegistration registration;

    protected OnlineMeeting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnlineMeeting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AccessLevel accessLevel;
        private Boolean allowAttendeeToEnableCamera;
        private Boolean allowAttendeeToEnableMic;
        private OnlineMeetingPresenters allowedPresenters;
        private MeetingChatMode allowMeetingChat;
        private Boolean allowTeamworkReactions;
        private String alternativeRecording;
        private String attendeeReport;
        private AudioConferencing audioConferencing;
        private BroadcastMeetingSettings broadcastSettings;
        private OffsetDateTime canceledDateTime;
        private List<MeetingCapabilities> capabilities;
        private String capabilitiesNextLink;
        private ChatInfo chatInfo;
        private OffsetDateTime creationDateTime;
        private OffsetDateTime endDateTime;
        private Boolean entryExitAnnouncement;
        private OffsetDateTime expirationDateTime;
        private String externalId;
        private Boolean isBroadcast;
        private Boolean isCancelled;
        private Boolean isEntryExitAnnounced;
        private ItemBody joinInformation;
        private JoinMeetingIdSettings joinMeetingIdSettings;
        private String joinUrl;
        private LobbyBypassSettings lobbyBypassSettings;
        private MeetingParticipants participants;
        private Boolean recordAutomatically;
        private String recording;
        private OffsetDateTime startDateTime;
        private String subject;
        private String videoTeleconferenceId;
        private List<MeetingAttendanceReport> attendanceReports;
        private MeetingAttendanceReport meetingAttendanceReport;
        private MeetingRegistration registration;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            this.changedFields = changedFields.add("accessLevel");
            return this;
        }

        public Builder allowAttendeeToEnableCamera(Boolean allowAttendeeToEnableCamera) {
            this.allowAttendeeToEnableCamera = allowAttendeeToEnableCamera;
            this.changedFields = changedFields.add("allowAttendeeToEnableCamera");
            return this;
        }

        public Builder allowAttendeeToEnableMic(Boolean allowAttendeeToEnableMic) {
            this.allowAttendeeToEnableMic = allowAttendeeToEnableMic;
            this.changedFields = changedFields.add("allowAttendeeToEnableMic");
            return this;
        }

        public Builder allowedPresenters(OnlineMeetingPresenters allowedPresenters) {
            this.allowedPresenters = allowedPresenters;
            this.changedFields = changedFields.add("allowedPresenters");
            return this;
        }

        public Builder allowMeetingChat(MeetingChatMode allowMeetingChat) {
            this.allowMeetingChat = allowMeetingChat;
            this.changedFields = changedFields.add("allowMeetingChat");
            return this;
        }

        public Builder allowTeamworkReactions(Boolean allowTeamworkReactions) {
            this.allowTeamworkReactions = allowTeamworkReactions;
            this.changedFields = changedFields.add("allowTeamworkReactions");
            return this;
        }

        public Builder alternativeRecording(String alternativeRecording) {
            this.alternativeRecording = alternativeRecording;
            this.changedFields = changedFields.add("alternativeRecording");
            return this;
        }

        public Builder attendeeReport(String attendeeReport) {
            this.attendeeReport = attendeeReport;
            this.changedFields = changedFields.add("attendeeReport");
            return this;
        }

        public Builder audioConferencing(AudioConferencing audioConferencing) {
            this.audioConferencing = audioConferencing;
            this.changedFields = changedFields.add("audioConferencing");
            return this;
        }

        public Builder broadcastSettings(BroadcastMeetingSettings broadcastSettings) {
            this.broadcastSettings = broadcastSettings;
            this.changedFields = changedFields.add("broadcastSettings");
            return this;
        }

        public Builder canceledDateTime(OffsetDateTime canceledDateTime) {
            this.canceledDateTime = canceledDateTime;
            this.changedFields = changedFields.add("canceledDateTime");
            return this;
        }

        public Builder capabilities(List<MeetingCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder capabilities(MeetingCapabilities... capabilities) {
            return capabilities(Arrays.asList(capabilities));
        }

        public Builder capabilitiesNextLink(String capabilitiesNextLink) {
            this.capabilitiesNextLink = capabilitiesNextLink;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder chatInfo(ChatInfo chatInfo) {
            this.chatInfo = chatInfo;
            this.changedFields = changedFields.add("chatInfo");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder entryExitAnnouncement(Boolean entryExitAnnouncement) {
            this.entryExitAnnouncement = entryExitAnnouncement;
            this.changedFields = changedFields.add("entryExitAnnouncement");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder isBroadcast(Boolean isBroadcast) {
            this.isBroadcast = isBroadcast;
            this.changedFields = changedFields.add("isBroadcast");
            return this;
        }

        public Builder isCancelled(Boolean isCancelled) {
            this.isCancelled = isCancelled;
            this.changedFields = changedFields.add("isCancelled");
            return this;
        }

        public Builder isEntryExitAnnounced(Boolean isEntryExitAnnounced) {
            this.isEntryExitAnnounced = isEntryExitAnnounced;
            this.changedFields = changedFields.add("isEntryExitAnnounced");
            return this;
        }

        public Builder joinInformation(ItemBody joinInformation) {
            this.joinInformation = joinInformation;
            this.changedFields = changedFields.add("joinInformation");
            return this;
        }

        public Builder joinMeetingIdSettings(JoinMeetingIdSettings joinMeetingIdSettings) {
            this.joinMeetingIdSettings = joinMeetingIdSettings;
            this.changedFields = changedFields.add("joinMeetingIdSettings");
            return this;
        }

        public Builder joinUrl(String joinUrl) {
            this.joinUrl = joinUrl;
            this.changedFields = changedFields.add("joinUrl");
            return this;
        }

        public Builder lobbyBypassSettings(LobbyBypassSettings lobbyBypassSettings) {
            this.lobbyBypassSettings = lobbyBypassSettings;
            this.changedFields = changedFields.add("lobbyBypassSettings");
            return this;
        }

        public Builder participants(MeetingParticipants participants) {
            this.participants = participants;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public Builder recordAutomatically(Boolean recordAutomatically) {
            this.recordAutomatically = recordAutomatically;
            this.changedFields = changedFields.add("recordAutomatically");
            return this;
        }

        public Builder recording(String recording) {
            this.recording = recording;
            this.changedFields = changedFields.add("recording");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder videoTeleconferenceId(String videoTeleconferenceId) {
            this.videoTeleconferenceId = videoTeleconferenceId;
            this.changedFields = changedFields.add("videoTeleconferenceId");
            return this;
        }

        public Builder attendanceReports(List<MeetingAttendanceReport> attendanceReports) {
            this.attendanceReports = attendanceReports;
            this.changedFields = changedFields.add("attendanceReports");
            return this;
        }

        public Builder attendanceReports(MeetingAttendanceReport... attendanceReports) {
            return attendanceReports(Arrays.asList(attendanceReports));
        }

        public Builder meetingAttendanceReport(MeetingAttendanceReport meetingAttendanceReport) {
            this.meetingAttendanceReport = meetingAttendanceReport;
            this.changedFields = changedFields.add("meetingAttendanceReport");
            return this;
        }

        public Builder registration(MeetingRegistration registration) {
            this.registration = registration;
            this.changedFields = changedFields.add("registration");
            return this;
        }

        public OnlineMeeting build() {
            OnlineMeeting _x = new OnlineMeeting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onlineMeeting";
            _x.id = id;
            _x.accessLevel = accessLevel;
            _x.allowAttendeeToEnableCamera = allowAttendeeToEnableCamera;
            _x.allowAttendeeToEnableMic = allowAttendeeToEnableMic;
            _x.allowedPresenters = allowedPresenters;
            _x.allowMeetingChat = allowMeetingChat;
            _x.allowTeamworkReactions = allowTeamworkReactions;
            _x.alternativeRecording = alternativeRecording;
            _x.attendeeReport = attendeeReport;
            _x.audioConferencing = audioConferencing;
            _x.broadcastSettings = broadcastSettings;
            _x.canceledDateTime = canceledDateTime;
            _x.capabilities = capabilities;
            _x.capabilitiesNextLink = capabilitiesNextLink;
            _x.chatInfo = chatInfo;
            _x.creationDateTime = creationDateTime;
            _x.endDateTime = endDateTime;
            _x.entryExitAnnouncement = entryExitAnnouncement;
            _x.expirationDateTime = expirationDateTime;
            _x.externalId = externalId;
            _x.isBroadcast = isBroadcast;
            _x.isCancelled = isCancelled;
            _x.isEntryExitAnnounced = isEntryExitAnnounced;
            _x.joinInformation = joinInformation;
            _x.joinMeetingIdSettings = joinMeetingIdSettings;
            _x.joinUrl = joinUrl;
            _x.lobbyBypassSettings = lobbyBypassSettings;
            _x.participants = participants;
            _x.recordAutomatically = recordAutomatically;
            _x.recording = recording;
            _x.startDateTime = startDateTime;
            _x.subject = subject;
            _x.videoTeleconferenceId = videoTeleconferenceId;
            _x.attendanceReports = attendanceReports;
            _x.meetingAttendanceReport = meetingAttendanceReport;
            _x.registration = registration;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accessLevel")
    @JsonIgnore
    public Optional<AccessLevel> getAccessLevel() {
        return Optional.ofNullable(accessLevel);
    }

    public OnlineMeeting withAccessLevel(AccessLevel accessLevel) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("accessLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.accessLevel = accessLevel;
        return _x;
    }

    @Property(name="allowAttendeeToEnableCamera")
    @JsonIgnore
    public Optional<Boolean> getAllowAttendeeToEnableCamera() {
        return Optional.ofNullable(allowAttendeeToEnableCamera);
    }

    public OnlineMeeting withAllowAttendeeToEnableCamera(Boolean allowAttendeeToEnableCamera) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("allowAttendeeToEnableCamera");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.allowAttendeeToEnableCamera = allowAttendeeToEnableCamera;
        return _x;
    }

    @Property(name="allowAttendeeToEnableMic")
    @JsonIgnore
    public Optional<Boolean> getAllowAttendeeToEnableMic() {
        return Optional.ofNullable(allowAttendeeToEnableMic);
    }

    public OnlineMeeting withAllowAttendeeToEnableMic(Boolean allowAttendeeToEnableMic) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("allowAttendeeToEnableMic");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.allowAttendeeToEnableMic = allowAttendeeToEnableMic;
        return _x;
    }

    @Property(name="allowedPresenters")
    @JsonIgnore
    public Optional<OnlineMeetingPresenters> getAllowedPresenters() {
        return Optional.ofNullable(allowedPresenters);
    }

    public OnlineMeeting withAllowedPresenters(OnlineMeetingPresenters allowedPresenters) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("allowedPresenters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.allowedPresenters = allowedPresenters;
        return _x;
    }

    @Property(name="allowMeetingChat")
    @JsonIgnore
    public Optional<MeetingChatMode> getAllowMeetingChat() {
        return Optional.ofNullable(allowMeetingChat);
    }

    public OnlineMeeting withAllowMeetingChat(MeetingChatMode allowMeetingChat) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("allowMeetingChat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.allowMeetingChat = allowMeetingChat;
        return _x;
    }

    @Property(name="allowTeamworkReactions")
    @JsonIgnore
    public Optional<Boolean> getAllowTeamworkReactions() {
        return Optional.ofNullable(allowTeamworkReactions);
    }

    public OnlineMeeting withAllowTeamworkReactions(Boolean allowTeamworkReactions) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("allowTeamworkReactions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.allowTeamworkReactions = allowTeamworkReactions;
        return _x;
    }

    @Property(name="alternativeRecording")
    @JsonIgnore
    public Optional<StreamProvider> getAlternativeRecording() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "alternativeRecording", alternativeRecording);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code alternativeRecording} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="alternativeRecording")
    public Optional<StreamUploaderSingleCall> patchAlternativeRecording() {
        return patchAlternativeRecording(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code alternativeRecording} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="alternativeRecording")
    public Optional<StreamUploaderChunked> patchChunkedAlternativeRecording() {
        return patchAlternativeRecording(UploadStrategy.chunked());
    }

    @Property(name="alternativeRecording")
    public <T extends StreamUploader<T>> Optional<T> patchAlternativeRecording(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("alternativeRecording"), this, "alternativeRecording", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code alternativeRecording} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="alternativeRecording")
    public Optional<StreamUploaderSingleCall> postAlternativeRecording() {
        return postAlternativeRecording(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code alternativeRecording} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="alternativeRecording")
    public Optional<StreamUploaderChunked> postChunkedAlternativeRecording() {
        return postAlternativeRecording(UploadStrategy.chunked());
    }

    @Property(name="alternativeRecording")
    public <T extends StreamUploader<T>> Optional<T> postAlternativeRecording(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("alternativeRecording"), this, "alternativeRecording", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code alternativeRecording} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="alternativeRecording")
    public Optional<StreamUploaderSingleCall> putAlternativeRecording() {
        return putAlternativeRecording(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code alternativeRecording} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="alternativeRecording")
    public Optional<StreamUploaderChunked> putChunkedAlternativeRecording() {
        return putAlternativeRecording(UploadStrategy.chunked());
    }

    @Property(name="alternativeRecording")
    public <T extends StreamUploader<T>> Optional<T> putAlternativeRecording(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("alternativeRecording"), this, "alternativeRecording", HttpMethod.PUT);
    }

    @Property(name="attendeeReport")
    @JsonIgnore
    public Optional<StreamProvider> getAttendeeReport() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "attendeeReport", attendeeReport);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code attendeeReport} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="attendeeReport")
    public Optional<StreamUploaderSingleCall> patchAttendeeReport() {
        return patchAttendeeReport(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code attendeeReport} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="attendeeReport")
    public Optional<StreamUploaderChunked> patchChunkedAttendeeReport() {
        return patchAttendeeReport(UploadStrategy.chunked());
    }

    @Property(name="attendeeReport")
    public <T extends StreamUploader<T>> Optional<T> patchAttendeeReport(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("attendeeReport"), this, "attendeeReport", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code attendeeReport} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="attendeeReport")
    public Optional<StreamUploaderSingleCall> postAttendeeReport() {
        return postAttendeeReport(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code attendeeReport} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="attendeeReport")
    public Optional<StreamUploaderChunked> postChunkedAttendeeReport() {
        return postAttendeeReport(UploadStrategy.chunked());
    }

    @Property(name="attendeeReport")
    public <T extends StreamUploader<T>> Optional<T> postAttendeeReport(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("attendeeReport"), this, "attendeeReport", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code attendeeReport} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="attendeeReport")
    public Optional<StreamUploaderSingleCall> putAttendeeReport() {
        return putAttendeeReport(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code attendeeReport} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="attendeeReport")
    public Optional<StreamUploaderChunked> putChunkedAttendeeReport() {
        return putAttendeeReport(UploadStrategy.chunked());
    }

    @Property(name="attendeeReport")
    public <T extends StreamUploader<T>> Optional<T> putAttendeeReport(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("attendeeReport"), this, "attendeeReport", HttpMethod.PUT);
    }

    @Property(name="audioConferencing")
    @JsonIgnore
    public Optional<AudioConferencing> getAudioConferencing() {
        return Optional.ofNullable(audioConferencing);
    }

    public OnlineMeeting withAudioConferencing(AudioConferencing audioConferencing) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("audioConferencing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.audioConferencing = audioConferencing;
        return _x;
    }

    @Property(name="broadcastSettings")
    @JsonIgnore
    public Optional<BroadcastMeetingSettings> getBroadcastSettings() {
        return Optional.ofNullable(broadcastSettings);
    }

    public OnlineMeeting withBroadcastSettings(BroadcastMeetingSettings broadcastSettings) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("broadcastSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.broadcastSettings = broadcastSettings;
        return _x;
    }

    @Property(name="canceledDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCanceledDateTime() {
        return Optional.ofNullable(canceledDateTime);
    }

    public OnlineMeeting withCanceledDateTime(OffsetDateTime canceledDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("canceledDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.canceledDateTime = canceledDateTime;
        return _x;
    }

    @Property(name="capabilities")
    @JsonIgnore
    public CollectionPage<MeetingCapabilities> getCapabilities() {
        return new CollectionPage<MeetingCapabilities>(contextPath, MeetingCapabilities.class, this.capabilities, Optional.ofNullable(capabilitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public OnlineMeeting withCapabilities(List<MeetingCapabilities> capabilities) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("capabilities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.capabilities = capabilities;
        return _x;
    }

    @Property(name="capabilities")
    @JsonIgnore
    public CollectionPage<MeetingCapabilities> getCapabilities(HttpRequestOptions options) {
        return new CollectionPage<MeetingCapabilities>(contextPath, MeetingCapabilities.class, this.capabilities, Optional.ofNullable(capabilitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="chatInfo")
    @JsonIgnore
    public Optional<ChatInfo> getChatInfo() {
        return Optional.ofNullable(chatInfo);
    }

    public OnlineMeeting withChatInfo(ChatInfo chatInfo) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("chatInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.chatInfo = chatInfo;
        return _x;
    }

    @Property(name="creationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationDateTime() {
        return Optional.ofNullable(creationDateTime);
    }

    public OnlineMeeting withCreationDateTime(OffsetDateTime creationDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("creationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.creationDateTime = creationDateTime;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public OnlineMeeting withEndDateTime(OffsetDateTime endDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="entryExitAnnouncement")
    @JsonIgnore
    public Optional<Boolean> getEntryExitAnnouncement() {
        return Optional.ofNullable(entryExitAnnouncement);
    }

    public OnlineMeeting withEntryExitAnnouncement(Boolean entryExitAnnouncement) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("entryExitAnnouncement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.entryExitAnnouncement = entryExitAnnouncement;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public OnlineMeeting withExpirationDateTime(OffsetDateTime expirationDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public OnlineMeeting withExternalId(String externalId) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="isBroadcast")
    @JsonIgnore
    public Optional<Boolean> getIsBroadcast() {
        return Optional.ofNullable(isBroadcast);
    }

    public OnlineMeeting withIsBroadcast(Boolean isBroadcast) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("isBroadcast");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.isBroadcast = isBroadcast;
        return _x;
    }

    @Property(name="isCancelled")
    @JsonIgnore
    public Optional<Boolean> getIsCancelled() {
        return Optional.ofNullable(isCancelled);
    }

    public OnlineMeeting withIsCancelled(Boolean isCancelled) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("isCancelled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.isCancelled = isCancelled;
        return _x;
    }

    @Property(name="isEntryExitAnnounced")
    @JsonIgnore
    public Optional<Boolean> getIsEntryExitAnnounced() {
        return Optional.ofNullable(isEntryExitAnnounced);
    }

    public OnlineMeeting withIsEntryExitAnnounced(Boolean isEntryExitAnnounced) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("isEntryExitAnnounced");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.isEntryExitAnnounced = isEntryExitAnnounced;
        return _x;
    }

    @Property(name="joinInformation")
    @JsonIgnore
    public Optional<ItemBody> getJoinInformation() {
        return Optional.ofNullable(joinInformation);
    }

    public OnlineMeeting withJoinInformation(ItemBody joinInformation) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("joinInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.joinInformation = joinInformation;
        return _x;
    }

    @Property(name="joinMeetingIdSettings")
    @JsonIgnore
    public Optional<JoinMeetingIdSettings> getJoinMeetingIdSettings() {
        return Optional.ofNullable(joinMeetingIdSettings);
    }

    public OnlineMeeting withJoinMeetingIdSettings(JoinMeetingIdSettings joinMeetingIdSettings) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("joinMeetingIdSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.joinMeetingIdSettings = joinMeetingIdSettings;
        return _x;
    }

    @Property(name="joinUrl")
    @JsonIgnore
    public Optional<String> getJoinUrl() {
        return Optional.ofNullable(joinUrl);
    }

    public OnlineMeeting withJoinUrl(String joinUrl) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("joinUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.joinUrl = joinUrl;
        return _x;
    }

    @Property(name="lobbyBypassSettings")
    @JsonIgnore
    public Optional<LobbyBypassSettings> getLobbyBypassSettings() {
        return Optional.ofNullable(lobbyBypassSettings);
    }

    public OnlineMeeting withLobbyBypassSettings(LobbyBypassSettings lobbyBypassSettings) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("lobbyBypassSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.lobbyBypassSettings = lobbyBypassSettings;
        return _x;
    }

    @Property(name="participants")
    @JsonIgnore
    public Optional<MeetingParticipants> getParticipants() {
        return Optional.ofNullable(participants);
    }

    public OnlineMeeting withParticipants(MeetingParticipants participants) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("participants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.participants = participants;
        return _x;
    }

    @Property(name="recordAutomatically")
    @JsonIgnore
    public Optional<Boolean> getRecordAutomatically() {
        return Optional.ofNullable(recordAutomatically);
    }

    public OnlineMeeting withRecordAutomatically(Boolean recordAutomatically) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("recordAutomatically");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.recordAutomatically = recordAutomatically;
        return _x;
    }

    @Property(name="recording")
    @JsonIgnore
    public Optional<StreamProvider> getRecording() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "recording", recording);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code recording} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="recording")
    public Optional<StreamUploaderSingleCall> patchRecording() {
        return patchRecording(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code recording} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="recording")
    public Optional<StreamUploaderChunked> patchChunkedRecording() {
        return patchRecording(UploadStrategy.chunked());
    }

    @Property(name="recording")
    public <T extends StreamUploader<T>> Optional<T> patchRecording(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("recording"), this, "recording", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code recording} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="recording")
    public Optional<StreamUploaderSingleCall> postRecording() {
        return postRecording(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code recording} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="recording")
    public Optional<StreamUploaderChunked> postChunkedRecording() {
        return postRecording(UploadStrategy.chunked());
    }

    @Property(name="recording")
    public <T extends StreamUploader<T>> Optional<T> postRecording(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("recording"), this, "recording", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code recording} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="recording")
    public Optional<StreamUploaderSingleCall> putRecording() {
        return putRecording(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code recording} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="recording")
    public Optional<StreamUploaderChunked> putChunkedRecording() {
        return putRecording(UploadStrategy.chunked());
    }

    @Property(name="recording")
    public <T extends StreamUploader<T>> Optional<T> putRecording(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("recording"), this, "recording", HttpMethod.PUT);
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public OnlineMeeting withStartDateTime(OffsetDateTime startDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public OnlineMeeting withSubject(String subject) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.subject = subject;
        return _x;
    }

    @Property(name="videoTeleconferenceId")
    @JsonIgnore
    public Optional<String> getVideoTeleconferenceId() {
        return Optional.ofNullable(videoTeleconferenceId);
    }

    public OnlineMeeting withVideoTeleconferenceId(String videoTeleconferenceId) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("videoTeleconferenceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.videoTeleconferenceId = videoTeleconferenceId;
        return _x;
    }

    public OnlineMeeting withUnmappedField(String name, Object value) {
        OnlineMeeting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="attendanceReports")
    @JsonIgnore
    public MeetingAttendanceReportCollectionRequest getAttendanceReports() {
        return new MeetingAttendanceReportCollectionRequest(
                        contextPath.addSegment("attendanceReports"), Optional.ofNullable(attendanceReports));
    }

    @NavigationProperty(name="meetingAttendanceReport")
    @JsonIgnore
    public MeetingAttendanceReportRequest getMeetingAttendanceReport() {
        return new MeetingAttendanceReportRequest(contextPath.addSegment("meetingAttendanceReport"), Optional.ofNullable(meetingAttendanceReport));
    }

    @NavigationProperty(name="registration")
    @JsonIgnore
    public MeetingRegistrationRequest getRegistration() {
        return new MeetingRegistrationRequest(contextPath.addSegment("registration"), Optional.ofNullable(registration));
    }

    public OnlineMeeting withAttendanceReports(List<MeetingAttendanceReport> attendanceReports) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("attendanceReports");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.attendanceReports = attendanceReports;
        return _x;
    }

    public OnlineMeeting withMeetingAttendanceReport(MeetingAttendanceReport meetingAttendanceReport) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("meetingAttendanceReport");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.meetingAttendanceReport = meetingAttendanceReport;
        return _x;
    }

    public OnlineMeeting withRegistration(MeetingRegistration registration) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("registration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.registration = registration;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnlineMeeting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnlineMeeting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnlineMeeting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnlineMeeting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnlineMeeting _copy() {
        OnlineMeeting _x = new OnlineMeeting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessLevel = accessLevel;
        _x.allowAttendeeToEnableCamera = allowAttendeeToEnableCamera;
        _x.allowAttendeeToEnableMic = allowAttendeeToEnableMic;
        _x.allowedPresenters = allowedPresenters;
        _x.allowMeetingChat = allowMeetingChat;
        _x.allowTeamworkReactions = allowTeamworkReactions;
        _x.alternativeRecording = alternativeRecording;
        _x.attendeeReport = attendeeReport;
        _x.audioConferencing = audioConferencing;
        _x.broadcastSettings = broadcastSettings;
        _x.canceledDateTime = canceledDateTime;
        _x.capabilities = capabilities;
        _x.chatInfo = chatInfo;
        _x.creationDateTime = creationDateTime;
        _x.endDateTime = endDateTime;
        _x.entryExitAnnouncement = entryExitAnnouncement;
        _x.expirationDateTime = expirationDateTime;
        _x.externalId = externalId;
        _x.isBroadcast = isBroadcast;
        _x.isCancelled = isCancelled;
        _x.isEntryExitAnnounced = isEntryExitAnnounced;
        _x.joinInformation = joinInformation;
        _x.joinMeetingIdSettings = joinMeetingIdSettings;
        _x.joinUrl = joinUrl;
        _x.lobbyBypassSettings = lobbyBypassSettings;
        _x.participants = participants;
        _x.recordAutomatically = recordAutomatically;
        _x.recording = recording;
        _x.startDateTime = startDateTime;
        _x.subject = subject;
        _x.videoTeleconferenceId = videoTeleconferenceId;
        _x.attendanceReports = attendanceReports;
        _x.meetingAttendanceReport = meetingAttendanceReport;
        _x.registration = registration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnlineMeeting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessLevel=");
        b.append(this.accessLevel);
        b.append(", ");
        b.append("allowAttendeeToEnableCamera=");
        b.append(this.allowAttendeeToEnableCamera);
        b.append(", ");
        b.append("allowAttendeeToEnableMic=");
        b.append(this.allowAttendeeToEnableMic);
        b.append(", ");
        b.append("allowedPresenters=");
        b.append(this.allowedPresenters);
        b.append(", ");
        b.append("allowMeetingChat=");
        b.append(this.allowMeetingChat);
        b.append(", ");
        b.append("allowTeamworkReactions=");
        b.append(this.allowTeamworkReactions);
        b.append(", ");
        b.append("alternativeRecording=");
        b.append(this.alternativeRecording);
        b.append(", ");
        b.append("attendeeReport=");
        b.append(this.attendeeReport);
        b.append(", ");
        b.append("audioConferencing=");
        b.append(this.audioConferencing);
        b.append(", ");
        b.append("broadcastSettings=");
        b.append(this.broadcastSettings);
        b.append(", ");
        b.append("canceledDateTime=");
        b.append(this.canceledDateTime);
        b.append(", ");
        b.append("capabilities=");
        b.append(this.capabilities);
        b.append(", ");
        b.append("chatInfo=");
        b.append(this.chatInfo);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("entryExitAnnouncement=");
        b.append(this.entryExitAnnouncement);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("isBroadcast=");
        b.append(this.isBroadcast);
        b.append(", ");
        b.append("isCancelled=");
        b.append(this.isCancelled);
        b.append(", ");
        b.append("isEntryExitAnnounced=");
        b.append(this.isEntryExitAnnounced);
        b.append(", ");
        b.append("joinInformation=");
        b.append(this.joinInformation);
        b.append(", ");
        b.append("joinMeetingIdSettings=");
        b.append(this.joinMeetingIdSettings);
        b.append(", ");
        b.append("joinUrl=");
        b.append(this.joinUrl);
        b.append(", ");
        b.append("lobbyBypassSettings=");
        b.append(this.lobbyBypassSettings);
        b.append(", ");
        b.append("participants=");
        b.append(this.participants);
        b.append(", ");
        b.append("recordAutomatically=");
        b.append(this.recordAutomatically);
        b.append(", ");
        b.append("recording=");
        b.append(this.recording);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("videoTeleconferenceId=");
        b.append(this.videoTeleconferenceId);
        b.append(", ");
        b.append("attendanceReports=");
        b.append(this.attendanceReports);
        b.append(", ");
        b.append("meetingAttendanceReport=");
        b.append(this.meetingAttendanceReport);
        b.append(", ");
        b.append("registration=");
        b.append(this.registration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
