package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OnenoteOperationError;
import odata.msgraph.client.beta.enums.OperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "error", 
    "percentComplete", 
    "resourceId", 
    "resourceLocation"})
@JsonInclude(Include.NON_NULL)
public class OnenoteOperation extends Operation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenoteOperation";
    }

    @JsonProperty("error")
    protected OnenoteOperationError error;

    @JsonProperty("percentComplete")
    protected String percentComplete;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("resourceLocation")
    protected String resourceLocation;

    protected OnenoteOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnenoteOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastActionDateTime;
        private OperationStatus status;
        private OnenoteOperationError error;
        private String percentComplete;
        private String resourceId;
        private String resourceLocation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder error(OnenoteOperationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder percentComplete(String percentComplete) {
            this.percentComplete = percentComplete;
            this.changedFields = changedFields.add("percentComplete");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder resourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
            this.changedFields = changedFields.add("resourceLocation");
            return this;
        }

        public OnenoteOperation build() {
            OnenoteOperation _x = new OnenoteOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onenoteOperation";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastActionDateTime = lastActionDateTime;
            _x.status = status;
            _x.error = error;
            _x.percentComplete = percentComplete;
            _x.resourceId = resourceId;
            _x.resourceLocation = resourceLocation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<OnenoteOperationError> getError() {
        return Optional.ofNullable(error);
    }

    public OnenoteOperation withError(OnenoteOperationError error) {
        OnenoteOperation _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteOperation");
        _x.error = error;
        return _x;
    }

    @Property(name="percentComplete")
    @JsonIgnore
    public Optional<String> getPercentComplete() {
        return Optional.ofNullable(percentComplete);
    }

    public OnenoteOperation withPercentComplete(String percentComplete) {
        OnenoteOperation _x = _copy();
        _x.changedFields = changedFields.add("percentComplete");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteOperation");
        _x.percentComplete = percentComplete;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public OnenoteOperation withResourceId(String resourceId) {
        OnenoteOperation _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteOperation");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="resourceLocation")
    @JsonIgnore
    public Optional<String> getResourceLocation() {
        return Optional.ofNullable(resourceLocation);
    }

    public OnenoteOperation withResourceLocation(String resourceLocation) {
        OnenoteOperation _x = _copy();
        _x.changedFields = changedFields.add("resourceLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteOperation");
        _x.resourceLocation = resourceLocation;
        return _x;
    }

    public OnenoteOperation withUnmappedField(String name, Object value) {
        OnenoteOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnenoteOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnenoteOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnenoteOperation _copy() {
        OnenoteOperation _x = new OnenoteOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastActionDateTime = lastActionDateTime;
        _x.status = status;
        _x.error = error;
        _x.percentComplete = percentComplete;
        _x.resourceId = resourceId;
        _x.resourceLocation = resourceLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenoteOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("percentComplete=");
        b.append(this.percentComplete);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("resourceLocation=");
        b.append(this.resourceLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
