package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.NotebookCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenoteOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenotePageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenoteResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "notebooks", 
    "operations", 
    "pages", 
    "resources", 
    "sectionGroups", 
    "sections"})
@JsonInclude(Include.NON_NULL)
public class Onenote extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenote";
    }

    @JsonProperty("notebooks")
    protected List<Notebook> notebooks;

    @JsonProperty("operations")
    protected List<OnenoteOperation> operations;

    @JsonProperty("pages")
    protected List<OnenotePage> pages;

    @JsonProperty("resources")
    protected List<OnenoteResource> resources;

    @JsonProperty("sectionGroups")
    protected List<SectionGroup> sectionGroups;

    @JsonProperty("sections")
    protected List<OnenoteSection> sections;

    protected Onenote() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnenote() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<Notebook> notebooks;
        private List<OnenoteOperation> operations;
        private List<OnenotePage> pages;
        private List<OnenoteResource> resources;
        private List<SectionGroup> sectionGroups;
        private List<OnenoteSection> sections;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder notebooks(List<Notebook> notebooks) {
            this.notebooks = notebooks;
            this.changedFields = changedFields.add("notebooks");
            return this;
        }

        public Builder notebooks(Notebook... notebooks) {
            return notebooks(Arrays.asList(notebooks));
        }

        public Builder operations(List<OnenoteOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(OnenoteOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder pages(List<OnenotePage> pages) {
            this.pages = pages;
            this.changedFields = changedFields.add("pages");
            return this;
        }

        public Builder pages(OnenotePage... pages) {
            return pages(Arrays.asList(pages));
        }

        public Builder resources(List<OnenoteResource> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public Builder resources(OnenoteResource... resources) {
            return resources(Arrays.asList(resources));
        }

        public Builder sectionGroups(List<SectionGroup> sectionGroups) {
            this.sectionGroups = sectionGroups;
            this.changedFields = changedFields.add("sectionGroups");
            return this;
        }

        public Builder sectionGroups(SectionGroup... sectionGroups) {
            return sectionGroups(Arrays.asList(sectionGroups));
        }

        public Builder sections(List<OnenoteSection> sections) {
            this.sections = sections;
            this.changedFields = changedFields.add("sections");
            return this;
        }

        public Builder sections(OnenoteSection... sections) {
            return sections(Arrays.asList(sections));
        }

        public Onenote build() {
            Onenote _x = new Onenote();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onenote";
            _x.id = id;
            _x.notebooks = notebooks;
            _x.operations = operations;
            _x.pages = pages;
            _x.resources = resources;
            _x.sectionGroups = sectionGroups;
            _x.sections = sections;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Onenote withUnmappedField(String name, Object value) {
        Onenote _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="notebooks")
    @JsonIgnore
    public NotebookCollectionRequest getNotebooks() {
        return new NotebookCollectionRequest(
                        contextPath.addSegment("notebooks"), Optional.ofNullable(notebooks));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public OnenoteOperationCollectionRequest getOperations() {
        return new OnenoteOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="pages")
    @JsonIgnore
    public OnenotePageCollectionRequest getPages() {
        return new OnenotePageCollectionRequest(
                        contextPath.addSegment("pages"), Optional.ofNullable(pages));
    }

    @NavigationProperty(name="resources")
    @JsonIgnore
    public OnenoteResourceCollectionRequest getResources() {
        return new OnenoteResourceCollectionRequest(
                        contextPath.addSegment("resources"), Optional.ofNullable(resources));
    }

    @NavigationProperty(name="sectionGroups")
    @JsonIgnore
    public SectionGroupCollectionRequest getSectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"), Optional.ofNullable(sectionGroups));
    }

    @NavigationProperty(name="sections")
    @JsonIgnore
    public OnenoteSectionCollectionRequest getSections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"), Optional.ofNullable(sections));
    }

    public Onenote withNotebooks(List<Notebook> notebooks) {
        Onenote _x = _copy();
        _x.changedFields = changedFields.add("notebooks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenote");
        _x.notebooks = notebooks;
        return _x;
    }

    public Onenote withOperations(List<OnenoteOperation> operations) {
        Onenote _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenote");
        _x.operations = operations;
        return _x;
    }

    public Onenote withPages(List<OnenotePage> pages) {
        Onenote _x = _copy();
        _x.changedFields = changedFields.add("pages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenote");
        _x.pages = pages;
        return _x;
    }

    public Onenote withResources(List<OnenoteResource> resources) {
        Onenote _x = _copy();
        _x.changedFields = changedFields.add("resources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenote");
        _x.resources = resources;
        return _x;
    }

    public Onenote withSectionGroups(List<SectionGroup> sectionGroups) {
        Onenote _x = _copy();
        _x.changedFields = changedFields.add("sectionGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenote");
        _x.sectionGroups = sectionGroups;
        return _x;
    }

    public Onenote withSections(List<OnenoteSection> sections) {
        Onenote _x = _copy();
        _x.changedFields = changedFields.add("sections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenote");
        _x.sections = sections;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Onenote patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Onenote _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Onenote put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Onenote _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Onenote _copy() {
        Onenote _x = new Onenote();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.notebooks = notebooks;
        _x.operations = operations;
        _x.pages = pages;
        _x.resources = resources;
        _x.sectionGroups = sectionGroups;
        _x.sections = sections;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Onenote[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("notebooks=");
        b.append(this.notebooks);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("pages=");
        b.append(this.pages);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append(", ");
        b.append("sectionGroups=");
        b.append(this.sectionGroups);
        b.append(", ");
        b.append("sections=");
        b.append(this.sections);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
