package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.HybridAgentUpdaterConfiguration;
import odata.msgraph.client.beta.entity.collection.request.ConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectorGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PublishedResourceCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "hybridAgentUpdaterConfiguration", 
    "isEnabled", 
    "agentGroups", 
    "agents", 
    "connectorGroups", 
    "connectors", 
    "publishedResources"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesPublishingProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesPublishingProfile";
    }

    @JsonProperty("hybridAgentUpdaterConfiguration")
    protected HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("agentGroups")
    protected List<OnPremisesAgentGroup> agentGroups;

    @JsonProperty("agents")
    protected List<OnPremisesAgent> agents;

    @JsonProperty("connectorGroups")
    protected List<ConnectorGroup> connectorGroups;

    @JsonProperty("connectors")
    protected List<Connector> connectors;

    @JsonProperty("publishedResources")
    protected List<PublishedResource> publishedResources;

    protected OnPremisesPublishingProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnPremisesPublishingProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration;
        private Boolean isEnabled;
        private List<OnPremisesAgentGroup> agentGroups;
        private List<OnPremisesAgent> agents;
        private List<ConnectorGroup> connectorGroups;
        private List<Connector> connectors;
        private List<PublishedResource> publishedResources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder hybridAgentUpdaterConfiguration(HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration) {
            this.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
            this.changedFields = changedFields.add("hybridAgentUpdaterConfiguration");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder agentGroups(List<OnPremisesAgentGroup> agentGroups) {
            this.agentGroups = agentGroups;
            this.changedFields = changedFields.add("agentGroups");
            return this;
        }

        public Builder agentGroups(OnPremisesAgentGroup... agentGroups) {
            return agentGroups(Arrays.asList(agentGroups));
        }

        public Builder agents(List<OnPremisesAgent> agents) {
            this.agents = agents;
            this.changedFields = changedFields.add("agents");
            return this;
        }

        public Builder agents(OnPremisesAgent... agents) {
            return agents(Arrays.asList(agents));
        }

        public Builder connectorGroups(List<ConnectorGroup> connectorGroups) {
            this.connectorGroups = connectorGroups;
            this.changedFields = changedFields.add("connectorGroups");
            return this;
        }

        public Builder connectorGroups(ConnectorGroup... connectorGroups) {
            return connectorGroups(Arrays.asList(connectorGroups));
        }

        public Builder connectors(List<Connector> connectors) {
            this.connectors = connectors;
            this.changedFields = changedFields.add("connectors");
            return this;
        }

        public Builder connectors(Connector... connectors) {
            return connectors(Arrays.asList(connectors));
        }

        public Builder publishedResources(List<PublishedResource> publishedResources) {
            this.publishedResources = publishedResources;
            this.changedFields = changedFields.add("publishedResources");
            return this;
        }

        public Builder publishedResources(PublishedResource... publishedResources) {
            return publishedResources(Arrays.asList(publishedResources));
        }

        public OnPremisesPublishingProfile build() {
            OnPremisesPublishingProfile _x = new OnPremisesPublishingProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onPremisesPublishingProfile";
            _x.id = id;
            _x.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
            _x.isEnabled = isEnabled;
            _x.agentGroups = agentGroups;
            _x.agents = agents;
            _x.connectorGroups = connectorGroups;
            _x.connectors = connectors;
            _x.publishedResources = publishedResources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="hybridAgentUpdaterConfiguration")
    @JsonIgnore
    public Optional<HybridAgentUpdaterConfiguration> getHybridAgentUpdaterConfiguration() {
        return Optional.ofNullable(hybridAgentUpdaterConfiguration);
    }

    public OnPremisesPublishingProfile withHybridAgentUpdaterConfiguration(HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("hybridAgentUpdaterConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public OnPremisesPublishingProfile withIsEnabled(Boolean isEnabled) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.isEnabled = isEnabled;
        return _x;
    }

    public OnPremisesPublishingProfile withUnmappedField(String name, Object value) {
        OnPremisesPublishingProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="agentGroups")
    @JsonIgnore
    public OnPremisesAgentGroupCollectionRequest getAgentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(
                        contextPath.addSegment("agentGroups"), Optional.ofNullable(agentGroups));
    }

    @NavigationProperty(name="agents")
    @JsonIgnore
    public OnPremisesAgentCollectionRequest getAgents() {
        return new OnPremisesAgentCollectionRequest(
                        contextPath.addSegment("agents"), Optional.ofNullable(agents));
    }

    @NavigationProperty(name="connectorGroups")
    @JsonIgnore
    public ConnectorGroupCollectionRequest getConnectorGroups() {
        return new ConnectorGroupCollectionRequest(
                        contextPath.addSegment("connectorGroups"), Optional.ofNullable(connectorGroups));
    }

    @NavigationProperty(name="connectors")
    @JsonIgnore
    public ConnectorCollectionRequest getConnectors() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("connectors"), Optional.ofNullable(connectors));
    }

    @NavigationProperty(name="publishedResources")
    @JsonIgnore
    public PublishedResourceCollectionRequest getPublishedResources() {
        return new PublishedResourceCollectionRequest(
                        contextPath.addSegment("publishedResources"), Optional.ofNullable(publishedResources));
    }

    public OnPremisesPublishingProfile withAgentGroups(List<OnPremisesAgentGroup> agentGroups) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("agentGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.agentGroups = agentGroups;
        return _x;
    }

    public OnPremisesPublishingProfile withAgents(List<OnPremisesAgent> agents) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("agents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.agents = agents;
        return _x;
    }

    public OnPremisesPublishingProfile withConnectorGroups(List<ConnectorGroup> connectorGroups) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("connectorGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.connectorGroups = connectorGroups;
        return _x;
    }

    public OnPremisesPublishingProfile withConnectors(List<Connector> connectors) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("connectors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.connectors = connectors;
        return _x;
    }

    public OnPremisesPublishingProfile withPublishedResources(List<PublishedResource> publishedResources) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("publishedResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.publishedResources = publishedResources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesPublishingProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesPublishingProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnPremisesPublishingProfile _copy() {
        OnPremisesPublishingProfile _x = new OnPremisesPublishingProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
        _x.isEnabled = isEnabled;
        _x.agentGroups = agentGroups;
        _x.agents = agents;
        _x.connectorGroups = connectorGroups;
        _x.connectors = connectors;
        _x.publishedResources = publishedResources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesPublishingProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("hybridAgentUpdaterConfiguration=");
        b.append(this.hybridAgentUpdaterConfiguration);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("agentGroups=");
        b.append(this.agentGroups);
        b.append(", ");
        b.append("agents=");
        b.append(this.agents);
        b.append(", ");
        b.append("connectorGroups=");
        b.append(this.connectorGroups);
        b.append(", ");
        b.append("connectors=");
        b.append(this.connectors);
        b.append(", ");
        b.append("publishedResources=");
        b.append(this.publishedResources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
