package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedProducts", 
    "deletedDate", 
    "displayName", 
    "exchangeLastActivityDate", 
    "exchangeLicenseAssignDate", 
    "hasExchangeLicense", 
    "hasOneDriveLicense", 
    "hasSharePointLicense", 
    "hasSkypeForBusinessLicense", 
    "hasTeamsLicense", 
    "hasYammerLicense", 
    "isDeleted", 
    "oneDriveLastActivityDate", 
    "oneDriveLicenseAssignDate", 
    "reportRefreshDate", 
    "sharePointLastActivityDate", 
    "sharePointLicenseAssignDate", 
    "skypeForBusinessLastActivityDate", 
    "skypeForBusinessLicenseAssignDate", 
    "teamsLastActivityDate", 
    "teamsLicenseAssignDate", 
    "userPrincipalName", 
    "yammerLastActivityDate", 
    "yammerLicenseAssignDate"})
@JsonInclude(Include.NON_NULL)
public class Office365ActiveUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365ActiveUserDetail";
    }

    @JsonProperty("assignedProducts")
    protected List<String> assignedProducts;

    @JsonProperty("assignedProducts@nextLink")
    protected String assignedProductsNextLink;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("exchangeLastActivityDate")
    protected LocalDate exchangeLastActivityDate;

    @JsonProperty("exchangeLicenseAssignDate")
    protected LocalDate exchangeLicenseAssignDate;

    @JsonProperty("hasExchangeLicense")
    protected Boolean hasExchangeLicense;

    @JsonProperty("hasOneDriveLicense")
    protected Boolean hasOneDriveLicense;

    @JsonProperty("hasSharePointLicense")
    protected Boolean hasSharePointLicense;

    @JsonProperty("hasSkypeForBusinessLicense")
    protected Boolean hasSkypeForBusinessLicense;

    @JsonProperty("hasTeamsLicense")
    protected Boolean hasTeamsLicense;

    @JsonProperty("hasYammerLicense")
    protected Boolean hasYammerLicense;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("oneDriveLastActivityDate")
    protected LocalDate oneDriveLastActivityDate;

    @JsonProperty("oneDriveLicenseAssignDate")
    protected LocalDate oneDriveLicenseAssignDate;

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("sharePointLastActivityDate")
    protected LocalDate sharePointLastActivityDate;

    @JsonProperty("sharePointLicenseAssignDate")
    protected LocalDate sharePointLicenseAssignDate;

    @JsonProperty("skypeForBusinessLastActivityDate")
    protected LocalDate skypeForBusinessLastActivityDate;

    @JsonProperty("skypeForBusinessLicenseAssignDate")
    protected LocalDate skypeForBusinessLicenseAssignDate;

    @JsonProperty("teamsLastActivityDate")
    protected LocalDate teamsLastActivityDate;

    @JsonProperty("teamsLicenseAssignDate")
    protected LocalDate teamsLicenseAssignDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("yammerLastActivityDate")
    protected LocalDate yammerLastActivityDate;

    @JsonProperty("yammerLicenseAssignDate")
    protected LocalDate yammerLicenseAssignDate;

    protected Office365ActiveUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365ActiveUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> assignedProducts;
        private String assignedProductsNextLink;
        private LocalDate deletedDate;
        private String displayName;
        private LocalDate exchangeLastActivityDate;
        private LocalDate exchangeLicenseAssignDate;
        private Boolean hasExchangeLicense;
        private Boolean hasOneDriveLicense;
        private Boolean hasSharePointLicense;
        private Boolean hasSkypeForBusinessLicense;
        private Boolean hasTeamsLicense;
        private Boolean hasYammerLicense;
        private Boolean isDeleted;
        private LocalDate oneDriveLastActivityDate;
        private LocalDate oneDriveLicenseAssignDate;
        private LocalDate reportRefreshDate;
        private LocalDate sharePointLastActivityDate;
        private LocalDate sharePointLicenseAssignDate;
        private LocalDate skypeForBusinessLastActivityDate;
        private LocalDate skypeForBusinessLicenseAssignDate;
        private LocalDate teamsLastActivityDate;
        private LocalDate teamsLicenseAssignDate;
        private String userPrincipalName;
        private LocalDate yammerLastActivityDate;
        private LocalDate yammerLicenseAssignDate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder assignedProducts(List<String> assignedProducts) {
            this.assignedProducts = assignedProducts;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder assignedProducts(String... assignedProducts) {
            return assignedProducts(Arrays.asList(assignedProducts));
        }

        public Builder assignedProductsNextLink(String assignedProductsNextLink) {
            this.assignedProductsNextLink = assignedProductsNextLink;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder exchangeLastActivityDate(LocalDate exchangeLastActivityDate) {
            this.exchangeLastActivityDate = exchangeLastActivityDate;
            this.changedFields = changedFields.add("exchangeLastActivityDate");
            return this;
        }

        public Builder exchangeLicenseAssignDate(LocalDate exchangeLicenseAssignDate) {
            this.exchangeLicenseAssignDate = exchangeLicenseAssignDate;
            this.changedFields = changedFields.add("exchangeLicenseAssignDate");
            return this;
        }

        public Builder hasExchangeLicense(Boolean hasExchangeLicense) {
            this.hasExchangeLicense = hasExchangeLicense;
            this.changedFields = changedFields.add("hasExchangeLicense");
            return this;
        }

        public Builder hasOneDriveLicense(Boolean hasOneDriveLicense) {
            this.hasOneDriveLicense = hasOneDriveLicense;
            this.changedFields = changedFields.add("hasOneDriveLicense");
            return this;
        }

        public Builder hasSharePointLicense(Boolean hasSharePointLicense) {
            this.hasSharePointLicense = hasSharePointLicense;
            this.changedFields = changedFields.add("hasSharePointLicense");
            return this;
        }

        public Builder hasSkypeForBusinessLicense(Boolean hasSkypeForBusinessLicense) {
            this.hasSkypeForBusinessLicense = hasSkypeForBusinessLicense;
            this.changedFields = changedFields.add("hasSkypeForBusinessLicense");
            return this;
        }

        public Builder hasTeamsLicense(Boolean hasTeamsLicense) {
            this.hasTeamsLicense = hasTeamsLicense;
            this.changedFields = changedFields.add("hasTeamsLicense");
            return this;
        }

        public Builder hasYammerLicense(Boolean hasYammerLicense) {
            this.hasYammerLicense = hasYammerLicense;
            this.changedFields = changedFields.add("hasYammerLicense");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder oneDriveLastActivityDate(LocalDate oneDriveLastActivityDate) {
            this.oneDriveLastActivityDate = oneDriveLastActivityDate;
            this.changedFields = changedFields.add("oneDriveLastActivityDate");
            return this;
        }

        public Builder oneDriveLicenseAssignDate(LocalDate oneDriveLicenseAssignDate) {
            this.oneDriveLicenseAssignDate = oneDriveLicenseAssignDate;
            this.changedFields = changedFields.add("oneDriveLicenseAssignDate");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder sharePointLastActivityDate(LocalDate sharePointLastActivityDate) {
            this.sharePointLastActivityDate = sharePointLastActivityDate;
            this.changedFields = changedFields.add("sharePointLastActivityDate");
            return this;
        }

        public Builder sharePointLicenseAssignDate(LocalDate sharePointLicenseAssignDate) {
            this.sharePointLicenseAssignDate = sharePointLicenseAssignDate;
            this.changedFields = changedFields.add("sharePointLicenseAssignDate");
            return this;
        }

        public Builder skypeForBusinessLastActivityDate(LocalDate skypeForBusinessLastActivityDate) {
            this.skypeForBusinessLastActivityDate = skypeForBusinessLastActivityDate;
            this.changedFields = changedFields.add("skypeForBusinessLastActivityDate");
            return this;
        }

        public Builder skypeForBusinessLicenseAssignDate(LocalDate skypeForBusinessLicenseAssignDate) {
            this.skypeForBusinessLicenseAssignDate = skypeForBusinessLicenseAssignDate;
            this.changedFields = changedFields.add("skypeForBusinessLicenseAssignDate");
            return this;
        }

        public Builder teamsLastActivityDate(LocalDate teamsLastActivityDate) {
            this.teamsLastActivityDate = teamsLastActivityDate;
            this.changedFields = changedFields.add("teamsLastActivityDate");
            return this;
        }

        public Builder teamsLicenseAssignDate(LocalDate teamsLicenseAssignDate) {
            this.teamsLicenseAssignDate = teamsLicenseAssignDate;
            this.changedFields = changedFields.add("teamsLicenseAssignDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder yammerLastActivityDate(LocalDate yammerLastActivityDate) {
            this.yammerLastActivityDate = yammerLastActivityDate;
            this.changedFields = changedFields.add("yammerLastActivityDate");
            return this;
        }

        public Builder yammerLicenseAssignDate(LocalDate yammerLicenseAssignDate) {
            this.yammerLicenseAssignDate = yammerLicenseAssignDate;
            this.changedFields = changedFields.add("yammerLicenseAssignDate");
            return this;
        }

        public Office365ActiveUserDetail build() {
            Office365ActiveUserDetail _x = new Office365ActiveUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.office365ActiveUserDetail";
            _x.id = id;
            _x.assignedProducts = assignedProducts;
            _x.assignedProductsNextLink = assignedProductsNextLink;
            _x.deletedDate = deletedDate;
            _x.displayName = displayName;
            _x.exchangeLastActivityDate = exchangeLastActivityDate;
            _x.exchangeLicenseAssignDate = exchangeLicenseAssignDate;
            _x.hasExchangeLicense = hasExchangeLicense;
            _x.hasOneDriveLicense = hasOneDriveLicense;
            _x.hasSharePointLicense = hasSharePointLicense;
            _x.hasSkypeForBusinessLicense = hasSkypeForBusinessLicense;
            _x.hasTeamsLicense = hasTeamsLicense;
            _x.hasYammerLicense = hasYammerLicense;
            _x.isDeleted = isDeleted;
            _x.oneDriveLastActivityDate = oneDriveLastActivityDate;
            _x.oneDriveLicenseAssignDate = oneDriveLicenseAssignDate;
            _x.reportRefreshDate = reportRefreshDate;
            _x.sharePointLastActivityDate = sharePointLastActivityDate;
            _x.sharePointLicenseAssignDate = sharePointLicenseAssignDate;
            _x.skypeForBusinessLastActivityDate = skypeForBusinessLastActivityDate;
            _x.skypeForBusinessLicenseAssignDate = skypeForBusinessLicenseAssignDate;
            _x.teamsLastActivityDate = teamsLastActivityDate;
            _x.teamsLicenseAssignDate = teamsLicenseAssignDate;
            _x.userPrincipalName = userPrincipalName;
            _x.yammerLastActivityDate = yammerLastActivityDate;
            _x.yammerLicenseAssignDate = yammerLicenseAssignDate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts() {
        return new CollectionPage<String>(contextPath, String.class, this.assignedProducts, Optional.ofNullable(assignedProductsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Office365ActiveUserDetail withAssignedProducts(List<String> assignedProducts) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("assignedProducts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.assignedProducts = assignedProducts;
        return _x;
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.assignedProducts, Optional.ofNullable(assignedProductsNextLink), Collections.emptyList(), options);
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public Office365ActiveUserDetail withDeletedDate(LocalDate deletedDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Office365ActiveUserDetail withDisplayName(String displayName) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="exchangeLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getExchangeLastActivityDate() {
        return Optional.ofNullable(exchangeLastActivityDate);
    }

    public Office365ActiveUserDetail withExchangeLastActivityDate(LocalDate exchangeLastActivityDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("exchangeLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.exchangeLastActivityDate = exchangeLastActivityDate;
        return _x;
    }

    @Property(name="exchangeLicenseAssignDate")
    @JsonIgnore
    public Optional<LocalDate> getExchangeLicenseAssignDate() {
        return Optional.ofNullable(exchangeLicenseAssignDate);
    }

    public Office365ActiveUserDetail withExchangeLicenseAssignDate(LocalDate exchangeLicenseAssignDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("exchangeLicenseAssignDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.exchangeLicenseAssignDate = exchangeLicenseAssignDate;
        return _x;
    }

    @Property(name="hasExchangeLicense")
    @JsonIgnore
    public Optional<Boolean> getHasExchangeLicense() {
        return Optional.ofNullable(hasExchangeLicense);
    }

    public Office365ActiveUserDetail withHasExchangeLicense(Boolean hasExchangeLicense) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("hasExchangeLicense");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.hasExchangeLicense = hasExchangeLicense;
        return _x;
    }

    @Property(name="hasOneDriveLicense")
    @JsonIgnore
    public Optional<Boolean> getHasOneDriveLicense() {
        return Optional.ofNullable(hasOneDriveLicense);
    }

    public Office365ActiveUserDetail withHasOneDriveLicense(Boolean hasOneDriveLicense) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("hasOneDriveLicense");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.hasOneDriveLicense = hasOneDriveLicense;
        return _x;
    }

    @Property(name="hasSharePointLicense")
    @JsonIgnore
    public Optional<Boolean> getHasSharePointLicense() {
        return Optional.ofNullable(hasSharePointLicense);
    }

    public Office365ActiveUserDetail withHasSharePointLicense(Boolean hasSharePointLicense) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("hasSharePointLicense");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.hasSharePointLicense = hasSharePointLicense;
        return _x;
    }

    @Property(name="hasSkypeForBusinessLicense")
    @JsonIgnore
    public Optional<Boolean> getHasSkypeForBusinessLicense() {
        return Optional.ofNullable(hasSkypeForBusinessLicense);
    }

    public Office365ActiveUserDetail withHasSkypeForBusinessLicense(Boolean hasSkypeForBusinessLicense) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("hasSkypeForBusinessLicense");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.hasSkypeForBusinessLicense = hasSkypeForBusinessLicense;
        return _x;
    }

    @Property(name="hasTeamsLicense")
    @JsonIgnore
    public Optional<Boolean> getHasTeamsLicense() {
        return Optional.ofNullable(hasTeamsLicense);
    }

    public Office365ActiveUserDetail withHasTeamsLicense(Boolean hasTeamsLicense) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("hasTeamsLicense");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.hasTeamsLicense = hasTeamsLicense;
        return _x;
    }

    @Property(name="hasYammerLicense")
    @JsonIgnore
    public Optional<Boolean> getHasYammerLicense() {
        return Optional.ofNullable(hasYammerLicense);
    }

    public Office365ActiveUserDetail withHasYammerLicense(Boolean hasYammerLicense) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("hasYammerLicense");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.hasYammerLicense = hasYammerLicense;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public Office365ActiveUserDetail withIsDeleted(Boolean isDeleted) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="oneDriveLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getOneDriveLastActivityDate() {
        return Optional.ofNullable(oneDriveLastActivityDate);
    }

    public Office365ActiveUserDetail withOneDriveLastActivityDate(LocalDate oneDriveLastActivityDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("oneDriveLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.oneDriveLastActivityDate = oneDriveLastActivityDate;
        return _x;
    }

    @Property(name="oneDriveLicenseAssignDate")
    @JsonIgnore
    public Optional<LocalDate> getOneDriveLicenseAssignDate() {
        return Optional.ofNullable(oneDriveLicenseAssignDate);
    }

    public Office365ActiveUserDetail withOneDriveLicenseAssignDate(LocalDate oneDriveLicenseAssignDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("oneDriveLicenseAssignDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.oneDriveLicenseAssignDate = oneDriveLicenseAssignDate;
        return _x;
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365ActiveUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="sharePointLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getSharePointLastActivityDate() {
        return Optional.ofNullable(sharePointLastActivityDate);
    }

    public Office365ActiveUserDetail withSharePointLastActivityDate(LocalDate sharePointLastActivityDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("sharePointLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.sharePointLastActivityDate = sharePointLastActivityDate;
        return _x;
    }

    @Property(name="sharePointLicenseAssignDate")
    @JsonIgnore
    public Optional<LocalDate> getSharePointLicenseAssignDate() {
        return Optional.ofNullable(sharePointLicenseAssignDate);
    }

    public Office365ActiveUserDetail withSharePointLicenseAssignDate(LocalDate sharePointLicenseAssignDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("sharePointLicenseAssignDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.sharePointLicenseAssignDate = sharePointLicenseAssignDate;
        return _x;
    }

    @Property(name="skypeForBusinessLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getSkypeForBusinessLastActivityDate() {
        return Optional.ofNullable(skypeForBusinessLastActivityDate);
    }

    public Office365ActiveUserDetail withSkypeForBusinessLastActivityDate(LocalDate skypeForBusinessLastActivityDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("skypeForBusinessLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.skypeForBusinessLastActivityDate = skypeForBusinessLastActivityDate;
        return _x;
    }

    @Property(name="skypeForBusinessLicenseAssignDate")
    @JsonIgnore
    public Optional<LocalDate> getSkypeForBusinessLicenseAssignDate() {
        return Optional.ofNullable(skypeForBusinessLicenseAssignDate);
    }

    public Office365ActiveUserDetail withSkypeForBusinessLicenseAssignDate(LocalDate skypeForBusinessLicenseAssignDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("skypeForBusinessLicenseAssignDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.skypeForBusinessLicenseAssignDate = skypeForBusinessLicenseAssignDate;
        return _x;
    }

    @Property(name="teamsLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getTeamsLastActivityDate() {
        return Optional.ofNullable(teamsLastActivityDate);
    }

    public Office365ActiveUserDetail withTeamsLastActivityDate(LocalDate teamsLastActivityDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("teamsLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.teamsLastActivityDate = teamsLastActivityDate;
        return _x;
    }

    @Property(name="teamsLicenseAssignDate")
    @JsonIgnore
    public Optional<LocalDate> getTeamsLicenseAssignDate() {
        return Optional.ofNullable(teamsLicenseAssignDate);
    }

    public Office365ActiveUserDetail withTeamsLicenseAssignDate(LocalDate teamsLicenseAssignDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("teamsLicenseAssignDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.teamsLicenseAssignDate = teamsLicenseAssignDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public Office365ActiveUserDetail withUserPrincipalName(String userPrincipalName) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="yammerLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getYammerLastActivityDate() {
        return Optional.ofNullable(yammerLastActivityDate);
    }

    public Office365ActiveUserDetail withYammerLastActivityDate(LocalDate yammerLastActivityDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("yammerLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.yammerLastActivityDate = yammerLastActivityDate;
        return _x;
    }

    @Property(name="yammerLicenseAssignDate")
    @JsonIgnore
    public Optional<LocalDate> getYammerLicenseAssignDate() {
        return Optional.ofNullable(yammerLicenseAssignDate);
    }

    public Office365ActiveUserDetail withYammerLicenseAssignDate(LocalDate yammerLicenseAssignDate) {
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = changedFields.add("yammerLicenseAssignDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserDetail");
        _x.yammerLicenseAssignDate = yammerLicenseAssignDate;
        return _x;
    }

    public Office365ActiveUserDetail withUnmappedField(String name, Object value) {
        Office365ActiveUserDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActiveUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActiveUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365ActiveUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365ActiveUserDetail _copy() {
        Office365ActiveUserDetail _x = new Office365ActiveUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.assignedProducts = assignedProducts;
        _x.deletedDate = deletedDate;
        _x.displayName = displayName;
        _x.exchangeLastActivityDate = exchangeLastActivityDate;
        _x.exchangeLicenseAssignDate = exchangeLicenseAssignDate;
        _x.hasExchangeLicense = hasExchangeLicense;
        _x.hasOneDriveLicense = hasOneDriveLicense;
        _x.hasSharePointLicense = hasSharePointLicense;
        _x.hasSkypeForBusinessLicense = hasSkypeForBusinessLicense;
        _x.hasTeamsLicense = hasTeamsLicense;
        _x.hasYammerLicense = hasYammerLicense;
        _x.isDeleted = isDeleted;
        _x.oneDriveLastActivityDate = oneDriveLastActivityDate;
        _x.oneDriveLicenseAssignDate = oneDriveLicenseAssignDate;
        _x.reportRefreshDate = reportRefreshDate;
        _x.sharePointLastActivityDate = sharePointLastActivityDate;
        _x.sharePointLicenseAssignDate = sharePointLicenseAssignDate;
        _x.skypeForBusinessLastActivityDate = skypeForBusinessLastActivityDate;
        _x.skypeForBusinessLicenseAssignDate = skypeForBusinessLicenseAssignDate;
        _x.teamsLastActivityDate = teamsLastActivityDate;
        _x.teamsLicenseAssignDate = teamsLicenseAssignDate;
        _x.userPrincipalName = userPrincipalName;
        _x.yammerLastActivityDate = yammerLastActivityDate;
        _x.yammerLicenseAssignDate = yammerLicenseAssignDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365ActiveUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("assignedProducts=");
        b.append(this.assignedProducts);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("exchangeLastActivityDate=");
        b.append(this.exchangeLastActivityDate);
        b.append(", ");
        b.append("exchangeLicenseAssignDate=");
        b.append(this.exchangeLicenseAssignDate);
        b.append(", ");
        b.append("hasExchangeLicense=");
        b.append(this.hasExchangeLicense);
        b.append(", ");
        b.append("hasOneDriveLicense=");
        b.append(this.hasOneDriveLicense);
        b.append(", ");
        b.append("hasSharePointLicense=");
        b.append(this.hasSharePointLicense);
        b.append(", ");
        b.append("hasSkypeForBusinessLicense=");
        b.append(this.hasSkypeForBusinessLicense);
        b.append(", ");
        b.append("hasTeamsLicense=");
        b.append(this.hasTeamsLicense);
        b.append(", ");
        b.append("hasYammerLicense=");
        b.append(this.hasYammerLicense);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("oneDriveLastActivityDate=");
        b.append(this.oneDriveLastActivityDate);
        b.append(", ");
        b.append("oneDriveLicenseAssignDate=");
        b.append(this.oneDriveLicenseAssignDate);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("sharePointLastActivityDate=");
        b.append(this.sharePointLastActivityDate);
        b.append(", ");
        b.append("sharePointLicenseAssignDate=");
        b.append(this.sharePointLicenseAssignDate);
        b.append(", ");
        b.append("skypeForBusinessLastActivityDate=");
        b.append(this.skypeForBusinessLastActivityDate);
        b.append(", ");
        b.append("skypeForBusinessLicenseAssignDate=");
        b.append(this.skypeForBusinessLicenseAssignDate);
        b.append(", ");
        b.append("teamsLastActivityDate=");
        b.append(this.teamsLastActivityDate);
        b.append(", ");
        b.append("teamsLicenseAssignDate=");
        b.append(this.teamsLicenseAssignDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("yammerLastActivityDate=");
        b.append(this.yammerLastActivityDate);
        b.append(", ");
        b.append("yammerLicenseAssignDate=");
        b.append(this.yammerLicenseAssignDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
