package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.enums.OperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "participants"})
@JsonInclude(Include.NON_NULL)
public class MuteParticipantsOperation extends CommsOperation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.muteParticipantsOperation";
    }

    @JsonProperty("participants")
    protected List<String> participants;

    @JsonProperty("participants@nextLink")
    protected String participantsNextLink;

    protected MuteParticipantsOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMuteParticipantsOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String clientContext;
        private ResultInfo resultInfo;
        private OperationStatus status;
        private List<String> participants;
        private String participantsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            this.changedFields = changedFields.add("clientContext");
            return this;
        }

        public Builder resultInfo(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            this.changedFields = changedFields.add("resultInfo");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder participants(List<String> participants) {
            this.participants = participants;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public Builder participants(String... participants) {
            return participants(Arrays.asList(participants));
        }

        public Builder participantsNextLink(String participantsNextLink) {
            this.participantsNextLink = participantsNextLink;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public MuteParticipantsOperation build() {
            MuteParticipantsOperation _x = new MuteParticipantsOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.muteParticipantsOperation";
            _x.id = id;
            _x.clientContext = clientContext;
            _x.resultInfo = resultInfo;
            _x.status = status;
            _x.participants = participants;
            _x.participantsNextLink = participantsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="participants")
    @JsonIgnore
    public CollectionPage<String> getParticipants() {
        return new CollectionPage<String>(contextPath, String.class, this.participants, Optional.ofNullable(participantsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public MuteParticipantsOperation withParticipants(List<String> participants) {
        MuteParticipantsOperation _x = _copy();
        _x.changedFields = changedFields.add("participants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.muteParticipantsOperation");
        _x.participants = participants;
        return _x;
    }

    @Property(name="participants")
    @JsonIgnore
    public CollectionPage<String> getParticipants(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.participants, Optional.ofNullable(participantsNextLink), Collections.emptyList(), options);
    }

    public MuteParticipantsOperation withUnmappedField(String name, Object value) {
        MuteParticipantsOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MuteParticipantsOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MuteParticipantsOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MuteParticipantsOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MuteParticipantsOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MuteParticipantsOperation _copy() {
        MuteParticipantsOperation _x = new MuteParticipantsOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.clientContext = clientContext;
        _x.resultInfo = resultInfo;
        _x.status = status;
        _x.participants = participants;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MuteParticipantsOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("clientContext=");
        b.append(this.clientContext);
        b.append(", ");
        b.append("resultInfo=");
        b.append(this.resultInfo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("participants=");
        b.append(this.participants);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
