package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.enums.PolicyScope;

@JsonPropertyOrder({
    "@odata.type", 
    "appliesTo", 
    "complianceUrl", 
    "description", 
    "discoveryUrl", 
    "displayName", 
    "isValid", 
    "termsOfUseUrl"})
@JsonInclude(Include.NON_NULL)
public class MobilityManagementPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobilityManagementPolicy";
    }

    @JsonProperty("appliesTo")
    protected PolicyScope appliesTo;

    @JsonProperty("complianceUrl")
    protected String complianceUrl;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("discoveryUrl")
    protected String discoveryUrl;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isValid")
    protected Boolean isValid;

    @JsonProperty("termsOfUseUrl")
    protected String termsOfUseUrl;

    protected MobilityManagementPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobilityManagementPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PolicyScope appliesTo;
        private String complianceUrl;
        private String description;
        private String discoveryUrl;
        private String displayName;
        private Boolean isValid;
        private String termsOfUseUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appliesTo(PolicyScope appliesTo) {
            this.appliesTo = appliesTo;
            this.changedFields = changedFields.add("appliesTo");
            return this;
        }

        public Builder complianceUrl(String complianceUrl) {
            this.complianceUrl = complianceUrl;
            this.changedFields = changedFields.add("complianceUrl");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder discoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
            this.changedFields = changedFields.add("discoveryUrl");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isValid(Boolean isValid) {
            this.isValid = isValid;
            this.changedFields = changedFields.add("isValid");
            return this;
        }

        public Builder termsOfUseUrl(String termsOfUseUrl) {
            this.termsOfUseUrl = termsOfUseUrl;
            this.changedFields = changedFields.add("termsOfUseUrl");
            return this;
        }

        public MobilityManagementPolicy build() {
            MobilityManagementPolicy _x = new MobilityManagementPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobilityManagementPolicy";
            _x.id = id;
            _x.appliesTo = appliesTo;
            _x.complianceUrl = complianceUrl;
            _x.description = description;
            _x.discoveryUrl = discoveryUrl;
            _x.displayName = displayName;
            _x.isValid = isValid;
            _x.termsOfUseUrl = termsOfUseUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="appliesTo")
    @JsonIgnore
    public Optional<PolicyScope> getAppliesTo() {
        return Optional.ofNullable(appliesTo);
    }

    public MobilityManagementPolicy withAppliesTo(PolicyScope appliesTo) {
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("appliesTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobilityManagementPolicy");
        _x.appliesTo = appliesTo;
        return _x;
    }

    @Property(name="complianceUrl")
    @JsonIgnore
    public Optional<String> getComplianceUrl() {
        return Optional.ofNullable(complianceUrl);
    }

    public MobilityManagementPolicy withComplianceUrl(String complianceUrl) {
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("complianceUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobilityManagementPolicy");
        _x.complianceUrl = complianceUrl;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public MobilityManagementPolicy withDescription(String description) {
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobilityManagementPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="discoveryUrl")
    @JsonIgnore
    public Optional<String> getDiscoveryUrl() {
        return Optional.ofNullable(discoveryUrl);
    }

    public MobilityManagementPolicy withDiscoveryUrl(String discoveryUrl) {
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("discoveryUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobilityManagementPolicy");
        _x.discoveryUrl = discoveryUrl;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MobilityManagementPolicy withDisplayName(String displayName) {
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobilityManagementPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isValid")
    @JsonIgnore
    public Optional<Boolean> getIsValid() {
        return Optional.ofNullable(isValid);
    }

    public MobilityManagementPolicy withIsValid(Boolean isValid) {
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("isValid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobilityManagementPolicy");
        _x.isValid = isValid;
        return _x;
    }

    @Property(name="termsOfUseUrl")
    @JsonIgnore
    public Optional<String> getTermsOfUseUrl() {
        return Optional.ofNullable(termsOfUseUrl);
    }

    public MobilityManagementPolicy withTermsOfUseUrl(String termsOfUseUrl) {
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("termsOfUseUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobilityManagementPolicy");
        _x.termsOfUseUrl = termsOfUseUrl;
        return _x;
    }

    public MobilityManagementPolicy withUnmappedField(String name, Object value) {
        MobilityManagementPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="includedGroups")
    @JsonIgnore
    public GroupCollectionRequest getIncludedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("includedGroups"), RequestHelper.getValue(unmappedFields, "includedGroups"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobilityManagementPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobilityManagementPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobilityManagementPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobilityManagementPolicy _copy() {
        MobilityManagementPolicy _x = new MobilityManagementPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appliesTo = appliesTo;
        _x.complianceUrl = complianceUrl;
        _x.description = description;
        _x.discoveryUrl = discoveryUrl;
        _x.displayName = displayName;
        _x.isValid = isValid;
        _x.termsOfUseUrl = termsOfUseUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobilityManagementPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appliesTo=");
        b.append(this.appliesTo);
        b.append(", ");
        b.append("complianceUrl=");
        b.append(this.complianceUrl);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("discoveryUrl=");
        b.append(this.discoveryUrl);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isValid=");
        b.append(this.isValid);
        b.append(", ");
        b.append("termsOfUseUrl=");
        b.append(this.termsOfUseUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
