package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementTroubleshootingErrorDetails;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.MobileAppTroubleshootingHistoryItem;
import odata.msgraph.client.beta.entity.collection.request.AppLogCollectionRequestCollectionRequest;


/**
 * <i>“Event representing a users device application install status.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicationId", 
    "history", 
    "managedDeviceIdentifier", 
    "userId", 
    "appLogCollectionRequests"})
@JsonInclude(Include.NON_NULL)
public class MobileAppTroubleshootingEvent extends DeviceManagementTroubleshootingEvent implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppTroubleshootingEvent";
    }

    @JsonProperty("applicationId")
    protected String applicationId;

    @JsonProperty("history")
    protected List<MobileAppTroubleshootingHistoryItem> history;

    @JsonProperty("history@nextLink")
    protected String historyNextLink;

    @JsonProperty("managedDeviceIdentifier")
    protected String managedDeviceIdentifier;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("appLogCollectionRequests")
    protected List<AppLogCollectionRequest> appLogCollectionRequests;

    protected MobileAppTroubleshootingEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppTroubleshootingEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<KeyValuePair> additionalInformation;
        private String additionalInformationNextLink;
        private String correlationId;
        private OffsetDateTime eventDateTime;
        private String eventName;
        private DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;
        private String applicationId;
        private List<MobileAppTroubleshootingHistoryItem> history;
        private String historyNextLink;
        private String managedDeviceIdentifier;
        private String userId;
        private List<AppLogCollectionRequest> appLogCollectionRequests;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder additionalInformation(List<KeyValuePair> additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        public Builder additionalInformation(KeyValuePair... additionalInformation) {
            return additionalInformation(Arrays.asList(additionalInformation));
        }

        public Builder additionalInformationNextLink(String additionalInformationNextLink) {
            this.additionalInformationNextLink = additionalInformationNextLink;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        public Builder eventName(String eventName) {
            this.eventName = eventName;
            this.changedFields = changedFields.add("eventName");
            return this;
        }

        public Builder troubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
            this.troubleshootingErrorDetails = troubleshootingErrorDetails;
            this.changedFields = changedFields.add("troubleshootingErrorDetails");
            return this;
        }

        /**
         * <i>“Intune application identifier.”</i>
         * 
         * @param applicationId
         *            value of {@code applicationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.changedFields = changedFields.add("applicationId");
            return this;
        }

        /**
         * <i>“Intune Mobile Application Troubleshooting History Item”</i>
         * 
         * @param history
         *            value of {@code history} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder history(List<MobileAppTroubleshootingHistoryItem> history) {
            this.history = history;
            this.changedFields = changedFields.add("history");
            return this;
        }

        /**
         * <i>“Intune Mobile Application Troubleshooting History Item”</i>
         * 
         * @param history
         *            value of {@code history} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder history(MobileAppTroubleshootingHistoryItem... history) {
            return history(Arrays.asList(history));
        }

        /**
         * <i>“Intune Mobile Application Troubleshooting History Item”</i>
         * 
         * @param historyNextLink
         *            value of {@code history@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder historyNextLink(String historyNextLink) {
            this.historyNextLink = historyNextLink;
            this.changedFields = changedFields.add("history");
            return this;
        }

        /**
         * <i>“Device identifier created or collected by Intune.”</i>
         * 
         * @param managedDeviceIdentifier
         *            value of {@code managedDeviceIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceIdentifier(String managedDeviceIdentifier) {
            this.managedDeviceIdentifier = managedDeviceIdentifier;
            this.changedFields = changedFields.add("managedDeviceIdentifier");
            return this;
        }

        /**
         * <i>“Identifier for the user that tried to enroll the device.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“The collection property of AppLogUploadRequest.”</i>
         * 
         * @param appLogCollectionRequests
         *            value of {@code appLogCollectionRequests} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appLogCollectionRequests(List<AppLogCollectionRequest> appLogCollectionRequests) {
            this.appLogCollectionRequests = appLogCollectionRequests;
            this.changedFields = changedFields.add("appLogCollectionRequests");
            return this;
        }

        /**
         * <i>“The collection property of AppLogUploadRequest.”</i>
         * 
         * @param appLogCollectionRequests
         *            value of {@code appLogCollectionRequests} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appLogCollectionRequests(AppLogCollectionRequest... appLogCollectionRequests) {
            return appLogCollectionRequests(Arrays.asList(appLogCollectionRequests));
        }

        public MobileAppTroubleshootingEvent build() {
            MobileAppTroubleshootingEvent _x = new MobileAppTroubleshootingEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppTroubleshootingEvent";
            _x.id = id;
            _x.additionalInformation = additionalInformation;
            _x.additionalInformationNextLink = additionalInformationNextLink;
            _x.correlationId = correlationId;
            _x.eventDateTime = eventDateTime;
            _x.eventName = eventName;
            _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
            _x.applicationId = applicationId;
            _x.history = history;
            _x.historyNextLink = historyNextLink;
            _x.managedDeviceIdentifier = managedDeviceIdentifier;
            _x.userId = userId;
            _x.appLogCollectionRequests = appLogCollectionRequests;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Intune application identifier.”</i>
     * 
     * @return property applicationId
     */
    @Property(name="applicationId")
    @JsonIgnore
    public Optional<String> getApplicationId() {
        return Optional.ofNullable(applicationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applicationId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Intune application identifier.”</i>
     * 
     * @param applicationId
     *            new value of {@code applicationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationId} field changed
     */
    public MobileAppTroubleshootingEvent withApplicationId(String applicationId) {
        MobileAppTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("applicationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingEvent");
        _x.applicationId = applicationId;
        return _x;
    }

    /**
     * <i>“Intune Mobile Application Troubleshooting History Item”</i>
     * 
     * @return property history
     */
    @Property(name="history")
    @JsonIgnore
    public CollectionPage<MobileAppTroubleshootingHistoryItem> getHistory() {
        return new CollectionPage<MobileAppTroubleshootingHistoryItem>(contextPath, MobileAppTroubleshootingHistoryItem.class, this.history, Optional.ofNullable(historyNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code history} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Intune Mobile Application Troubleshooting History Item”</i>
     * 
     * @param history
     *            new value of {@code history} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code history} field changed
     */
    public MobileAppTroubleshootingEvent withHistory(List<MobileAppTroubleshootingHistoryItem> history) {
        MobileAppTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("history");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingEvent");
        _x.history = history;
        return _x;
    }

    /**
     * <i>“Intune Mobile Application Troubleshooting History Item”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property history
     */
    @Property(name="history")
    @JsonIgnore
    public CollectionPage<MobileAppTroubleshootingHistoryItem> getHistory(HttpRequestOptions options) {
        return new CollectionPage<MobileAppTroubleshootingHistoryItem>(contextPath, MobileAppTroubleshootingHistoryItem.class, this.history, Optional.ofNullable(historyNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Device identifier created or collected by Intune.”</i>
     * 
     * @return property managedDeviceIdentifier
     */
    @Property(name="managedDeviceIdentifier")
    @JsonIgnore
    public Optional<String> getManagedDeviceIdentifier() {
        return Optional.ofNullable(managedDeviceIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceIdentifier} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device identifier created or collected by Intune.”</i>
     * 
     * @param managedDeviceIdentifier
     *            new value of {@code managedDeviceIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceIdentifier} field changed
     */
    public MobileAppTroubleshootingEvent withManagedDeviceIdentifier(String managedDeviceIdentifier) {
        MobileAppTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingEvent");
        _x.managedDeviceIdentifier = managedDeviceIdentifier;
        return _x;
    }

    /**
     * <i>“Identifier for the user that tried to enroll the device.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier for the user that tried to enroll the device.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public MobileAppTroubleshootingEvent withUserId(String userId) {
        MobileAppTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingEvent");
        _x.userId = userId;
        return _x;
    }

    public MobileAppTroubleshootingEvent withUnmappedField(String name, Object value) {
        MobileAppTroubleshootingEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The collection property of AppLogUploadRequest.”</i>
     * 
     * @return navigational property appLogCollectionRequests
     */
    @NavigationProperty(name="appLogCollectionRequests")
    @JsonIgnore
    public AppLogCollectionRequestCollectionRequest getAppLogCollectionRequests() {
        return new AppLogCollectionRequestCollectionRequest(
                        contextPath.addSegment("appLogCollectionRequests"), Optional.ofNullable(appLogCollectionRequests));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appLogCollectionRequests} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The collection property of AppLogUploadRequest.”</i>
     * 
     * @param appLogCollectionRequests
     *            new value of {@code appLogCollectionRequests} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appLogCollectionRequests} field changed
     */
    public MobileAppTroubleshootingEvent withAppLogCollectionRequests(List<AppLogCollectionRequest> appLogCollectionRequests) {
        MobileAppTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("appLogCollectionRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingEvent");
        _x.appLogCollectionRequests = appLogCollectionRequests;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppTroubleshootingEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppTroubleshootingEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppTroubleshootingEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppTroubleshootingEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppTroubleshootingEvent _copy() {
        MobileAppTroubleshootingEvent _x = new MobileAppTroubleshootingEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.additionalInformation = additionalInformation;
        _x.correlationId = correlationId;
        _x.eventDateTime = eventDateTime;
        _x.eventName = eventName;
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        _x.applicationId = applicationId;
        _x.history = history;
        _x.managedDeviceIdentifier = managedDeviceIdentifier;
        _x.userId = userId;
        _x.appLogCollectionRequests = appLogCollectionRequests;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppTroubleshootingEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("additionalInformation=");
        b.append(this.additionalInformation);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("eventName=");
        b.append(this.eventName);
        b.append(", ");
        b.append("troubleshootingErrorDetails=");
        b.append(this.troubleshootingErrorDetails);
        b.append(", ");
        b.append("applicationId=");
        b.append(this.applicationId);
        b.append(", ");
        b.append("history=");
        b.append(this.history);
        b.append(", ");
        b.append("managedDeviceIdentifier=");
        b.append(this.managedDeviceIdentifier);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("appLogCollectionRequests=");
        b.append(this.appLogCollectionRequests);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
