package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MobileAppRelationshipType;


/**
 * <i>“Describes a relationship between two mobile apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "targetDisplayName", 
    "targetDisplayVersion", 
    "targetId", 
    "targetPublisher", 
    "targetType"})
@JsonInclude(Include.NON_NULL)
public class MobileAppRelationship extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppRelationship";
    }

    @JsonProperty("targetDisplayName")
    protected String targetDisplayName;

    @JsonProperty("targetDisplayVersion")
    protected String targetDisplayVersion;

    @JsonProperty("targetId")
    protected String targetId;

    @JsonProperty("targetPublisher")
    protected String targetPublisher;

    @JsonProperty("targetType")
    protected MobileAppRelationshipType targetType;

    protected MobileAppRelationship() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The target mobile app's display name.”</i>
     * 
     * @return property targetDisplayName
     */
    @Property(name="targetDisplayName")
    @JsonIgnore
    public Optional<String> getTargetDisplayName() {
        return Optional.ofNullable(targetDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The target mobile app's display name.”</i>
     * 
     * @param targetDisplayName
     *            new value of {@code targetDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetDisplayName} field changed
     */
    public MobileAppRelationship withTargetDisplayName(String targetDisplayName) {
        MobileAppRelationship _x = _copy();
        _x.changedFields = changedFields.add("targetDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationship");
        _x.targetDisplayName = targetDisplayName;
        return _x;
    }

    /**
     * <i>“The target mobile app's display version.”</i>
     * 
     * @return property targetDisplayVersion
     */
    @Property(name="targetDisplayVersion")
    @JsonIgnore
    public Optional<String> getTargetDisplayVersion() {
        return Optional.ofNullable(targetDisplayVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetDisplayVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The target mobile app's display version.”</i>
     * 
     * @param targetDisplayVersion
     *            new value of {@code targetDisplayVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetDisplayVersion} field changed
     */
    public MobileAppRelationship withTargetDisplayVersion(String targetDisplayVersion) {
        MobileAppRelationship _x = _copy();
        _x.changedFields = changedFields.add("targetDisplayVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationship");
        _x.targetDisplayVersion = targetDisplayVersion;
        return _x;
    }

    /**
     * <i>“The target mobile app's app id.”</i>
     * 
     * @return property targetId
     */
    @Property(name="targetId")
    @JsonIgnore
    public Optional<String> getTargetId() {
        return Optional.ofNullable(targetId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The target mobile app's app id.”</i>
     * 
     * @param targetId
     *            new value of {@code targetId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetId} field changed
     */
    public MobileAppRelationship withTargetId(String targetId) {
        MobileAppRelationship _x = _copy();
        _x.changedFields = changedFields.add("targetId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationship");
        _x.targetId = targetId;
        return _x;
    }

    /**
     * <i>“The target mobile app's publisher.”</i>
     * 
     * @return property targetPublisher
     */
    @Property(name="targetPublisher")
    @JsonIgnore
    public Optional<String> getTargetPublisher() {
        return Optional.ofNullable(targetPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The target mobile app's publisher.”</i>
     * 
     * @param targetPublisher
     *            new value of {@code targetPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetPublisher} field changed
     */
    public MobileAppRelationship withTargetPublisher(String targetPublisher) {
        MobileAppRelationship _x = _copy();
        _x.changedFields = changedFields.add("targetPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationship");
        _x.targetPublisher = targetPublisher;
        return _x;
    }

    /**
     * <i>“The type of relationship indicating whether the target is a parent or child.”</i>
     * 
     * @return property targetType
     */
    @Property(name="targetType")
    @JsonIgnore
    public Optional<MobileAppRelationshipType> getTargetType() {
        return Optional.ofNullable(targetType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The type of relationship indicating whether the target is a parent or child.”</i>
     * 
     * @param targetType
     *            new value of {@code targetType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetType} field changed
     */
    public MobileAppRelationship withTargetType(MobileAppRelationshipType targetType) {
        MobileAppRelationship _x = _copy();
        _x.changedFields = changedFields.add("targetType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationship");
        _x.targetType = targetType;
        return _x;
    }

    public MobileAppRelationship withUnmappedField(String name, Object value) {
        MobileAppRelationship _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppRelationship patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppRelationship put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppRelationship _copy() {
        MobileAppRelationship _x = new MobileAppRelationship();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.targetDisplayName = targetDisplayName;
        _x.targetDisplayVersion = targetDisplayVersion;
        _x.targetId = targetId;
        _x.targetPublisher = targetPublisher;
        _x.targetType = targetType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppRelationship[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetDisplayName=");
        b.append(this.targetDisplayName);
        b.append(", ");
        b.append("targetDisplayVersion=");
        b.append(this.targetDisplayVersion);
        b.append(", ");
        b.append("targetId=");
        b.append(this.targetId);
        b.append(", ");
        b.append("targetPublisher=");
        b.append(this.targetPublisher);
        b.append(", ");
        b.append("targetType=");
        b.append(this.targetType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
