package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.FileEncryptionInfo;
import odata.msgraph.client.beta.enums.MobileAppContentFileUploadState;


/**
 * <i>“Contains properties for a single installer file that is associated with a given
 * mobileAppContent version.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "azureStorageUri", 
    "azureStorageUriExpirationDateTime", 
    "createdDateTime", 
    "isCommitted", 
    "isDependency", 
    "isFrameworkFile", 
    "manifest", 
    "name", 
    "size", 
    "sizeEncrypted", 
    "uploadState"})
@JsonInclude(Include.NON_NULL)
public class MobileAppContentFile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppContentFile";
    }

    @JsonProperty("azureStorageUri")
    protected String azureStorageUri;

    @JsonProperty("azureStorageUriExpirationDateTime")
    protected OffsetDateTime azureStorageUriExpirationDateTime;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("isCommitted")
    protected Boolean isCommitted;

    @JsonProperty("isDependency")
    protected Boolean isDependency;

    @JsonProperty("isFrameworkFile")
    protected Boolean isFrameworkFile;

    @JsonProperty("manifest")
    protected byte[] manifest;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("size")
    protected Long size;

    @JsonProperty("sizeEncrypted")
    protected Long sizeEncrypted;

    @JsonProperty("uploadState")
    protected MobileAppContentFileUploadState uploadState;

    protected MobileAppContentFile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppContentFile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String azureStorageUri;
        private OffsetDateTime azureStorageUriExpirationDateTime;
        private OffsetDateTime createdDateTime;
        private Boolean isCommitted;
        private Boolean isDependency;
        private Boolean isFrameworkFile;
        private byte[] manifest;
        private String name;
        private Long size;
        private Long sizeEncrypted;
        private MobileAppContentFileUploadState uploadState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The Azure Storage URI.”</i>
         * 
         * @param azureStorageUri
         *            value of {@code azureStorageUri} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureStorageUri(String azureStorageUri) {
            this.azureStorageUri = azureStorageUri;
            this.changedFields = changedFields.add("azureStorageUri");
            return this;
        }

        /**
         * <i>“The time the Azure storage Uri expires.”</i>
         * 
         * @param azureStorageUriExpirationDateTime
         *            value of {@code azureStorageUriExpirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureStorageUriExpirationDateTime(OffsetDateTime azureStorageUriExpirationDateTime) {
            this.azureStorageUriExpirationDateTime = azureStorageUriExpirationDateTime;
            this.changedFields = changedFields.add("azureStorageUriExpirationDateTime");
            return this;
        }

        /**
         * <i>“The time the file was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“A value indicating whether the file is committed.”</i>
         * 
         * @param isCommitted
         *            value of {@code isCommitted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isCommitted(Boolean isCommitted) {
            this.isCommitted = isCommitted;
            this.changedFields = changedFields.add("isCommitted");
            return this;
        }

        /**
         * <i>“Whether the content file is a dependency for the main content file.”</i>
         * 
         * @param isDependency
         *            value of {@code isDependency} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isDependency(Boolean isDependency) {
            this.isDependency = isDependency;
            this.changedFields = changedFields.add("isDependency");
            return this;
        }

        /**
         * <i>“A value indicating whether the file is a framework file.”</i>
         * 
         * @param isFrameworkFile
         *            value of {@code isFrameworkFile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isFrameworkFile(Boolean isFrameworkFile) {
            this.isFrameworkFile = isFrameworkFile;
            this.changedFields = changedFields.add("isFrameworkFile");
            return this;
        }

        /**
         * <i>“The manifest information.”</i>
         * 
         * @param manifest
         *            value of {@code manifest} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manifest(byte[] manifest) {
            this.manifest = manifest;
            this.changedFields = changedFields.add("manifest");
            return this;
        }

        /**
         * <i>“the file name.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“The size of the file prior to encryption.”</i>
         * 
         * @param size
         *            value of {@code size} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        /**
         * <i>“The size of the file after encryption.”</i>
         * 
         * @param sizeEncrypted
         *            value of {@code sizeEncrypted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sizeEncrypted(Long sizeEncrypted) {
            this.sizeEncrypted = sizeEncrypted;
            this.changedFields = changedFields.add("sizeEncrypted");
            return this;
        }

        /**
         * <i>“The state of the current upload request.”</i>
         * 
         * @param uploadState
         *            value of {@code uploadState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uploadState(MobileAppContentFileUploadState uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public MobileAppContentFile build() {
            MobileAppContentFile _x = new MobileAppContentFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppContentFile";
            _x.id = id;
            _x.azureStorageUri = azureStorageUri;
            _x.azureStorageUriExpirationDateTime = azureStorageUriExpirationDateTime;
            _x.createdDateTime = createdDateTime;
            _x.isCommitted = isCommitted;
            _x.isDependency = isDependency;
            _x.isFrameworkFile = isFrameworkFile;
            _x.manifest = manifest;
            _x.name = name;
            _x.size = size;
            _x.sizeEncrypted = sizeEncrypted;
            _x.uploadState = uploadState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The Azure Storage URI.”</i>
     * 
     * @return property azureStorageUri
     */
    @Property(name="azureStorageUri")
    @JsonIgnore
    public Optional<String> getAzureStorageUri() {
        return Optional.ofNullable(azureStorageUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureStorageUri}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Azure Storage URI.”</i>
     * 
     * @param azureStorageUri
     *            new value of {@code azureStorageUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureStorageUri} field changed
     */
    public MobileAppContentFile withAzureStorageUri(String azureStorageUri) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("azureStorageUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.azureStorageUri = azureStorageUri;
        return _x;
    }

    /**
     * <i>“The time the Azure storage Uri expires.”</i>
     * 
     * @return property azureStorageUriExpirationDateTime
     */
    @Property(name="azureStorageUriExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAzureStorageUriExpirationDateTime() {
        return Optional.ofNullable(azureStorageUriExpirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * azureStorageUriExpirationDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The time the Azure storage Uri expires.”</i>
     * 
     * @param azureStorageUriExpirationDateTime
     *            new value of {@code azureStorageUriExpirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureStorageUriExpirationDateTime} field changed
     */
    public MobileAppContentFile withAzureStorageUriExpirationDateTime(OffsetDateTime azureStorageUriExpirationDateTime) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("azureStorageUriExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.azureStorageUriExpirationDateTime = azureStorageUriExpirationDateTime;
        return _x;
    }

    /**
     * <i>“The time the file was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the file was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public MobileAppContentFile withCreatedDateTime(OffsetDateTime createdDateTime) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“A value indicating whether the file is committed.”</i>
     * 
     * @return property isCommitted
     */
    @Property(name="isCommitted")
    @JsonIgnore
    public Optional<Boolean> getIsCommitted() {
        return Optional.ofNullable(isCommitted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isCommitted}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A value indicating whether the file is committed.”</i>
     * 
     * @param isCommitted
     *            new value of {@code isCommitted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isCommitted} field changed
     */
    public MobileAppContentFile withIsCommitted(Boolean isCommitted) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("isCommitted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.isCommitted = isCommitted;
        return _x;
    }

    /**
     * <i>“Whether the content file is a dependency for the main content file.”</i>
     * 
     * @return property isDependency
     */
    @Property(name="isDependency")
    @JsonIgnore
    public Optional<Boolean> getIsDependency() {
        return Optional.ofNullable(isDependency);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDependency}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the content file is a dependency for the main content file.”</i>
     * 
     * @param isDependency
     *            new value of {@code isDependency} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDependency} field changed
     */
    public MobileAppContentFile withIsDependency(Boolean isDependency) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("isDependency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.isDependency = isDependency;
        return _x;
    }

    /**
     * <i>“A value indicating whether the file is a framework file.”</i>
     * 
     * @return property isFrameworkFile
     */
    @Property(name="isFrameworkFile")
    @JsonIgnore
    public Optional<Boolean> getIsFrameworkFile() {
        return Optional.ofNullable(isFrameworkFile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isFrameworkFile}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A value indicating whether the file is a framework file.”</i>
     * 
     * @param isFrameworkFile
     *            new value of {@code isFrameworkFile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isFrameworkFile} field changed
     */
    public MobileAppContentFile withIsFrameworkFile(Boolean isFrameworkFile) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("isFrameworkFile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.isFrameworkFile = isFrameworkFile;
        return _x;
    }

    /**
     * <i>“The manifest information.”</i>
     * 
     * @return property manifest
     */
    @Property(name="manifest")
    @JsonIgnore
    public Optional<byte[]> getManifest() {
        return Optional.ofNullable(manifest);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manifest} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The manifest information.”</i>
     * 
     * @param manifest
     *            new value of {@code manifest} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manifest} field changed
     */
    public MobileAppContentFile withManifest(byte[] manifest) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("manifest");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.manifest = manifest;
        return _x;
    }

    /**
     * <i>“the file name.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“the file name.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public MobileAppContentFile withName(String name) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“The size of the file prior to encryption.”</i>
     * 
     * @return property size
     */
    @Property(name="size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code size} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The size of the file prior to encryption.”</i>
     * 
     * @param size
     *            new value of {@code size} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code size} field changed
     */
    public MobileAppContentFile withSize(Long size) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.size = size;
        return _x;
    }

    /**
     * <i>“The size of the file after encryption.”</i>
     * 
     * @return property sizeEncrypted
     */
    @Property(name="sizeEncrypted")
    @JsonIgnore
    public Optional<Long> getSizeEncrypted() {
        return Optional.ofNullable(sizeEncrypted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sizeEncrypted}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The size of the file after encryption.”</i>
     * 
     * @param sizeEncrypted
     *            new value of {@code sizeEncrypted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sizeEncrypted} field changed
     */
    public MobileAppContentFile withSizeEncrypted(Long sizeEncrypted) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("sizeEncrypted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.sizeEncrypted = sizeEncrypted;
        return _x;
    }

    /**
     * <i>“The state of the current upload request.”</i>
     * 
     * @return property uploadState
     */
    @Property(name="uploadState")
    @JsonIgnore
    public Optional<MobileAppContentFileUploadState> getUploadState() {
        return Optional.ofNullable(uploadState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code uploadState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The state of the current upload request.”</i>
     * 
     * @param uploadState
     *            new value of {@code uploadState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uploadState} field changed
     */
    public MobileAppContentFile withUploadState(MobileAppContentFileUploadState uploadState) {
        MobileAppContentFile _x = _copy();
        _x.changedFields = changedFields.add("uploadState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContentFile");
        _x.uploadState = uploadState;
        return _x;
    }

    public MobileAppContentFile withUnmappedField(String name, Object value) {
        MobileAppContentFile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppContentFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppContentFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppContentFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppContentFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppContentFile _copy() {
        MobileAppContentFile _x = new MobileAppContentFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.azureStorageUri = azureStorageUri;
        _x.azureStorageUriExpirationDateTime = azureStorageUriExpirationDateTime;
        _x.createdDateTime = createdDateTime;
        _x.isCommitted = isCommitted;
        _x.isDependency = isDependency;
        _x.isFrameworkFile = isFrameworkFile;
        _x.manifest = manifest;
        _x.name = name;
        _x.size = size;
        _x.sizeEncrypted = sizeEncrypted;
        _x.uploadState = uploadState;
        return _x;
    }

    @Action(name = "commit")
    @JsonIgnore
    public ActionRequestNoReturn commit(FileEncryptionInfo fileEncryptionInfo) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fileEncryptionInfo", "microsoft.graph.fileEncryptionInfo", fileEncryptionInfo)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.commit"), _parameters);
    }

    @Action(name = "renewUpload")
    @JsonIgnore
    public ActionRequestNoReturn renewUpload() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renewUpload"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppContentFile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("azureStorageUri=");
        b.append(this.azureStorageUri);
        b.append(", ");
        b.append("azureStorageUriExpirationDateTime=");
        b.append(this.azureStorageUriExpirationDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("isCommitted=");
        b.append(this.isCommitted);
        b.append(", ");
        b.append("isDependency=");
        b.append(this.isDependency);
        b.append(", ");
        b.append("isFrameworkFile=");
        b.append(this.isFrameworkFile);
        b.append(", ");
        b.append("manifest=");
        b.append(this.manifest);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("sizeEncrypted=");
        b.append(this.sizeEncrypted);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
