package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MobileAppContentFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;


/**
 * <i>“Contains content properties for a specific app version. Each mobileAppContent
 * can have multiple mobileAppContentFile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "containedApps", 
    "files"})
@JsonInclude(Include.NON_NULL)
public class MobileAppContent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppContent";
    }

    @JsonProperty("containedApps")
    protected List<MobileContainedApp> containedApps;

    @JsonProperty("files")
    protected List<MobileAppContentFile> files;

    protected MobileAppContent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppContent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<MobileContainedApp> containedApps;
        private List<MobileAppContentFile> files;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The collection of contained apps in a MobileLobApp acting as a package.”</i>
         * 
         * @param containedApps
         *            value of {@code containedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder containedApps(List<MobileContainedApp> containedApps) {
            this.containedApps = containedApps;
            this.changedFields = changedFields.add("containedApps");
            return this;
        }

        /**
         * <i>“The collection of contained apps in a MobileLobApp acting as a package.”</i>
         * 
         * @param containedApps
         *            value of {@code containedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder containedApps(MobileContainedApp... containedApps) {
            return containedApps(Arrays.asList(containedApps));
        }

        /**
         * <i>“The list of files for this app content version.”</i>
         * 
         * @param files
         *            value of {@code files} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder files(List<MobileAppContentFile> files) {
            this.files = files;
            this.changedFields = changedFields.add("files");
            return this;
        }

        /**
         * <i>“The list of files for this app content version.”</i>
         * 
         * @param files
         *            value of {@code files} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder files(MobileAppContentFile... files) {
            return files(Arrays.asList(files));
        }

        public MobileAppContent build() {
            MobileAppContent _x = new MobileAppContent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppContent";
            _x.id = id;
            _x.containedApps = containedApps;
            _x.files = files;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public MobileAppContent withUnmappedField(String name, Object value) {
        MobileAppContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The collection of contained apps in a MobileLobApp acting as a package.”</i>
     * 
     * @return navigational property containedApps
     */
    @NavigationProperty(name="containedApps")
    @JsonIgnore
    public MobileContainedAppCollectionRequest getContainedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("containedApps"), Optional.ofNullable(containedApps));
    }

    /**
     * <i>“The list of files for this app content version.”</i>
     * 
     * @return navigational property files
     */
    @NavigationProperty(name="files")
    @JsonIgnore
    public MobileAppContentFileCollectionRequest getFiles() {
        return new MobileAppContentFileCollectionRequest(
                        contextPath.addSegment("files"), Optional.ofNullable(files));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code containedApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The collection of contained apps in a MobileLobApp acting as a package.”</i>
     * 
     * @param containedApps
     *            new value of {@code containedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code containedApps} field changed
     */
    public MobileAppContent withContainedApps(List<MobileContainedApp> containedApps) {
        MobileAppContent _x = _copy();
        _x.changedFields = changedFields.add("containedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContent");
        _x.containedApps = containedApps;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code files} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The list of files for this app content version.”</i>
     * 
     * @param files
     *            new value of {@code files} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code files} field changed
     */
    public MobileAppContent withFiles(List<MobileAppContentFile> files) {
        MobileAppContent _x = _copy();
        _x.changedFields = changedFields.add("files");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppContent");
        _x.files = files;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppContent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppContent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppContent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppContent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppContent _copy() {
        MobileAppContent _x = new MobileAppContent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.containedApps = containedApps;
        _x.files = files;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppContent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("containedApps=");
        b.append(this.containedApps);
        b.append(", ");
        b.append("files=");
        b.append(this.files);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
