package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MicrosoftTunnelLogCollectionStatus;


/**
 * <i>“Entity that stores the server log collection status.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "endDateTime", 
    "expiryDateTime", 
    "requestDateTime", 
    "serverId", 
    "sizeInBytes", 
    "startDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftTunnelServerLogCollectionResponse extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftTunnelServerLogCollectionResponse";
    }

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("expiryDateTime")
    protected OffsetDateTime expiryDateTime;

    @JsonProperty("requestDateTime")
    protected OffsetDateTime requestDateTime;

    @JsonProperty("serverId")
    protected String serverId;

    @JsonProperty("sizeInBytes")
    protected Long sizeInBytes;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("status")
    protected MicrosoftTunnelLogCollectionStatus status;

    protected MicrosoftTunnelServerLogCollectionResponse() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftTunnelServerLogCollectionResponse() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime endDateTime;
        private OffsetDateTime expiryDateTime;
        private OffsetDateTime requestDateTime;
        private String serverId;
        private Long sizeInBytes;
        private OffsetDateTime startDateTime;
        private MicrosoftTunnelLogCollectionStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The end time of the logs collected”</i>
         * 
         * @param endDateTime
         *            value of {@code endDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        /**
         * <i>“The time when the log collection is expired”</i>
         * 
         * @param expiryDateTime
         *            value of {@code expiryDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expiryDateTime(OffsetDateTime expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
            this.changedFields = changedFields.add("expiryDateTime");
            return this;
        }

        /**
         * <i>“The time when the log collection was requested”</i>
         * 
         * @param requestDateTime
         *            value of {@code requestDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requestDateTime(OffsetDateTime requestDateTime) {
            this.requestDateTime = requestDateTime;
            this.changedFields = changedFields.add("requestDateTime");
            return this;
        }

        /**
         * <i>“ID of the server the log collection is requested upon”</i>
         * 
         * @param serverId
         *            value of {@code serverId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serverId(String serverId) {
            this.serverId = serverId;
            this.changedFields = changedFields.add("serverId");
            return this;
        }

        /**
         * <i>“The size of the logs in bytes”</i>
         * 
         * @param sizeInBytes
         *            value of {@code sizeInBytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.changedFields = changedFields.add("sizeInBytes");
            return this;
        }

        /**
         * <i>“The start time of the logs collected”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“The status of log collection”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(MicrosoftTunnelLogCollectionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public MicrosoftTunnelServerLogCollectionResponse build() {
            MicrosoftTunnelServerLogCollectionResponse _x = new MicrosoftTunnelServerLogCollectionResponse();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftTunnelServerLogCollectionResponse";
            _x.id = id;
            _x.endDateTime = endDateTime;
            _x.expiryDateTime = expiryDateTime;
            _x.requestDateTime = requestDateTime;
            _x.serverId = serverId;
            _x.sizeInBytes = sizeInBytes;
            _x.startDateTime = startDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The end time of the logs collected”</i>
     * 
     * @return property endDateTime
     */
    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The end time of the logs collected”</i>
     * 
     * @param endDateTime
     *            new value of {@code endDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endDateTime} field changed
     */
    public MicrosoftTunnelServerLogCollectionResponse withEndDateTime(OffsetDateTime endDateTime) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServerLogCollectionResponse");
        _x.endDateTime = endDateTime;
        return _x;
    }

    /**
     * <i>“The time when the log collection is expired”</i>
     * 
     * @return property expiryDateTime
     */
    @Property(name="expiryDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpiryDateTime() {
        return Optional.ofNullable(expiryDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code expiryDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time when the log collection is expired”</i>
     * 
     * @param expiryDateTime
     *            new value of {@code expiryDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expiryDateTime} field changed
     */
    public MicrosoftTunnelServerLogCollectionResponse withExpiryDateTime(OffsetDateTime expiryDateTime) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("expiryDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServerLogCollectionResponse");
        _x.expiryDateTime = expiryDateTime;
        return _x;
    }

    /**
     * <i>“The time when the log collection was requested”</i>
     * 
     * @return property requestDateTime
     */
    @Property(name="requestDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequestDateTime() {
        return Optional.ofNullable(requestDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requestDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time when the log collection was requested”</i>
     * 
     * @param requestDateTime
     *            new value of {@code requestDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requestDateTime} field changed
     */
    public MicrosoftTunnelServerLogCollectionResponse withRequestDateTime(OffsetDateTime requestDateTime) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("requestDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServerLogCollectionResponse");
        _x.requestDateTime = requestDateTime;
        return _x;
    }

    /**
     * <i>“ID of the server the log collection is requested upon”</i>
     * 
     * @return property serverId
     */
    @Property(name="serverId")
    @JsonIgnore
    public Optional<String> getServerId() {
        return Optional.ofNullable(serverId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serverId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“ID of the server the log collection is requested upon”</i>
     * 
     * @param serverId
     *            new value of {@code serverId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serverId} field changed
     */
    public MicrosoftTunnelServerLogCollectionResponse withServerId(String serverId) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("serverId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServerLogCollectionResponse");
        _x.serverId = serverId;
        return _x;
    }

    /**
     * <i>“The size of the logs in bytes”</i>
     * 
     * @return property sizeInBytes
     */
    @Property(name="sizeInBytes")
    @JsonIgnore
    public Optional<Long> getSizeInBytes() {
        return Optional.ofNullable(sizeInBytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sizeInBytes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The size of the logs in bytes”</i>
     * 
     * @param sizeInBytes
     *            new value of {@code sizeInBytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sizeInBytes} field changed
     */
    public MicrosoftTunnelServerLogCollectionResponse withSizeInBytes(Long sizeInBytes) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("sizeInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServerLogCollectionResponse");
        _x.sizeInBytes = sizeInBytes;
        return _x;
    }

    /**
     * <i>“The start time of the logs collected”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The start time of the logs collected”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public MicrosoftTunnelServerLogCollectionResponse withStartDateTime(OffsetDateTime startDateTime) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServerLogCollectionResponse");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“The status of log collection”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<MicrosoftTunnelLogCollectionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The status of log collection”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public MicrosoftTunnelServerLogCollectionResponse withStatus(MicrosoftTunnelLogCollectionStatus status) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServerLogCollectionResponse");
        _x.status = status;
        return _x;
    }

    public MicrosoftTunnelServerLogCollectionResponse withUnmappedField(String name, Object value) {
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelServerLogCollectionResponse patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelServerLogCollectionResponse put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelServerLogCollectionResponse _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftTunnelServerLogCollectionResponse _copy() {
        MicrosoftTunnelServerLogCollectionResponse _x = new MicrosoftTunnelServerLogCollectionResponse();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.endDateTime = endDateTime;
        _x.expiryDateTime = expiryDateTime;
        _x.requestDateTime = requestDateTime;
        _x.serverId = serverId;
        _x.sizeInBytes = sizeInBytes;
        _x.startDateTime = startDateTime;
        _x.status = status;
        return _x;
    }

    @Action(name = "createDownloadUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> createDownloadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDownloadUrl"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftTunnelServerLogCollectionResponse[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("expiryDateTime=");
        b.append(this.expiryDateTime);
        b.append(", ");
        b.append("requestDateTime=");
        b.append(this.requestDateTime);
        b.append(", ");
        b.append("serverId=");
        b.append(this.serverId);
        b.append(", ");
        b.append("sizeInBytes=");
        b.append(this.sizeInBytes);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
