package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Entity that represents the health thresholds of a health metric.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultHealthyThreshold", 
    "defaultUnhealthyThreshold", 
    "healthyThreshold", 
    "unhealthyThreshold"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftTunnelHealthThreshold extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftTunnelHealthThreshold";
    }

    @JsonProperty("defaultHealthyThreshold")
    protected Long defaultHealthyThreshold;

    @JsonProperty("defaultUnhealthyThreshold")
    protected Long defaultUnhealthyThreshold;

    @JsonProperty("healthyThreshold")
    protected Long healthyThreshold;

    @JsonProperty("unhealthyThreshold")
    protected Long unhealthyThreshold;

    protected MicrosoftTunnelHealthThreshold() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftTunnelHealthThreshold() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long defaultHealthyThreshold;
        private Long defaultUnhealthyThreshold;
        private Long healthyThreshold;
        private Long unhealthyThreshold;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The default threshold for being healthy”</i>
         * 
         * @param defaultHealthyThreshold
         *            value of {@code defaultHealthyThreshold} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultHealthyThreshold(Long defaultHealthyThreshold) {
            this.defaultHealthyThreshold = defaultHealthyThreshold;
            this.changedFields = changedFields.add("defaultHealthyThreshold");
            return this;
        }

        /**
         * <i>“The default threshold for being unhealthy”</i>
         * 
         * @param defaultUnhealthyThreshold
         *            value of {@code defaultUnhealthyThreshold} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultUnhealthyThreshold(Long defaultUnhealthyThreshold) {
            this.defaultUnhealthyThreshold = defaultUnhealthyThreshold;
            this.changedFields = changedFields.add("defaultUnhealthyThreshold");
            return this;
        }

        /**
         * <i>“The threshold for being healthy”</i>
         * 
         * @param healthyThreshold
         *            value of {@code healthyThreshold} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthyThreshold(Long healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            this.changedFields = changedFields.add("healthyThreshold");
            return this;
        }

        /**
         * <i>“The threshold for being unhealthy”</i>
         * 
         * @param unhealthyThreshold
         *            value of {@code unhealthyThreshold} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unhealthyThreshold(Long unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            this.changedFields = changedFields.add("unhealthyThreshold");
            return this;
        }

        public MicrosoftTunnelHealthThreshold build() {
            MicrosoftTunnelHealthThreshold _x = new MicrosoftTunnelHealthThreshold();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftTunnelHealthThreshold";
            _x.id = id;
            _x.defaultHealthyThreshold = defaultHealthyThreshold;
            _x.defaultUnhealthyThreshold = defaultUnhealthyThreshold;
            _x.healthyThreshold = healthyThreshold;
            _x.unhealthyThreshold = unhealthyThreshold;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The default threshold for being healthy”</i>
     * 
     * @return property defaultHealthyThreshold
     */
    @Property(name="defaultHealthyThreshold")
    @JsonIgnore
    public Optional<Long> getDefaultHealthyThreshold() {
        return Optional.ofNullable(defaultHealthyThreshold);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultHealthyThreshold} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The default threshold for being healthy”</i>
     * 
     * @param defaultHealthyThreshold
     *            new value of {@code defaultHealthyThreshold} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultHealthyThreshold} field changed
     */
    public MicrosoftTunnelHealthThreshold withDefaultHealthyThreshold(Long defaultHealthyThreshold) {
        MicrosoftTunnelHealthThreshold _x = _copy();
        _x.changedFields = changedFields.add("defaultHealthyThreshold");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelHealthThreshold");
        _x.defaultHealthyThreshold = defaultHealthyThreshold;
        return _x;
    }

    /**
     * <i>“The default threshold for being unhealthy”</i>
     * 
     * @return property defaultUnhealthyThreshold
     */
    @Property(name="defaultUnhealthyThreshold")
    @JsonIgnore
    public Optional<Long> getDefaultUnhealthyThreshold() {
        return Optional.ofNullable(defaultUnhealthyThreshold);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultUnhealthyThreshold} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The default threshold for being unhealthy”</i>
     * 
     * @param defaultUnhealthyThreshold
     *            new value of {@code defaultUnhealthyThreshold} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultUnhealthyThreshold} field changed
     */
    public MicrosoftTunnelHealthThreshold withDefaultUnhealthyThreshold(Long defaultUnhealthyThreshold) {
        MicrosoftTunnelHealthThreshold _x = _copy();
        _x.changedFields = changedFields.add("defaultUnhealthyThreshold");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelHealthThreshold");
        _x.defaultUnhealthyThreshold = defaultUnhealthyThreshold;
        return _x;
    }

    /**
     * <i>“The threshold for being healthy”</i>
     * 
     * @return property healthyThreshold
     */
    @Property(name="healthyThreshold")
    @JsonIgnore
    public Optional<Long> getHealthyThreshold() {
        return Optional.ofNullable(healthyThreshold);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthyThreshold}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The threshold for being healthy”</i>
     * 
     * @param healthyThreshold
     *            new value of {@code healthyThreshold} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthyThreshold} field changed
     */
    public MicrosoftTunnelHealthThreshold withHealthyThreshold(Long healthyThreshold) {
        MicrosoftTunnelHealthThreshold _x = _copy();
        _x.changedFields = changedFields.add("healthyThreshold");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelHealthThreshold");
        _x.healthyThreshold = healthyThreshold;
        return _x;
    }

    /**
     * <i>“The threshold for being unhealthy”</i>
     * 
     * @return property unhealthyThreshold
     */
    @Property(name="unhealthyThreshold")
    @JsonIgnore
    public Optional<Long> getUnhealthyThreshold() {
        return Optional.ofNullable(unhealthyThreshold);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unhealthyThreshold} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The threshold for being unhealthy”</i>
     * 
     * @param unhealthyThreshold
     *            new value of {@code unhealthyThreshold} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unhealthyThreshold} field changed
     */
    public MicrosoftTunnelHealthThreshold withUnhealthyThreshold(Long unhealthyThreshold) {
        MicrosoftTunnelHealthThreshold _x = _copy();
        _x.changedFields = changedFields.add("unhealthyThreshold");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelHealthThreshold");
        _x.unhealthyThreshold = unhealthyThreshold;
        return _x;
    }

    public MicrosoftTunnelHealthThreshold withUnmappedField(String name, Object value) {
        MicrosoftTunnelHealthThreshold _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelHealthThreshold patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelHealthThreshold _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelHealthThreshold put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelHealthThreshold _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftTunnelHealthThreshold _copy() {
        MicrosoftTunnelHealthThreshold _x = new MicrosoftTunnelHealthThreshold();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.defaultHealthyThreshold = defaultHealthyThreshold;
        _x.defaultUnhealthyThreshold = defaultUnhealthyThreshold;
        _x.healthyThreshold = healthyThreshold;
        _x.unhealthyThreshold = unhealthyThreshold;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftTunnelHealthThreshold[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("defaultHealthyThreshold=");
        b.append(this.defaultHealthyThreshold);
        b.append(", ");
        b.append("defaultUnhealthyThreshold=");
        b.append(this.defaultUnhealthyThreshold);
        b.append(", ");
        b.append("healthyThreshold=");
        b.append(this.healthyThreshold);
        b.append(", ");
        b.append("unhealthyThreshold=");
        b.append(this.unhealthyThreshold);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
