package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.VppLicensingType;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;
import odata.msgraph.client.beta.enums.MicrosoftStoreForBusinessLicenseType;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Microsoft Store for Business Apps. This class does not support Create, Delete,
 * or Update.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "licenseType", 
    "licensingType", 
    "packageIdentityName", 
    "productKey", 
    "totalLicenseCount", 
    "usedLicenseCount", 
    "containedApps"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftStoreForBusinessApp extends MobileApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftStoreForBusinessApp";
    }

    @JsonProperty("licenseType")
    protected MicrosoftStoreForBusinessLicenseType licenseType;

    @JsonProperty("licensingType")
    protected VppLicensingType licensingType;

    @JsonProperty("packageIdentityName")
    protected String packageIdentityName;

    @JsonProperty("productKey")
    protected String productKey;

    @JsonProperty("totalLicenseCount")
    protected Integer totalLicenseCount;

    @JsonProperty("usedLicenseCount")
    protected Integer usedLicenseCount;

    @JsonProperty("containedApps")
    protected List<MobileContainedApp> containedApps;

    protected MicrosoftStoreForBusinessApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftStoreForBusinessApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private MicrosoftStoreForBusinessLicenseType licenseType;
        private VppLicensingType licensingType;
        private String packageIdentityName;
        private String productKey;
        private Integer totalLicenseCount;
        private Integer usedLicenseCount;
        private List<MobileContainedApp> containedApps;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        /**
         * <i>“The app license type”</i>
         * 
         * @param licenseType
         *            value of {@code licenseType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder licenseType(MicrosoftStoreForBusinessLicenseType licenseType) {
            this.licenseType = licenseType;
            this.changedFields = changedFields.add("licenseType");
            return this;
        }

        /**
         * <i>“The supported License Type.”</i>
         * 
         * @param licensingType
         *            value of {@code licensingType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder licensingType(VppLicensingType licensingType) {
            this.licensingType = licensingType;
            this.changedFields = changedFields.add("licensingType");
            return this;
        }

        /**
         * <i>“The app package identifier”</i>
         * 
         * @param packageIdentityName
         *            value of {@code packageIdentityName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder packageIdentityName(String packageIdentityName) {
            this.packageIdentityName = packageIdentityName;
            this.changedFields = changedFields.add("packageIdentityName");
            return this;
        }

        /**
         * <i>“The app product key”</i>
         * 
         * @param productKey
         *            value of {@code productKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productKey(String productKey) {
            this.productKey = productKey;
            this.changedFields = changedFields.add("productKey");
            return this;
        }

        /**
         * <i>“The total number of Microsoft Store for Business licenses.”</i>
         * 
         * @param totalLicenseCount
         *            value of {@code totalLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicenseCount(Integer totalLicenseCount) {
            this.totalLicenseCount = totalLicenseCount;
            this.changedFields = changedFields.add("totalLicenseCount");
            return this;
        }

        /**
         * <i>“The number of Microsoft Store for Business licenses in use.”</i>
         * 
         * @param usedLicenseCount
         *            value of {@code usedLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usedLicenseCount(Integer usedLicenseCount) {
            this.usedLicenseCount = usedLicenseCount;
            this.changedFields = changedFields.add("usedLicenseCount");
            return this;
        }

        /**
         * <i>“The collection of contained apps in a mobileApp acting as a package.”</i>
         * 
         * @param containedApps
         *            value of {@code containedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder containedApps(List<MobileContainedApp> containedApps) {
            this.containedApps = containedApps;
            this.changedFields = changedFields.add("containedApps");
            return this;
        }

        /**
         * <i>“The collection of contained apps in a mobileApp acting as a package.”</i>
         * 
         * @param containedApps
         *            value of {@code containedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder containedApps(MobileContainedApp... containedApps) {
            return containedApps(Arrays.asList(containedApps));
        }

        public MicrosoftStoreForBusinessApp build() {
            MicrosoftStoreForBusinessApp _x = new MicrosoftStoreForBusinessApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftStoreForBusinessApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.licenseType = licenseType;
            _x.licensingType = licensingType;
            _x.packageIdentityName = packageIdentityName;
            _x.productKey = productKey;
            _x.totalLicenseCount = totalLicenseCount;
            _x.usedLicenseCount = usedLicenseCount;
            _x.containedApps = containedApps;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The app license type”</i>
     * 
     * @return property licenseType
     */
    @Property(name="licenseType")
    @JsonIgnore
    public Optional<MicrosoftStoreForBusinessLicenseType> getLicenseType() {
        return Optional.ofNullable(licenseType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code licenseType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The app license type”</i>
     * 
     * @param licenseType
     *            new value of {@code licenseType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code licenseType} field changed
     */
    public MicrosoftStoreForBusinessApp withLicenseType(MicrosoftStoreForBusinessLicenseType licenseType) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("licenseType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.licenseType = licenseType;
        return _x;
    }

    /**
     * <i>“The supported License Type.”</i>
     * 
     * @return property licensingType
     */
    @Property(name="licensingType")
    @JsonIgnore
    public Optional<VppLicensingType> getLicensingType() {
        return Optional.ofNullable(licensingType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code licensingType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The supported License Type.”</i>
     * 
     * @param licensingType
     *            new value of {@code licensingType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code licensingType} field changed
     */
    public MicrosoftStoreForBusinessApp withLicensingType(VppLicensingType licensingType) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("licensingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.licensingType = licensingType;
        return _x;
    }

    /**
     * <i>“The app package identifier”</i>
     * 
     * @return property packageIdentityName
     */
    @Property(name="packageIdentityName")
    @JsonIgnore
    public Optional<String> getPackageIdentityName() {
        return Optional.ofNullable(packageIdentityName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * packageIdentityName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The app package identifier”</i>
     * 
     * @param packageIdentityName
     *            new value of {@code packageIdentityName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code packageIdentityName} field changed
     */
    public MicrosoftStoreForBusinessApp withPackageIdentityName(String packageIdentityName) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("packageIdentityName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.packageIdentityName = packageIdentityName;
        return _x;
    }

    /**
     * <i>“The app product key”</i>
     * 
     * @return property productKey
     */
    @Property(name="productKey")
    @JsonIgnore
    public Optional<String> getProductKey() {
        return Optional.ofNullable(productKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productKey} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app product key”</i>
     * 
     * @param productKey
     *            new value of {@code productKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productKey} field changed
     */
    public MicrosoftStoreForBusinessApp withProductKey(String productKey) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("productKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.productKey = productKey;
        return _x;
    }

    /**
     * <i>“The total number of Microsoft Store for Business licenses.”</i>
     * 
     * @return property totalLicenseCount
     */
    @Property(name="totalLicenseCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicenseCount() {
        return Optional.ofNullable(totalLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalLicenseCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total number of Microsoft Store for Business licenses.”</i>
     * 
     * @param totalLicenseCount
     *            new value of {@code totalLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicenseCount} field changed
     */
    public MicrosoftStoreForBusinessApp withTotalLicenseCount(Integer totalLicenseCount) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("totalLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.totalLicenseCount = totalLicenseCount;
        return _x;
    }

    /**
     * <i>“The number of Microsoft Store for Business licenses in use.”</i>
     * 
     * @return property usedLicenseCount
     */
    @Property(name="usedLicenseCount")
    @JsonIgnore
    public Optional<Integer> getUsedLicenseCount() {
        return Optional.ofNullable(usedLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usedLicenseCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of Microsoft Store for Business licenses in use.”</i>
     * 
     * @param usedLicenseCount
     *            new value of {@code usedLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usedLicenseCount} field changed
     */
    public MicrosoftStoreForBusinessApp withUsedLicenseCount(Integer usedLicenseCount) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("usedLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.usedLicenseCount = usedLicenseCount;
        return _x;
    }

    public MicrosoftStoreForBusinessApp withUnmappedField(String name, Object value) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The collection of contained apps in a mobileApp acting as a package.”</i>
     * 
     * @return navigational property containedApps
     */
    @NavigationProperty(name="containedApps")
    @JsonIgnore
    public MobileContainedAppCollectionRequest getContainedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("containedApps"), Optional.ofNullable(containedApps));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code containedApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The collection of contained apps in a mobileApp acting as a package.”</i>
     * 
     * @param containedApps
     *            new value of {@code containedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code containedApps} field changed
     */
    public MicrosoftStoreForBusinessApp withContainedApps(List<MobileContainedApp> containedApps) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("containedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.containedApps = containedApps;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftStoreForBusinessApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftStoreForBusinessApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftStoreForBusinessApp _copy() {
        MicrosoftStoreForBusinessApp _x = new MicrosoftStoreForBusinessApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.licenseType = licenseType;
        _x.licensingType = licensingType;
        _x.packageIdentityName = packageIdentityName;
        _x.productKey = productKey;
        _x.totalLicenseCount = totalLicenseCount;
        _x.usedLicenseCount = usedLicenseCount;
        _x.containedApps = containedApps;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftStoreForBusinessApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("licenseType=");
        b.append(this.licenseType);
        b.append(", ");
        b.append("licensingType=");
        b.append(this.licensingType);
        b.append(", ");
        b.append("packageIdentityName=");
        b.append(this.packageIdentityName);
        b.append(", ");
        b.append("productKey=");
        b.append(this.productKey);
        b.append(", ");
        b.append("totalLicenseCount=");
        b.append(this.totalLicenseCount);
        b.append(", ");
        b.append("usedLicenseCount=");
        b.append(this.usedLicenseCount);
        b.append(", ");
        b.append("containedApps=");
        b.append(this.containedApps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
