package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MessageRecipientCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "destinationIPAddress", 
    "messageId", 
    "receivedDateTime", 
    "senderEmail", 
    "size", 
    "sourceIPAddress", 
    "subject", 
    "recipients"})
@JsonInclude(Include.NON_NULL)
public class MessageTrace extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.messageTrace";
    }

    @JsonProperty("destinationIPAddress")
    protected String destinationIPAddress;

    @JsonProperty("messageId")
    protected String messageId;

    @JsonProperty("receivedDateTime")
    protected OffsetDateTime receivedDateTime;

    @JsonProperty("senderEmail")
    protected String senderEmail;

    @JsonProperty("size")
    protected Integer size;

    @JsonProperty("sourceIPAddress")
    protected String sourceIPAddress;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("recipients")
    protected List<MessageRecipient> recipients;

    protected MessageTrace() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMessageTrace() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String destinationIPAddress;
        private String messageId;
        private OffsetDateTime receivedDateTime;
        private String senderEmail;
        private Integer size;
        private String sourceIPAddress;
        private String subject;
        private List<MessageRecipient> recipients;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder destinationIPAddress(String destinationIPAddress) {
            this.destinationIPAddress = destinationIPAddress;
            this.changedFields = changedFields.add("destinationIPAddress");
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            this.changedFields = changedFields.add("messageId");
            return this;
        }

        public Builder receivedDateTime(OffsetDateTime receivedDateTime) {
            this.receivedDateTime = receivedDateTime;
            this.changedFields = changedFields.add("receivedDateTime");
            return this;
        }

        public Builder senderEmail(String senderEmail) {
            this.senderEmail = senderEmail;
            this.changedFields = changedFields.add("senderEmail");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder sourceIPAddress(String sourceIPAddress) {
            this.sourceIPAddress = sourceIPAddress;
            this.changedFields = changedFields.add("sourceIPAddress");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder recipients(List<MessageRecipient> recipients) {
            this.recipients = recipients;
            this.changedFields = changedFields.add("recipients");
            return this;
        }

        public Builder recipients(MessageRecipient... recipients) {
            return recipients(Arrays.asList(recipients));
        }

        public MessageTrace build() {
            MessageTrace _x = new MessageTrace();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.messageTrace";
            _x.id = id;
            _x.destinationIPAddress = destinationIPAddress;
            _x.messageId = messageId;
            _x.receivedDateTime = receivedDateTime;
            _x.senderEmail = senderEmail;
            _x.size = size;
            _x.sourceIPAddress = sourceIPAddress;
            _x.subject = subject;
            _x.recipients = recipients;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="destinationIPAddress")
    @JsonIgnore
    public Optional<String> getDestinationIPAddress() {
        return Optional.ofNullable(destinationIPAddress);
    }

    public MessageTrace withDestinationIPAddress(String destinationIPAddress) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("destinationIPAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.destinationIPAddress = destinationIPAddress;
        return _x;
    }

    @Property(name="messageId")
    @JsonIgnore
    public Optional<String> getMessageId() {
        return Optional.ofNullable(messageId);
    }

    public MessageTrace withMessageId(String messageId) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("messageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.messageId = messageId;
        return _x;
    }

    @Property(name="receivedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReceivedDateTime() {
        return Optional.ofNullable(receivedDateTime);
    }

    public MessageTrace withReceivedDateTime(OffsetDateTime receivedDateTime) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("receivedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.receivedDateTime = receivedDateTime;
        return _x;
    }

    @Property(name="senderEmail")
    @JsonIgnore
    public Optional<String> getSenderEmail() {
        return Optional.ofNullable(senderEmail);
    }

    public MessageTrace withSenderEmail(String senderEmail) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("senderEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.senderEmail = senderEmail;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Integer> getSize() {
        return Optional.ofNullable(size);
    }

    public MessageTrace withSize(Integer size) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.size = size;
        return _x;
    }

    @Property(name="sourceIPAddress")
    @JsonIgnore
    public Optional<String> getSourceIPAddress() {
        return Optional.ofNullable(sourceIPAddress);
    }

    public MessageTrace withSourceIPAddress(String sourceIPAddress) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("sourceIPAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.sourceIPAddress = sourceIPAddress;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public MessageTrace withSubject(String subject) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.subject = subject;
        return _x;
    }

    public MessageTrace withUnmappedField(String name, Object value) {
        MessageTrace _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="recipients")
    @JsonIgnore
    public MessageRecipientCollectionRequest getRecipients() {
        return new MessageRecipientCollectionRequest(
                        contextPath.addSegment("recipients"), Optional.ofNullable(recipients));
    }

    public MessageTrace withRecipients(List<MessageRecipient> recipients) {
        MessageTrace _x = _copy();
        _x.changedFields = changedFields.add("recipients");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageTrace");
        _x.recipients = recipients;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MessageTrace patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MessageTrace _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MessageTrace put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MessageTrace _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MessageTrace _copy() {
        MessageTrace _x = new MessageTrace();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.destinationIPAddress = destinationIPAddress;
        _x.messageId = messageId;
        _x.receivedDateTime = receivedDateTime;
        _x.senderEmail = senderEmail;
        _x.size = size;
        _x.sourceIPAddress = sourceIPAddress;
        _x.subject = subject;
        _x.recipients = recipients;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MessageTrace[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("destinationIPAddress=");
        b.append(this.destinationIPAddress);
        b.append(", ");
        b.append("messageId=");
        b.append(this.messageId);
        b.append(", ");
        b.append("receivedDateTime=");
        b.append(this.receivedDateTime);
        b.append(", ");
        b.append("senderEmail=");
        b.append(this.senderEmail);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("sourceIPAddress=");
        b.append(this.sourceIPAddress);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("recipients=");
        b.append(this.recipients);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
