package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MessageEventCollectionRequest;
import odata.msgraph.client.beta.enums.MessageStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "deliveryStatus", 
    "recipientEmail", 
    "events"})
@JsonInclude(Include.NON_NULL)
public class MessageRecipient extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.messageRecipient";
    }

    @JsonProperty("deliveryStatus")
    protected MessageStatus deliveryStatus;

    @JsonProperty("recipientEmail")
    protected String recipientEmail;

    @JsonProperty("events")
    protected List<MessageEvent> events;

    protected MessageRecipient() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMessageRecipient() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private MessageStatus deliveryStatus;
        private String recipientEmail;
        private List<MessageEvent> events;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deliveryStatus(MessageStatus deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            this.changedFields = changedFields.add("deliveryStatus");
            return this;
        }

        public Builder recipientEmail(String recipientEmail) {
            this.recipientEmail = recipientEmail;
            this.changedFields = changedFields.add("recipientEmail");
            return this;
        }

        public Builder events(List<MessageEvent> events) {
            this.events = events;
            this.changedFields = changedFields.add("events");
            return this;
        }

        public Builder events(MessageEvent... events) {
            return events(Arrays.asList(events));
        }

        public MessageRecipient build() {
            MessageRecipient _x = new MessageRecipient();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.messageRecipient";
            _x.id = id;
            _x.deliveryStatus = deliveryStatus;
            _x.recipientEmail = recipientEmail;
            _x.events = events;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="deliveryStatus")
    @JsonIgnore
    public Optional<MessageStatus> getDeliveryStatus() {
        return Optional.ofNullable(deliveryStatus);
    }

    public MessageRecipient withDeliveryStatus(MessageStatus deliveryStatus) {
        MessageRecipient _x = _copy();
        _x.changedFields = changedFields.add("deliveryStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRecipient");
        _x.deliveryStatus = deliveryStatus;
        return _x;
    }

    @Property(name="recipientEmail")
    @JsonIgnore
    public Optional<String> getRecipientEmail() {
        return Optional.ofNullable(recipientEmail);
    }

    public MessageRecipient withRecipientEmail(String recipientEmail) {
        MessageRecipient _x = _copy();
        _x.changedFields = changedFields.add("recipientEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRecipient");
        _x.recipientEmail = recipientEmail;
        return _x;
    }

    public MessageRecipient withUnmappedField(String name, Object value) {
        MessageRecipient _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="events")
    @JsonIgnore
    public MessageEventCollectionRequest getEvents() {
        return new MessageEventCollectionRequest(
                        contextPath.addSegment("events"), Optional.ofNullable(events));
    }

    public MessageRecipient withEvents(List<MessageEvent> events) {
        MessageRecipient _x = _copy();
        _x.changedFields = changedFields.add("events");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRecipient");
        _x.events = events;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MessageRecipient patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MessageRecipient _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MessageRecipient put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MessageRecipient _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MessageRecipient _copy() {
        MessageRecipient _x = new MessageRecipient();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deliveryStatus = deliveryStatus;
        _x.recipientEmail = recipientEmail;
        _x.events = events;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MessageRecipient[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deliveryStatus=");
        b.append(this.deliveryStatus);
        b.append(", ");
        b.append("recipientEmail=");
        b.append(this.recipientEmail);
        b.append(", ");
        b.append("events=");
        b.append(this.events);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
