package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AnswerInputType;

@JsonPropertyOrder({
    "@odata.type", 
    "answerInputType", 
    "answerOptions", 
    "displayName", 
    "isRequired"})
@JsonInclude(Include.NON_NULL)
public class MeetingRegistrationQuestion extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingRegistrationQuestion";
    }

    @JsonProperty("answerInputType")
    protected AnswerInputType answerInputType;

    @JsonProperty("answerOptions")
    protected List<String> answerOptions;

    @JsonProperty("answerOptions@nextLink")
    protected String answerOptionsNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    protected MeetingRegistrationQuestion() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMeetingRegistrationQuestion() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AnswerInputType answerInputType;
        private List<String> answerOptions;
        private String answerOptionsNextLink;
        private String displayName;
        private Boolean isRequired;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder answerInputType(AnswerInputType answerInputType) {
            this.answerInputType = answerInputType;
            this.changedFields = changedFields.add("answerInputType");
            return this;
        }

        public Builder answerOptions(List<String> answerOptions) {
            this.answerOptions = answerOptions;
            this.changedFields = changedFields.add("answerOptions");
            return this;
        }

        public Builder answerOptions(String... answerOptions) {
            return answerOptions(Arrays.asList(answerOptions));
        }

        public Builder answerOptionsNextLink(String answerOptionsNextLink) {
            this.answerOptionsNextLink = answerOptionsNextLink;
            this.changedFields = changedFields.add("answerOptions");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public MeetingRegistrationQuestion build() {
            MeetingRegistrationQuestion _x = new MeetingRegistrationQuestion();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingRegistrationQuestion";
            _x.id = id;
            _x.answerInputType = answerInputType;
            _x.answerOptions = answerOptions;
            _x.answerOptionsNextLink = answerOptionsNextLink;
            _x.displayName = displayName;
            _x.isRequired = isRequired;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="answerInputType")
    @JsonIgnore
    public Optional<AnswerInputType> getAnswerInputType() {
        return Optional.ofNullable(answerInputType);
    }

    public MeetingRegistrationQuestion withAnswerInputType(AnswerInputType answerInputType) {
        MeetingRegistrationQuestion _x = _copy();
        _x.changedFields = changedFields.add("answerInputType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrationQuestion");
        _x.answerInputType = answerInputType;
        return _x;
    }

    @Property(name="answerOptions")
    @JsonIgnore
    public CollectionPage<String> getAnswerOptions() {
        return new CollectionPage<String>(contextPath, String.class, this.answerOptions, Optional.ofNullable(answerOptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public MeetingRegistrationQuestion withAnswerOptions(List<String> answerOptions) {
        MeetingRegistrationQuestion _x = _copy();
        _x.changedFields = changedFields.add("answerOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrationQuestion");
        _x.answerOptions = answerOptions;
        return _x;
    }

    @Property(name="answerOptions")
    @JsonIgnore
    public CollectionPage<String> getAnswerOptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.answerOptions, Optional.ofNullable(answerOptionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MeetingRegistrationQuestion withDisplayName(String displayName) {
        MeetingRegistrationQuestion _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrationQuestion");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    public MeetingRegistrationQuestion withIsRequired(Boolean isRequired) {
        MeetingRegistrationQuestion _x = _copy();
        _x.changedFields = changedFields.add("isRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrationQuestion");
        _x.isRequired = isRequired;
        return _x;
    }

    public MeetingRegistrationQuestion withUnmappedField(String name, Object value) {
        MeetingRegistrationQuestion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistrationQuestion patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistrationQuestion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistrationQuestion put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistrationQuestion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MeetingRegistrationQuestion _copy() {
        MeetingRegistrationQuestion _x = new MeetingRegistrationQuestion();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.answerInputType = answerInputType;
        _x.answerOptions = answerOptions;
        _x.displayName = displayName;
        _x.isRequired = isRequired;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingRegistrationQuestion[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("answerInputType=");
        b.append(this.answerInputType);
        b.append(", ");
        b.append("answerOptions=");
        b.append(this.answerOptions);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
