package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "joinWebUrl"})
@JsonInclude(Include.NON_NULL)
public class MeetingRegistrantBase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingRegistrantBase";
    }

    @JsonProperty("joinWebUrl")
    protected String joinWebUrl;

    protected MeetingRegistrantBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="joinWebUrl")
    @JsonIgnore
    public Optional<String> getJoinWebUrl() {
        return Optional.ofNullable(joinWebUrl);
    }

    public MeetingRegistrantBase withJoinWebUrl(String joinWebUrl) {
        MeetingRegistrantBase _x = _copy();
        _x.changedFields = changedFields.add("joinWebUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrantBase");
        _x.joinWebUrl = joinWebUrl;
        return _x;
    }

    public MeetingRegistrantBase withUnmappedField(String name, Object value) {
        MeetingRegistrantBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistrantBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistrantBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistrantBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistrantBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MeetingRegistrantBase _copy() {
        MeetingRegistrantBase _x = new MeetingRegistrantBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.joinWebUrl = joinWebUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingRegistrantBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("joinWebUrl=");
        b.append(this.joinWebUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
