package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CustomQuestionAnswer;
import odata.msgraph.client.beta.enums.MeetingRegistrantStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "customQuestionAnswers", 
    "email", 
    "firstName", 
    "lastName", 
    "registrationDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class MeetingRegistrant extends MeetingRegistrantBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingRegistrant";
    }

    @JsonProperty("customQuestionAnswers")
    protected List<CustomQuestionAnswer> customQuestionAnswers;

    @JsonProperty("customQuestionAnswers@nextLink")
    protected String customQuestionAnswersNextLink;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("firstName")
    protected String firstName;

    @JsonProperty("lastName")
    protected String lastName;

    @JsonProperty("registrationDateTime")
    protected OffsetDateTime registrationDateTime;

    @JsonProperty("status")
    protected MeetingRegistrantStatus status;

    protected MeetingRegistrant() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMeetingRegistrant() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String joinWebUrl;
        private List<CustomQuestionAnswer> customQuestionAnswers;
        private String customQuestionAnswersNextLink;
        private String email;
        private String firstName;
        private String lastName;
        private OffsetDateTime registrationDateTime;
        private MeetingRegistrantStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder joinWebUrl(String joinWebUrl) {
            this.joinWebUrl = joinWebUrl;
            this.changedFields = changedFields.add("joinWebUrl");
            return this;
        }

        public Builder customQuestionAnswers(List<CustomQuestionAnswer> customQuestionAnswers) {
            this.customQuestionAnswers = customQuestionAnswers;
            this.changedFields = changedFields.add("customQuestionAnswers");
            return this;
        }

        public Builder customQuestionAnswers(CustomQuestionAnswer... customQuestionAnswers) {
            return customQuestionAnswers(Arrays.asList(customQuestionAnswers));
        }

        public Builder customQuestionAnswersNextLink(String customQuestionAnswersNextLink) {
            this.customQuestionAnswersNextLink = customQuestionAnswersNextLink;
            this.changedFields = changedFields.add("customQuestionAnswers");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            this.changedFields = changedFields.add("firstName");
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            this.changedFields = changedFields.add("lastName");
            return this;
        }

        public Builder registrationDateTime(OffsetDateTime registrationDateTime) {
            this.registrationDateTime = registrationDateTime;
            this.changedFields = changedFields.add("registrationDateTime");
            return this;
        }

        public Builder status(MeetingRegistrantStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public MeetingRegistrant build() {
            MeetingRegistrant _x = new MeetingRegistrant();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingRegistrant";
            _x.id = id;
            _x.joinWebUrl = joinWebUrl;
            _x.customQuestionAnswers = customQuestionAnswers;
            _x.customQuestionAnswersNextLink = customQuestionAnswersNextLink;
            _x.email = email;
            _x.firstName = firstName;
            _x.lastName = lastName;
            _x.registrationDateTime = registrationDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="customQuestionAnswers")
    @JsonIgnore
    public CollectionPage<CustomQuestionAnswer> getCustomQuestionAnswers() {
        return new CollectionPage<CustomQuestionAnswer>(contextPath, CustomQuestionAnswer.class, this.customQuestionAnswers, Optional.ofNullable(customQuestionAnswersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public MeetingRegistrant withCustomQuestionAnswers(List<CustomQuestionAnswer> customQuestionAnswers) {
        MeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("customQuestionAnswers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrant");
        _x.customQuestionAnswers = customQuestionAnswers;
        return _x;
    }

    @Property(name="customQuestionAnswers")
    @JsonIgnore
    public CollectionPage<CustomQuestionAnswer> getCustomQuestionAnswers(HttpRequestOptions options) {
        return new CollectionPage<CustomQuestionAnswer>(contextPath, CustomQuestionAnswer.class, this.customQuestionAnswers, Optional.ofNullable(customQuestionAnswersNextLink), Collections.emptyList(), options);
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public MeetingRegistrant withEmail(String email) {
        MeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrant");
        _x.email = email;
        return _x;
    }

    @Property(name="firstName")
    @JsonIgnore
    public Optional<String> getFirstName() {
        return Optional.ofNullable(firstName);
    }

    public MeetingRegistrant withFirstName(String firstName) {
        MeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("firstName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrant");
        _x.firstName = firstName;
        return _x;
    }

    @Property(name="lastName")
    @JsonIgnore
    public Optional<String> getLastName() {
        return Optional.ofNullable(lastName);
    }

    public MeetingRegistrant withLastName(String lastName) {
        MeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("lastName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrant");
        _x.lastName = lastName;
        return _x;
    }

    @Property(name="registrationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRegistrationDateTime() {
        return Optional.ofNullable(registrationDateTime);
    }

    public MeetingRegistrant withRegistrationDateTime(OffsetDateTime registrationDateTime) {
        MeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("registrationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrant");
        _x.registrationDateTime = registrationDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<MeetingRegistrantStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public MeetingRegistrant withStatus(MeetingRegistrantStatus status) {
        MeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistrant");
        _x.status = status;
        return _x;
    }

    public MeetingRegistrant withUnmappedField(String name, Object value) {
        MeetingRegistrant _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistrant patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistrant put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MeetingRegistrant _copy() {
        MeetingRegistrant _x = new MeetingRegistrant();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.joinWebUrl = joinWebUrl;
        _x.customQuestionAnswers = customQuestionAnswers;
        _x.email = email;
        _x.firstName = firstName;
        _x.lastName = lastName;
        _x.registrationDateTime = registrationDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingRegistrant[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("joinWebUrl=");
        b.append(this.joinWebUrl);
        b.append(", ");
        b.append("customQuestionAnswers=");
        b.append(this.customQuestionAnswers);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("firstName=");
        b.append(this.firstName);
        b.append(", ");
        b.append("lastName=");
        b.append(this.lastName);
        b.append(", ");
        b.append("registrationDateTime=");
        b.append(this.registrationDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
