package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ManagementConditionExpression;
import odata.msgraph.client.beta.complex.ManagementConditionExpressionString;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionCollectionRequest;
import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“A management condition statement is a group of management conditions that enable
 * /disable device/application configurations when all contained management
 * conditions are met.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicablePlatforms", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "eTag", 
    "expression", 
    "modifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class ManagementConditionStatement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managementConditionStatement";
    }

    @JsonProperty("applicablePlatforms")
    protected List<DevicePlatformType> applicablePlatforms;

    @JsonProperty("applicablePlatforms@nextLink")
    protected String applicablePlatformsNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("eTag")
    protected String eTag;

    @JsonProperty("expression")
    protected ManagementConditionExpression expression;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    protected ManagementConditionStatement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementConditionStatement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<DevicePlatformType> applicablePlatforms;
        private String applicablePlatformsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private String eTag;
        private ManagementConditionExpression expression;
        private OffsetDateTime modifiedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“This is calculated from looking the management conditions associated to the
         * management condition statement and finding the intersection of applicable
         * platforms.”</i>
         * 
         * @param applicablePlatforms
         *            value of {@code applicablePlatforms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicablePlatforms(List<DevicePlatformType> applicablePlatforms) {
            this.applicablePlatforms = applicablePlatforms;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        /**
         * <i>“This is calculated from looking the management conditions associated to the
         * management condition statement and finding the intersection of applicable
         * platforms.”</i>
         * 
         * @param applicablePlatforms
         *            value of {@code applicablePlatforms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicablePlatforms(DevicePlatformType... applicablePlatforms) {
            return applicablePlatforms(Arrays.asList(applicablePlatforms));
        }

        /**
         * <i>“This is calculated from looking the management conditions associated to the
         * management condition statement and finding the intersection of applicable
         * platforms.”</i>
         * 
         * @param applicablePlatformsNextLink
         *            value of {@code applicablePlatforms@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicablePlatformsNextLink(String applicablePlatformsNextLink) {
            this.applicablePlatformsNextLink = applicablePlatformsNextLink;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        /**
         * <i>“The time the management condition statement was created. Generated service side.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The admin defined description of the management condition statement.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The admin defined name of the management condition statement.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“ETag of the management condition statement. Updated service side.”</i>
         * 
         * @param eTag
         *            value of {@code eTag} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        /**
         * <i>“The management condition statement expression used to evaluate if a management
         * condition statement was activated/deactivated.”</i>
         * 
         * @param expression
         *            value of {@code expression} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expression(ManagementConditionExpression expression) {
            this.expression = expression;
            this.changedFields = changedFields.add("expression");
            return this;
        }

        /**
         * <i>“The time the management condition statement was last modified. Updated service
         * side.”</i>
         * 
         * @param modifiedDateTime
         *            value of {@code modifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public ManagementConditionStatement build() {
            ManagementConditionStatement _x = new ManagementConditionStatement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managementConditionStatement";
            _x.id = id;
            _x.applicablePlatforms = applicablePlatforms;
            _x.applicablePlatformsNextLink = applicablePlatformsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.eTag = eTag;
            _x.expression = expression;
            _x.modifiedDateTime = modifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“This is calculated from looking the management conditions associated to the
     * management condition statement and finding the intersection of applicable
     * platforms.”</i>
     * 
     * @return property applicablePlatforms
     */
    @Property(name="applicablePlatforms")
    @JsonIgnore
    public CollectionPage<DevicePlatformType> getApplicablePlatforms() {
        return new CollectionPage<DevicePlatformType>(contextPath, DevicePlatformType.class, this.applicablePlatforms, Optional.ofNullable(applicablePlatformsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicablePlatforms} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This is calculated from looking the management conditions associated to the
     * management condition statement and finding the intersection of applicable
     * platforms.”</i>
     * 
     * @param applicablePlatforms
     *            new value of {@code applicablePlatforms} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicablePlatforms} field changed
     */
    public ManagementConditionStatement withApplicablePlatforms(List<DevicePlatformType> applicablePlatforms) {
        ManagementConditionStatement _x = _copy();
        _x.changedFields = changedFields.add("applicablePlatforms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementConditionStatement");
        _x.applicablePlatforms = applicablePlatforms;
        return _x;
    }

    /**
     * <i>“This is calculated from looking the management conditions associated to the
     * management condition statement and finding the intersection of applicable
     * platforms.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property applicablePlatforms
     */
    @Property(name="applicablePlatforms")
    @JsonIgnore
    public CollectionPage<DevicePlatformType> getApplicablePlatforms(HttpRequestOptions options) {
        return new CollectionPage<DevicePlatformType>(contextPath, DevicePlatformType.class, this.applicablePlatforms, Optional.ofNullable(applicablePlatformsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The time the management condition statement was created. Generated service side.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the management condition statement was created. Generated service side.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ManagementConditionStatement withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagementConditionStatement _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementConditionStatement");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The admin defined description of the management condition statement.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin defined description of the management condition statement.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ManagementConditionStatement withDescription(String description) {
        ManagementConditionStatement _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementConditionStatement");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The admin defined name of the management condition statement.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin defined name of the management condition statement.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public ManagementConditionStatement withDisplayName(String displayName) {
        ManagementConditionStatement _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementConditionStatement");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“ETag of the management condition statement. Updated service side.”</i>
     * 
     * @return property eTag
     */
    @Property(name="eTag")
    @JsonIgnore
    public Optional<String> getETag() {
        return Optional.ofNullable(eTag);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eTag} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“ETag of the management condition statement. Updated service side.”</i>
     * 
     * @param eTag
     *            new value of {@code eTag} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eTag} field changed
     */
    public ManagementConditionStatement withETag(String eTag) {
        ManagementConditionStatement _x = _copy();
        _x.changedFields = changedFields.add("eTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementConditionStatement");
        _x.eTag = eTag;
        return _x;
    }

    /**
     * <i>“The management condition statement expression used to evaluate if a management
     * condition statement was activated/deactivated.”</i>
     * 
     * @return property expression
     */
    @Property(name="expression")
    @JsonIgnore
    public Optional<ManagementConditionExpression> getExpression() {
        return Optional.ofNullable(expression);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code expression} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The management condition statement expression used to evaluate if a management
     * condition statement was activated/deactivated.”</i>
     * 
     * @param expression
     *            new value of {@code expression} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expression} field changed
     */
    public ManagementConditionStatement withExpression(ManagementConditionExpression expression) {
        ManagementConditionStatement _x = _copy();
        _x.changedFields = changedFields.add("expression");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementConditionStatement");
        _x.expression = expression;
        return _x;
    }

    /**
     * <i>“The time the management condition statement was last modified. Updated service
     * side.”</i>
     * 
     * @return property modifiedDateTime
     */
    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modifiedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the management condition statement was last modified. Updated service
     * side.”</i>
     * 
     * @param modifiedDateTime
     *            new value of {@code modifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modifiedDateTime} field changed
     */
    public ManagementConditionStatement withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        ManagementConditionStatement _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementConditionStatement");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    public ManagementConditionStatement withUnmappedField(String name, Object value) {
        ManagementConditionStatement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The management conditions associated to the management condition statement.”</i>
     * 
     * @return navigational property managementConditions
     */
    @NavigationProperty(name="managementConditions")
    @JsonIgnore
    public ManagementConditionCollectionRequest getManagementConditions() {
        return new ManagementConditionCollectionRequest(
                        contextPath.addSegment("managementConditions"), RequestHelper.getValue(unmappedFields, "managementConditions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementConditionStatement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementConditionStatement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementConditionStatement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementConditionStatement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementConditionStatement _copy() {
        ManagementConditionStatement _x = new ManagementConditionStatement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicablePlatforms = applicablePlatforms;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.eTag = eTag;
        _x.expression = expression;
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @Function(name = "getManagementConditionStatementExpressionString")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ManagementConditionExpressionString> getManagementConditionStatementExpressionString() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ManagementConditionExpressionString>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagementConditionStatementExpressionString"), ManagementConditionExpressionString.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementConditionStatement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicablePlatforms=");
        b.append(this.applicablePlatforms);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("expression=");
        b.append(this.expression);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
