package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IosDeviceType;
import odata.msgraph.client.beta.complex.IosMinimumOperatingSystem;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.ManagedAppAvailability;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for Managed iOS Line Of Business
 * apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicableDeviceType", 
    "buildNumber", 
    "bundleId", 
    "expirationDateTime", 
    "identityVersion", 
    "minimumSupportedOperatingSystem", 
    "versionNumber"})
@JsonInclude(Include.NON_NULL)
public class ManagedIOSLobApp extends ManagedMobileLobApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedIOSLobApp";
    }

    @JsonProperty("applicableDeviceType")
    protected IosDeviceType applicableDeviceType;

    @JsonProperty("buildNumber")
    protected String buildNumber;

    @JsonProperty("bundleId")
    protected String bundleId;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("identityVersion")
    protected String identityVersion;

    @JsonProperty("minimumSupportedOperatingSystem")
    protected IosMinimumOperatingSystem minimumSupportedOperatingSystem;

    @JsonProperty("versionNumber")
    protected String versionNumber;

    protected ManagedIOSLobApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedIOSLobApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private ManagedAppAvailability appAvailability;
        private String version;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private List<MobileAppContent> contentVersions;
        private IosDeviceType applicableDeviceType;
        private String buildNumber;
        private String bundleId;
        private OffsetDateTime expirationDateTime;
        private String identityVersion;
        private IosMinimumOperatingSystem minimumSupportedOperatingSystem;
        private String versionNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder appAvailability(ManagedAppAvailability appAvailability) {
            this.appAvailability = appAvailability;
            this.changedFields = changedFields.add("appAvailability");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder contentVersions(List<MobileAppContent> contentVersions) {
            this.contentVersions = contentVersions;
            this.changedFields = changedFields.add("contentVersions");
            return this;
        }

        public Builder contentVersions(MobileAppContent... contentVersions) {
            return contentVersions(Arrays.asList(contentVersions));
        }

        /**
         * <i>“The iOS architecture for which this app can run on.”</i>
         * 
         * @param applicableDeviceType
         *            value of {@code applicableDeviceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicableDeviceType(IosDeviceType applicableDeviceType) {
            this.applicableDeviceType = applicableDeviceType;
            this.changedFields = changedFields.add("applicableDeviceType");
            return this;
        }

        /**
         * <i>“The build number of managed iOS Line of Business (LoB) app.”</i>
         * 
         * @param buildNumber
         *            value of {@code buildNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder buildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            this.changedFields = changedFields.add("buildNumber");
            return this;
        }

        /**
         * <i>“The Identity Name.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        /**
         * <i>“The expiration time.”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“The identity version.”</i>
         * 
         * @param identityVersion
         *            value of {@code identityVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identityVersion(String identityVersion) {
            this.identityVersion = identityVersion;
            this.changedFields = changedFields.add("identityVersion");
            return this;
        }

        /**
         * <i>“The value for the minimum applicable operating system.”</i>
         * 
         * @param minimumSupportedOperatingSystem
         *            value of {@code minimumSupportedOperatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedOperatingSystem(IosMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        /**
         * <i>“The version number of managed iOS Line of Business (LoB) app.”</i>
         * 
         * @param versionNumber
         *            value of {@code versionNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            this.changedFields = changedFields.add("versionNumber");
            return this;
        }

        public ManagedIOSLobApp build() {
            ManagedIOSLobApp _x = new ManagedIOSLobApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedIOSLobApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.appAvailability = appAvailability;
            _x.version = version;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.contentVersions = contentVersions;
            _x.applicableDeviceType = applicableDeviceType;
            _x.buildNumber = buildNumber;
            _x.bundleId = bundleId;
            _x.expirationDateTime = expirationDateTime;
            _x.identityVersion = identityVersion;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            _x.versionNumber = versionNumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The iOS architecture for which this app can run on.”</i>
     * 
     * @return property applicableDeviceType
     */
    @Property(name="applicableDeviceType")
    @JsonIgnore
    public Optional<IosDeviceType> getApplicableDeviceType() {
        return Optional.ofNullable(applicableDeviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicableDeviceType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The iOS architecture for which this app can run on.”</i>
     * 
     * @param applicableDeviceType
     *            new value of {@code applicableDeviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicableDeviceType} field changed
     */
    public ManagedIOSLobApp withApplicableDeviceType(IosDeviceType applicableDeviceType) {
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("applicableDeviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSLobApp");
        _x.applicableDeviceType = applicableDeviceType;
        return _x;
    }

    /**
     * <i>“The build number of managed iOS Line of Business (LoB) app.”</i>
     * 
     * @return property buildNumber
     */
    @Property(name="buildNumber")
    @JsonIgnore
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(buildNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code buildNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The build number of managed iOS Line of Business (LoB) app.”</i>
     * 
     * @param buildNumber
     *            new value of {@code buildNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code buildNumber} field changed
     */
    public ManagedIOSLobApp withBuildNumber(String buildNumber) {
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("buildNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSLobApp");
        _x.buildNumber = buildNumber;
        return _x;
    }

    /**
     * <i>“The Identity Name.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Identity Name.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public ManagedIOSLobApp withBundleId(String bundleId) {
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("bundleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSLobApp");
        _x.bundleId = bundleId;
        return _x;
    }

    /**
     * <i>“The expiration time.”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The expiration time.”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public ManagedIOSLobApp withExpirationDateTime(OffsetDateTime expirationDateTime) {
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSLobApp");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“The identity version.”</i>
     * 
     * @return property identityVersion
     */
    @Property(name="identityVersion")
    @JsonIgnore
    public Optional<String> getIdentityVersion() {
        return Optional.ofNullable(identityVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identityVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The identity version.”</i>
     * 
     * @param identityVersion
     *            new value of {@code identityVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identityVersion} field changed
     */
    public ManagedIOSLobApp withIdentityVersion(String identityVersion) {
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("identityVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSLobApp");
        _x.identityVersion = identityVersion;
        return _x;
    }

    /**
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @return property minimumSupportedOperatingSystem
     */
    @Property(name="minimumSupportedOperatingSystem")
    @JsonIgnore
    public Optional<IosMinimumOperatingSystem> getMinimumSupportedOperatingSystem() {
        return Optional.ofNullable(minimumSupportedOperatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedOperatingSystem} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @param minimumSupportedOperatingSystem
     *            new value of {@code minimumSupportedOperatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedOperatingSystem} field changed
     */
    public ManagedIOSLobApp withMinimumSupportedOperatingSystem(IosMinimumOperatingSystem minimumSupportedOperatingSystem) {
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumSupportedOperatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSLobApp");
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        return _x;
    }

    /**
     * <i>“The version number of managed iOS Line of Business (LoB) app.”</i>
     * 
     * @return property versionNumber
     */
    @Property(name="versionNumber")
    @JsonIgnore
    public Optional<String> getVersionNumber() {
        return Optional.ofNullable(versionNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code versionNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The version number of managed iOS Line of Business (LoB) app.”</i>
     * 
     * @param versionNumber
     *            new value of {@code versionNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code versionNumber} field changed
     */
    public ManagedIOSLobApp withVersionNumber(String versionNumber) {
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("versionNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSLobApp");
        _x.versionNumber = versionNumber;
        return _x;
    }

    public ManagedIOSLobApp withUnmappedField(String name, Object value) {
        ManagedIOSLobApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedIOSLobApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedIOSLobApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedIOSLobApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedIOSLobApp _copy() {
        ManagedIOSLobApp _x = new ManagedIOSLobApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.appAvailability = appAvailability;
        _x.version = version;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.contentVersions = contentVersions;
        _x.applicableDeviceType = applicableDeviceType;
        _x.buildNumber = buildNumber;
        _x.bundleId = bundleId;
        _x.expirationDateTime = expirationDateTime;
        _x.identityVersion = identityVersion;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        _x.versionNumber = versionNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedIOSLobApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("appAvailability=");
        b.append(this.appAvailability);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("contentVersions=");
        b.append(this.contentVersions);
        b.append(", ");
        b.append("applicableDeviceType=");
        b.append(this.applicableDeviceType);
        b.append(", ");
        b.append("buildNumber=");
        b.append(this.buildNumber);
        b.append(", ");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("identityVersion=");
        b.append(this.identityVersion);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append(", ");
        b.append("versionNumber=");
        b.append(this.versionNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
