package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;


/**
 * <i>“The ManagedAppPolicy resource represents a base type for platform specific
 * policies.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "roleScopeTagIds", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class ManagedAppPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAppPolicy";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("version")
    protected String version;

    protected ManagedAppPolicy() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The date and time the policy was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time the policy was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ManagedAppPolicy withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagedAppPolicy _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicy");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The policy's description.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The policy's description.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ManagedAppPolicy withDescription(String description) {
        ManagedAppPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicy");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Policy display name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Policy display name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public ManagedAppPolicy withDisplayName(String displayName) {
        ManagedAppPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicy");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Last time the policy was modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last time the policy was modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ManagedAppPolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ManagedAppPolicy _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicy");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public ManagedAppPolicy withRoleScopeTagIds(List<String> roleScopeTagIds) {
        ManagedAppPolicy _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicy");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Version of the entity.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the entity.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public ManagedAppPolicy withVersion(String version) {
        ManagedAppPolicy _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicy");
        _x.version = version;
        return _x;
    }

    public ManagedAppPolicy withUnmappedField(String name, Object value) {
        ManagedAppPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedAppPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedAppPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedAppPolicy _copy() {
        ManagedAppPolicy _x = new ManagedAppPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        return _x;
    }

    @Action(name = "targetApps")
    @JsonIgnore
    public ActionRequestNoReturn targetApps(List<ManagedMobileApp> apps) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("apps", "Collection(microsoft.graph.managedMobileApp)", apps)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.targetApps"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAppPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
