package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "filterQuery", 
    "includeNestedFolders", 
    "isSupported", 
    "sourceFolderIds"})
@JsonInclude(Include.NON_NULL)
public class MailSearchFolder extends MailFolder implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mailSearchFolder";
    }

    @JsonProperty("filterQuery")
    protected String filterQuery;

    @JsonProperty("includeNestedFolders")
    protected Boolean includeNestedFolders;

    @JsonProperty("isSupported")
    protected Boolean isSupported;

    @JsonProperty("sourceFolderIds")
    protected List<String> sourceFolderIds;

    @JsonProperty("sourceFolderIds@nextLink")
    protected String sourceFolderIdsNextLink;

    protected MailSearchFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMailSearchFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer childFolderCount;
        private String displayName;
        private Boolean isHidden;
        private String parentFolderId;
        private Integer totalItemCount;
        private Integer unreadItemCount;
        private String wellKnownName;
        private List<MailFolder> childFolders;
        private List<MessageRule> messageRules;
        private List<Message> messages;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private List<UserConfiguration> userConfigurations;
        private String filterQuery;
        private Boolean includeNestedFolders;
        private Boolean isSupported;
        private List<String> sourceFolderIds;
        private String sourceFolderIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder childFolderCount(Integer childFolderCount) {
            this.childFolderCount = childFolderCount;
            this.changedFields = changedFields.add("childFolderCount");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.changedFields = changedFields.add("isHidden");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder totalItemCount(Integer totalItemCount) {
            this.totalItemCount = totalItemCount;
            this.changedFields = changedFields.add("totalItemCount");
            return this;
        }

        public Builder unreadItemCount(Integer unreadItemCount) {
            this.unreadItemCount = unreadItemCount;
            this.changedFields = changedFields.add("unreadItemCount");
            return this;
        }

        public Builder wellKnownName(String wellKnownName) {
            this.wellKnownName = wellKnownName;
            this.changedFields = changedFields.add("wellKnownName");
            return this;
        }

        public Builder childFolders(List<MailFolder> childFolders) {
            this.childFolders = childFolders;
            this.changedFields = changedFields.add("childFolders");
            return this;
        }

        public Builder childFolders(MailFolder... childFolders) {
            return childFolders(Arrays.asList(childFolders));
        }

        public Builder messageRules(List<MessageRule> messageRules) {
            this.messageRules = messageRules;
            this.changedFields = changedFields.add("messageRules");
            return this;
        }

        public Builder messageRules(MessageRule... messageRules) {
            return messageRules(Arrays.asList(messageRules));
        }

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("messages");
            return this;
        }

        public Builder messages(Message... messages) {
            return messages(Arrays.asList(messages));
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        public Builder userConfigurations(List<UserConfiguration> userConfigurations) {
            this.userConfigurations = userConfigurations;
            this.changedFields = changedFields.add("userConfigurations");
            return this;
        }

        public Builder userConfigurations(UserConfiguration... userConfigurations) {
            return userConfigurations(Arrays.asList(userConfigurations));
        }

        public Builder filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            this.changedFields = changedFields.add("filterQuery");
            return this;
        }

        public Builder includeNestedFolders(Boolean includeNestedFolders) {
            this.includeNestedFolders = includeNestedFolders;
            this.changedFields = changedFields.add("includeNestedFolders");
            return this;
        }

        public Builder isSupported(Boolean isSupported) {
            this.isSupported = isSupported;
            this.changedFields = changedFields.add("isSupported");
            return this;
        }

        public Builder sourceFolderIds(List<String> sourceFolderIds) {
            this.sourceFolderIds = sourceFolderIds;
            this.changedFields = changedFields.add("sourceFolderIds");
            return this;
        }

        public Builder sourceFolderIds(String... sourceFolderIds) {
            return sourceFolderIds(Arrays.asList(sourceFolderIds));
        }

        public Builder sourceFolderIdsNextLink(String sourceFolderIdsNextLink) {
            this.sourceFolderIdsNextLink = sourceFolderIdsNextLink;
            this.changedFields = changedFields.add("sourceFolderIds");
            return this;
        }

        public MailSearchFolder build() {
            MailSearchFolder _x = new MailSearchFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mailSearchFolder";
            _x.id = id;
            _x.childFolderCount = childFolderCount;
            _x.displayName = displayName;
            _x.isHidden = isHidden;
            _x.parentFolderId = parentFolderId;
            _x.totalItemCount = totalItemCount;
            _x.unreadItemCount = unreadItemCount;
            _x.wellKnownName = wellKnownName;
            _x.childFolders = childFolders;
            _x.messageRules = messageRules;
            _x.messages = messages;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            _x.userConfigurations = userConfigurations;
            _x.filterQuery = filterQuery;
            _x.includeNestedFolders = includeNestedFolders;
            _x.isSupported = isSupported;
            _x.sourceFolderIds = sourceFolderIds;
            _x.sourceFolderIdsNextLink = sourceFolderIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="filterQuery")
    @JsonIgnore
    public Optional<String> getFilterQuery() {
        return Optional.ofNullable(filterQuery);
    }

    public MailSearchFolder withFilterQuery(String filterQuery) {
        MailSearchFolder _x = _copy();
        _x.changedFields = changedFields.add("filterQuery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailSearchFolder");
        _x.filterQuery = filterQuery;
        return _x;
    }

    @Property(name="includeNestedFolders")
    @JsonIgnore
    public Optional<Boolean> getIncludeNestedFolders() {
        return Optional.ofNullable(includeNestedFolders);
    }

    public MailSearchFolder withIncludeNestedFolders(Boolean includeNestedFolders) {
        MailSearchFolder _x = _copy();
        _x.changedFields = changedFields.add("includeNestedFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailSearchFolder");
        _x.includeNestedFolders = includeNestedFolders;
        return _x;
    }

    @Property(name="isSupported")
    @JsonIgnore
    public Optional<Boolean> getIsSupported() {
        return Optional.ofNullable(isSupported);
    }

    public MailSearchFolder withIsSupported(Boolean isSupported) {
        MailSearchFolder _x = _copy();
        _x.changedFields = changedFields.add("isSupported");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailSearchFolder");
        _x.isSupported = isSupported;
        return _x;
    }

    @Property(name="sourceFolderIds")
    @JsonIgnore
    public CollectionPage<String> getSourceFolderIds() {
        return new CollectionPage<String>(contextPath, String.class, this.sourceFolderIds, Optional.ofNullable(sourceFolderIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public MailSearchFolder withSourceFolderIds(List<String> sourceFolderIds) {
        MailSearchFolder _x = _copy();
        _x.changedFields = changedFields.add("sourceFolderIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailSearchFolder");
        _x.sourceFolderIds = sourceFolderIds;
        return _x;
    }

    @Property(name="sourceFolderIds")
    @JsonIgnore
    public CollectionPage<String> getSourceFolderIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.sourceFolderIds, Optional.ofNullable(sourceFolderIdsNextLink), Collections.emptyList(), options);
    }

    public MailSearchFolder withUnmappedField(String name, Object value) {
        MailSearchFolder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailSearchFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MailSearchFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailSearchFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MailSearchFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MailSearchFolder _copy() {
        MailSearchFolder _x = new MailSearchFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.childFolderCount = childFolderCount;
        _x.displayName = displayName;
        _x.isHidden = isHidden;
        _x.parentFolderId = parentFolderId;
        _x.totalItemCount = totalItemCount;
        _x.unreadItemCount = unreadItemCount;
        _x.wellKnownName = wellKnownName;
        _x.childFolders = childFolders;
        _x.messageRules = messageRules;
        _x.messages = messages;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        _x.userConfigurations = userConfigurations;
        _x.filterQuery = filterQuery;
        _x.includeNestedFolders = includeNestedFolders;
        _x.isSupported = isSupported;
        _x.sourceFolderIds = sourceFolderIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailSearchFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("childFolderCount=");
        b.append(this.childFolderCount);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isHidden=");
        b.append(this.isHidden);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("totalItemCount=");
        b.append(this.totalItemCount);
        b.append(", ");
        b.append("unreadItemCount=");
        b.append(this.unreadItemCount);
        b.append(", ");
        b.append("wellKnownName=");
        b.append(this.wellKnownName);
        b.append(", ");
        b.append("childFolders=");
        b.append(this.childFolders);
        b.append(", ");
        b.append("messageRules=");
        b.append(this.messageRules);
        b.append(", ");
        b.append("messages=");
        b.append(this.messages);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append(", ");
        b.append("userConfigurations=");
        b.append(this.userConfigurations);
        b.append(", ");
        b.append("filterQuery=");
        b.append(this.filterQuery);
        b.append(", ");
        b.append("includeNestedFolders=");
        b.append(this.includeNestedFolders);
        b.append(", ");
        b.append("isSupported=");
        b.append(this.isSupported);
        b.append(", ");
        b.append("sourceFolderIds=");
        b.append(this.sourceFolderIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
