package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MacOSSoftwareUpdateCategory;
import odata.msgraph.client.beta.enums.MacOSSoftwareUpdateState;


/**
 * <i>“MacOS software update state summary for a device and user”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "lastUpdatedDateTime", 
    "productKey", 
    "state", 
    "updateCategory", 
    "updateVersion"})
@JsonInclude(Include.NON_NULL)
public class MacOSSoftwareUpdateStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSSoftwareUpdateStateSummary";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("productKey")
    protected String productKey;

    @JsonProperty("state")
    protected MacOSSoftwareUpdateState state;

    @JsonProperty("updateCategory")
    protected MacOSSoftwareUpdateCategory updateCategory;

    @JsonProperty("updateVersion")
    protected String updateVersion;

    protected MacOSSoftwareUpdateStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSSoftwareUpdateStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private OffsetDateTime lastUpdatedDateTime;
        private String productKey;
        private MacOSSoftwareUpdateState state;
        private MacOSSoftwareUpdateCategory updateCategory;
        private String updateVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Human readable name of the software update”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Last date time the report for this device and product key was updated.”</i>
         * 
         * @param lastUpdatedDateTime
         *            value of {@code lastUpdatedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“Product key of the software update.”</i>
         * 
         * @param productKey
         *            value of {@code productKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productKey(String productKey) {
            this.productKey = productKey;
            this.changedFields = changedFields.add("productKey");
            return this;
        }

        /**
         * <i>“State of the software update”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(MacOSSoftwareUpdateState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“Software update category”</i>
         * 
         * @param updateCategory
         *            value of {@code updateCategory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateCategory(MacOSSoftwareUpdateCategory updateCategory) {
            this.updateCategory = updateCategory;
            this.changedFields = changedFields.add("updateCategory");
            return this;
        }

        /**
         * <i>“Version of the software update”</i>
         * 
         * @param updateVersion
         *            value of {@code updateVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateVersion(String updateVersion) {
            this.updateVersion = updateVersion;
            this.changedFields = changedFields.add("updateVersion");
            return this;
        }

        public MacOSSoftwareUpdateStateSummary build() {
            MacOSSoftwareUpdateStateSummary _x = new MacOSSoftwareUpdateStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSSoftwareUpdateStateSummary";
            _x.id = id;
            _x.displayName = displayName;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.productKey = productKey;
            _x.state = state;
            _x.updateCategory = updateCategory;
            _x.updateVersion = updateVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Human readable name of the software update”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Human readable name of the software update”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MacOSSoftwareUpdateStateSummary withDisplayName(String displayName) {
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateStateSummary");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Last date time the report for this device and product key was updated.”</i>
     * 
     * @return property lastUpdatedDateTime
     */
    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdatedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last date time the report for this device and product key was updated.”</i>
     * 
     * @param lastUpdatedDateTime
     *            new value of {@code lastUpdatedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdatedDateTime} field changed
     */
    public MacOSSoftwareUpdateStateSummary withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateStateSummary");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    /**
     * <i>“Product key of the software update.”</i>
     * 
     * @return property productKey
     */
    @Property(name="productKey")
    @JsonIgnore
    public Optional<String> getProductKey() {
        return Optional.ofNullable(productKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productKey} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Product key of the software update.”</i>
     * 
     * @param productKey
     *            new value of {@code productKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productKey} field changed
     */
    public MacOSSoftwareUpdateStateSummary withProductKey(String productKey) {
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = changedFields.add("productKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateStateSummary");
        _x.productKey = productKey;
        return _x;
    }

    /**
     * <i>“State of the software update”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<MacOSSoftwareUpdateState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“State of the software update”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public MacOSSoftwareUpdateStateSummary withState(MacOSSoftwareUpdateState state) {
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateStateSummary");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“Software update category”</i>
     * 
     * @return property updateCategory
     */
    @Property(name="updateCategory")
    @JsonIgnore
    public Optional<MacOSSoftwareUpdateCategory> getUpdateCategory() {
        return Optional.ofNullable(updateCategory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateCategory}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Software update category”</i>
     * 
     * @param updateCategory
     *            new value of {@code updateCategory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateCategory} field changed
     */
    public MacOSSoftwareUpdateStateSummary withUpdateCategory(MacOSSoftwareUpdateCategory updateCategory) {
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = changedFields.add("updateCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateStateSummary");
        _x.updateCategory = updateCategory;
        return _x;
    }

    /**
     * <i>“Version of the software update”</i>
     * 
     * @return property updateVersion
     */
    @Property(name="updateVersion")
    @JsonIgnore
    public Optional<String> getUpdateVersion() {
        return Optional.ofNullable(updateVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Version of the software update”</i>
     * 
     * @param updateVersion
     *            new value of {@code updateVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateVersion} field changed
     */
    public MacOSSoftwareUpdateStateSummary withUpdateVersion(String updateVersion) {
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = changedFields.add("updateVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateStateSummary");
        _x.updateVersion = updateVersion;
        return _x;
    }

    public MacOSSoftwareUpdateStateSummary withUnmappedField(String name, Object value) {
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSSoftwareUpdateStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSSoftwareUpdateStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSSoftwareUpdateStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSSoftwareUpdateStateSummary _copy() {
        MacOSSoftwareUpdateStateSummary _x = new MacOSSoftwareUpdateStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.productKey = productKey;
        _x.state = state;
        _x.updateCategory = updateCategory;
        _x.updateVersion = updateVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSSoftwareUpdateStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("productKey=");
        b.append(this.productKey);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("updateCategory=");
        b.append(this.updateCategory);
        b.append(", ");
        b.append("updateVersion=");
        b.append(this.updateVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
