package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MacOSSoftwareUpdateStateSummaryCollectionRequest;
import odata.msgraph.client.beta.enums.MacOSSoftwareUpdateCategory;


/**
 * <i>“MacOS software update category summary report for a device and user”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "displayName", 
    "failedUpdateCount", 
    "lastUpdatedDateTime", 
    "successfulUpdateCount", 
    "totalUpdateCount", 
    "updateCategory", 
    "userId", 
    "updateStateSummaries"})
@JsonInclude(Include.NON_NULL)
public class MacOSSoftwareUpdateCategorySummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSSoftwareUpdateCategorySummary";
    }

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("failedUpdateCount")
    protected Integer failedUpdateCount;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("successfulUpdateCount")
    protected Integer successfulUpdateCount;

    @JsonProperty("totalUpdateCount")
    protected Integer totalUpdateCount;

    @JsonProperty("updateCategory")
    protected MacOSSoftwareUpdateCategory updateCategory;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("updateStateSummaries")
    protected List<MacOSSoftwareUpdateStateSummary> updateStateSummaries;

    protected MacOSSoftwareUpdateCategorySummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSSoftwareUpdateCategorySummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceId;
        private String displayName;
        private Integer failedUpdateCount;
        private OffsetDateTime lastUpdatedDateTime;
        private Integer successfulUpdateCount;
        private Integer totalUpdateCount;
        private MacOSSoftwareUpdateCategory updateCategory;
        private String userId;
        private List<MacOSSoftwareUpdateStateSummary> updateStateSummaries;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The device ID.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The name of the report”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Number of failed updates on the device”</i>
         * 
         * @param failedUpdateCount
         *            value of {@code failedUpdateCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedUpdateCount(Integer failedUpdateCount) {
            this.failedUpdateCount = failedUpdateCount;
            this.changedFields = changedFields.add("failedUpdateCount");
            return this;
        }

        /**
         * <i>“Last date time the report for this device was updated.”</i>
         * 
         * @param lastUpdatedDateTime
         *            value of {@code lastUpdatedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“Number of successful updates on the device”</i>
         * 
         * @param successfulUpdateCount
         *            value of {@code successfulUpdateCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulUpdateCount(Integer successfulUpdateCount) {
            this.successfulUpdateCount = successfulUpdateCount;
            this.changedFields = changedFields.add("successfulUpdateCount");
            return this;
        }

        /**
         * <i>“Number of total updates on the device”</i>
         * 
         * @param totalUpdateCount
         *            value of {@code totalUpdateCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalUpdateCount(Integer totalUpdateCount) {
            this.totalUpdateCount = totalUpdateCount;
            this.changedFields = changedFields.add("totalUpdateCount");
            return this;
        }

        /**
         * <i>“Software update type”</i>
         * 
         * @param updateCategory
         *            value of {@code updateCategory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateCategory(MacOSSoftwareUpdateCategory updateCategory) {
            this.updateCategory = updateCategory;
            this.changedFields = changedFields.add("updateCategory");
            return this;
        }

        /**
         * <i>“The user ID.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“Summary of the update states.”</i>
         * 
         * @param updateStateSummaries
         *            value of {@code updateStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateStateSummaries(List<MacOSSoftwareUpdateStateSummary> updateStateSummaries) {
            this.updateStateSummaries = updateStateSummaries;
            this.changedFields = changedFields.add("updateStateSummaries");
            return this;
        }

        /**
         * <i>“Summary of the update states.”</i>
         * 
         * @param updateStateSummaries
         *            value of {@code updateStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateStateSummaries(MacOSSoftwareUpdateStateSummary... updateStateSummaries) {
            return updateStateSummaries(Arrays.asList(updateStateSummaries));
        }

        public MacOSSoftwareUpdateCategorySummary build() {
            MacOSSoftwareUpdateCategorySummary _x = new MacOSSoftwareUpdateCategorySummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSSoftwareUpdateCategorySummary";
            _x.id = id;
            _x.deviceId = deviceId;
            _x.displayName = displayName;
            _x.failedUpdateCount = failedUpdateCount;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.successfulUpdateCount = successfulUpdateCount;
            _x.totalUpdateCount = totalUpdateCount;
            _x.updateCategory = updateCategory;
            _x.userId = userId;
            _x.updateStateSummaries = updateStateSummaries;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The device ID.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The device ID.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withDeviceId(String deviceId) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The name of the report”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the report”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withDisplayName(String displayName) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Number of failed updates on the device”</i>
     * 
     * @return property failedUpdateCount
     */
    @Property(name="failedUpdateCount")
    @JsonIgnore
    public Optional<Integer> getFailedUpdateCount() {
        return Optional.ofNullable(failedUpdateCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedUpdateCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of failed updates on the device”</i>
     * 
     * @param failedUpdateCount
     *            new value of {@code failedUpdateCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedUpdateCount} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withFailedUpdateCount(Integer failedUpdateCount) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("failedUpdateCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.failedUpdateCount = failedUpdateCount;
        return _x;
    }

    /**
     * <i>“Last date time the report for this device was updated.”</i>
     * 
     * @return property lastUpdatedDateTime
     */
    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdatedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last date time the report for this device was updated.”</i>
     * 
     * @param lastUpdatedDateTime
     *            new value of {@code lastUpdatedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdatedDateTime} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    /**
     * <i>“Number of successful updates on the device”</i>
     * 
     * @return property successfulUpdateCount
     */
    @Property(name="successfulUpdateCount")
    @JsonIgnore
    public Optional<Integer> getSuccessfulUpdateCount() {
        return Optional.ofNullable(successfulUpdateCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * successfulUpdateCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of successful updates on the device”</i>
     * 
     * @param successfulUpdateCount
     *            new value of {@code successfulUpdateCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successfulUpdateCount} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withSuccessfulUpdateCount(Integer successfulUpdateCount) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("successfulUpdateCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.successfulUpdateCount = successfulUpdateCount;
        return _x;
    }

    /**
     * <i>“Number of total updates on the device”</i>
     * 
     * @return property totalUpdateCount
     */
    @Property(name="totalUpdateCount")
    @JsonIgnore
    public Optional<Integer> getTotalUpdateCount() {
        return Optional.ofNullable(totalUpdateCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalUpdateCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of total updates on the device”</i>
     * 
     * @param totalUpdateCount
     *            new value of {@code totalUpdateCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalUpdateCount} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withTotalUpdateCount(Integer totalUpdateCount) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("totalUpdateCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.totalUpdateCount = totalUpdateCount;
        return _x;
    }

    /**
     * <i>“Software update type”</i>
     * 
     * @return property updateCategory
     */
    @Property(name="updateCategory")
    @JsonIgnore
    public Optional<MacOSSoftwareUpdateCategory> getUpdateCategory() {
        return Optional.ofNullable(updateCategory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateCategory}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Software update type”</i>
     * 
     * @param updateCategory
     *            new value of {@code updateCategory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateCategory} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withUpdateCategory(MacOSSoftwareUpdateCategory updateCategory) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("updateCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.updateCategory = updateCategory;
        return _x;
    }

    /**
     * <i>“The user ID.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user ID.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withUserId(String userId) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.userId = userId;
        return _x;
    }

    public MacOSSoftwareUpdateCategorySummary withUnmappedField(String name, Object value) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Summary of the update states.”</i>
     * 
     * @return navigational property updateStateSummaries
     */
    @NavigationProperty(name="updateStateSummaries")
    @JsonIgnore
    public MacOSSoftwareUpdateStateSummaryCollectionRequest getUpdateStateSummaries() {
        return new MacOSSoftwareUpdateStateSummaryCollectionRequest(
                        contextPath.addSegment("updateStateSummaries"), Optional.ofNullable(updateStateSummaries));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * updateStateSummaries} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Summary of the update states.”</i>
     * 
     * @param updateStateSummaries
     *            new value of {@code updateStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateStateSummaries} field changed
     */
    public MacOSSoftwareUpdateCategorySummary withUpdateStateSummaries(List<MacOSSoftwareUpdateStateSummary> updateStateSummaries) {
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = changedFields.add("updateStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateCategorySummary");
        _x.updateStateSummaries = updateStateSummaries;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSSoftwareUpdateCategorySummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSSoftwareUpdateCategorySummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSSoftwareUpdateCategorySummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSSoftwareUpdateCategorySummary _copy() {
        MacOSSoftwareUpdateCategorySummary _x = new MacOSSoftwareUpdateCategorySummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceId = deviceId;
        _x.displayName = displayName;
        _x.failedUpdateCount = failedUpdateCount;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.successfulUpdateCount = successfulUpdateCount;
        _x.totalUpdateCount = totalUpdateCount;
        _x.updateCategory = updateCategory;
        _x.userId = userId;
        _x.updateStateSummaries = updateStateSummaries;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSSoftwareUpdateCategorySummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("failedUpdateCount=");
        b.append(this.failedUpdateCount);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("successfulUpdateCount=");
        b.append(this.successfulUpdateCount);
        b.append(", ");
        b.append("totalUpdateCount=");
        b.append(this.totalUpdateCount);
        b.append(", ");
        b.append("updateCategory=");
        b.append(this.updateCategory);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("updateStateSummaries=");
        b.append(this.updateStateSummaries);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
