package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MacOSSoftwareUpdateCategorySummaryCollectionRequest;


/**
 * <i>“MacOS software update account summary report for a device and user”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "deviceName", 
    "displayName", 
    "failedUpdateCount", 
    "lastUpdatedDateTime", 
    "osVersion", 
    "successfulUpdateCount", 
    "totalUpdateCount", 
    "userId", 
    "userPrincipalName", 
    "categorySummaries"})
@JsonInclude(Include.NON_NULL)
public class MacOSSoftwareUpdateAccountSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSSoftwareUpdateAccountSummary";
    }

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("failedUpdateCount")
    protected Integer failedUpdateCount;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("successfulUpdateCount")
    protected Integer successfulUpdateCount;

    @JsonProperty("totalUpdateCount")
    protected Integer totalUpdateCount;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("categorySummaries")
    protected List<MacOSSoftwareUpdateCategorySummary> categorySummaries;

    protected MacOSSoftwareUpdateAccountSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSSoftwareUpdateAccountSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceId;
        private String deviceName;
        private String displayName;
        private Integer failedUpdateCount;
        private OffsetDateTime lastUpdatedDateTime;
        private String osVersion;
        private Integer successfulUpdateCount;
        private Integer totalUpdateCount;
        private String userId;
        private String userPrincipalName;
        private List<MacOSSoftwareUpdateCategorySummary> categorySummaries;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The device ID.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The device name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The name of the report”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Number of failed updates on the device.”</i>
         * 
         * @param failedUpdateCount
         *            value of {@code failedUpdateCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedUpdateCount(Integer failedUpdateCount) {
            this.failedUpdateCount = failedUpdateCount;
            this.changedFields = changedFields.add("failedUpdateCount");
            return this;
        }

        /**
         * <i>“Last date time the report for this device was updated.”</i>
         * 
         * @param lastUpdatedDateTime
         *            value of {@code lastUpdatedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“The OS version.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“Number of successful updates on the device.”</i>
         * 
         * @param successfulUpdateCount
         *            value of {@code successfulUpdateCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulUpdateCount(Integer successfulUpdateCount) {
            this.successfulUpdateCount = successfulUpdateCount;
            this.changedFields = changedFields.add("successfulUpdateCount");
            return this;
        }

        /**
         * <i>“Number of total updates on the device.”</i>
         * 
         * @param totalUpdateCount
         *            value of {@code totalUpdateCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalUpdateCount(Integer totalUpdateCount) {
            this.totalUpdateCount = totalUpdateCount;
            this.changedFields = changedFields.add("totalUpdateCount");
            return this;
        }

        /**
         * <i>“The user ID.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“The user principal name”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Summary of the updates by category.”</i>
         * 
         * @param categorySummaries
         *            value of {@code categorySummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categorySummaries(List<MacOSSoftwareUpdateCategorySummary> categorySummaries) {
            this.categorySummaries = categorySummaries;
            this.changedFields = changedFields.add("categorySummaries");
            return this;
        }

        /**
         * <i>“Summary of the updates by category.”</i>
         * 
         * @param categorySummaries
         *            value of {@code categorySummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categorySummaries(MacOSSoftwareUpdateCategorySummary... categorySummaries) {
            return categorySummaries(Arrays.asList(categorySummaries));
        }

        public MacOSSoftwareUpdateAccountSummary build() {
            MacOSSoftwareUpdateAccountSummary _x = new MacOSSoftwareUpdateAccountSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSSoftwareUpdateAccountSummary";
            _x.id = id;
            _x.deviceId = deviceId;
            _x.deviceName = deviceName;
            _x.displayName = displayName;
            _x.failedUpdateCount = failedUpdateCount;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.osVersion = osVersion;
            _x.successfulUpdateCount = successfulUpdateCount;
            _x.totalUpdateCount = totalUpdateCount;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            _x.categorySummaries = categorySummaries;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The device ID.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The device ID.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withDeviceId(String deviceId) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The device name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The device name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withDeviceName(String deviceName) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The name of the report”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the report”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withDisplayName(String displayName) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Number of failed updates on the device.”</i>
     * 
     * @return property failedUpdateCount
     */
    @Property(name="failedUpdateCount")
    @JsonIgnore
    public Optional<Integer> getFailedUpdateCount() {
        return Optional.ofNullable(failedUpdateCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedUpdateCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of failed updates on the device.”</i>
     * 
     * @param failedUpdateCount
     *            new value of {@code failedUpdateCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedUpdateCount} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withFailedUpdateCount(Integer failedUpdateCount) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("failedUpdateCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.failedUpdateCount = failedUpdateCount;
        return _x;
    }

    /**
     * <i>“Last date time the report for this device was updated.”</i>
     * 
     * @return property lastUpdatedDateTime
     */
    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdatedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last date time the report for this device was updated.”</i>
     * 
     * @param lastUpdatedDateTime
     *            new value of {@code lastUpdatedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdatedDateTime} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    /**
     * <i>“The OS version.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The OS version.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withOsVersion(String osVersion) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“Number of successful updates on the device.”</i>
     * 
     * @return property successfulUpdateCount
     */
    @Property(name="successfulUpdateCount")
    @JsonIgnore
    public Optional<Integer> getSuccessfulUpdateCount() {
        return Optional.ofNullable(successfulUpdateCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * successfulUpdateCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of successful updates on the device.”</i>
     * 
     * @param successfulUpdateCount
     *            new value of {@code successfulUpdateCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successfulUpdateCount} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withSuccessfulUpdateCount(Integer successfulUpdateCount) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("successfulUpdateCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.successfulUpdateCount = successfulUpdateCount;
        return _x;
    }

    /**
     * <i>“Number of total updates on the device.”</i>
     * 
     * @return property totalUpdateCount
     */
    @Property(name="totalUpdateCount")
    @JsonIgnore
    public Optional<Integer> getTotalUpdateCount() {
        return Optional.ofNullable(totalUpdateCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalUpdateCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of total updates on the device.”</i>
     * 
     * @param totalUpdateCount
     *            new value of {@code totalUpdateCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalUpdateCount} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withTotalUpdateCount(Integer totalUpdateCount) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("totalUpdateCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.totalUpdateCount = totalUpdateCount;
        return _x;
    }

    /**
     * <i>“The user ID.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user ID.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withUserId(String userId) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“The user principal name”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user principal name”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withUserPrincipalName(String userPrincipalName) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public MacOSSoftwareUpdateAccountSummary withUnmappedField(String name, Object value) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Summary of the updates by category.”</i>
     * 
     * @return navigational property categorySummaries
     */
    @NavigationProperty(name="categorySummaries")
    @JsonIgnore
    public MacOSSoftwareUpdateCategorySummaryCollectionRequest getCategorySummaries() {
        return new MacOSSoftwareUpdateCategorySummaryCollectionRequest(
                        contextPath.addSegment("categorySummaries"), Optional.ofNullable(categorySummaries));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code categorySummaries
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Summary of the updates by category.”</i>
     * 
     * @param categorySummaries
     *            new value of {@code categorySummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categorySummaries} field changed
     */
    public MacOSSoftwareUpdateAccountSummary withCategorySummaries(List<MacOSSoftwareUpdateCategorySummary> categorySummaries) {
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = changedFields.add("categorySummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSoftwareUpdateAccountSummary");
        _x.categorySummaries = categorySummaries;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSSoftwareUpdateAccountSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSSoftwareUpdateAccountSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSSoftwareUpdateAccountSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSSoftwareUpdateAccountSummary _copy() {
        MacOSSoftwareUpdateAccountSummary _x = new MacOSSoftwareUpdateAccountSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceId = deviceId;
        _x.deviceName = deviceName;
        _x.displayName = displayName;
        _x.failedUpdateCount = failedUpdateCount;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.osVersion = osVersion;
        _x.successfulUpdateCount = successfulUpdateCount;
        _x.totalUpdateCount = totalUpdateCount;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        _x.categorySummaries = categorySummaries;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSSoftwareUpdateAccountSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("failedUpdateCount=");
        b.append(this.failedUpdateCount);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("successfulUpdateCount=");
        b.append(this.successfulUpdateCount);
        b.append(", ");
        b.append("totalUpdateCount=");
        b.append(this.totalUpdateCount);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("categorySummaries=");
        b.append(this.categorySummaries);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
