package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MacOSLobChildApp;
import odata.msgraph.client.beta.complex.MacOSMinimumOperatingSystem;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for the MacOS LOB App.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "buildNumber", 
    "bundleId", 
    "childApps", 
    "identityVersion", 
    "ignoreVersionDetection", 
    "installAsManaged", 
    "md5Hash", 
    "md5HashChunkSize", 
    "minimumSupportedOperatingSystem", 
    "versionNumber"})
@JsonInclude(Include.NON_NULL)
public class MacOSLobApp extends MobileLobApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSLobApp";
    }

    @JsonProperty("buildNumber")
    protected String buildNumber;

    @JsonProperty("bundleId")
    protected String bundleId;

    @JsonProperty("childApps")
    protected List<MacOSLobChildApp> childApps;

    @JsonProperty("childApps@nextLink")
    protected String childAppsNextLink;

    @JsonProperty("identityVersion")
    protected String identityVersion;

    @JsonProperty("ignoreVersionDetection")
    protected Boolean ignoreVersionDetection;

    @JsonProperty("installAsManaged")
    protected Boolean installAsManaged;

    @JsonProperty("md5Hash")
    protected List<String> md5Hash;

    @JsonProperty("md5Hash@nextLink")
    protected String md5HashNextLink;

    @JsonProperty("md5HashChunkSize")
    protected Integer md5HashChunkSize;

    @JsonProperty("minimumSupportedOperatingSystem")
    protected MacOSMinimumOperatingSystem minimumSupportedOperatingSystem;

    @JsonProperty("versionNumber")
    protected String versionNumber;

    protected MacOSLobApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSLobApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private List<MobileAppContent> contentVersions;
        private String buildNumber;
        private String bundleId;
        private List<MacOSLobChildApp> childApps;
        private String childAppsNextLink;
        private String identityVersion;
        private Boolean ignoreVersionDetection;
        private Boolean installAsManaged;
        private List<String> md5Hash;
        private String md5HashNextLink;
        private Integer md5HashChunkSize;
        private MacOSMinimumOperatingSystem minimumSupportedOperatingSystem;
        private String versionNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder contentVersions(List<MobileAppContent> contentVersions) {
            this.contentVersions = contentVersions;
            this.changedFields = changedFields.add("contentVersions");
            return this;
        }

        public Builder contentVersions(MobileAppContent... contentVersions) {
            return contentVersions(Arrays.asList(contentVersions));
        }

        /**
         * <i>“The build number of MacOS Line of Business (LoB) app.”</i>
         * 
         * @param buildNumber
         *            value of {@code buildNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder buildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            this.changedFields = changedFields.add("buildNumber");
            return this;
        }

        /**
         * <i>“The bundle id.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        /**
         * <i>“The app list in this bundle package”</i>
         * 
         * @param childApps
         *            value of {@code childApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childApps(List<MacOSLobChildApp> childApps) {
            this.childApps = childApps;
            this.changedFields = changedFields.add("childApps");
            return this;
        }

        /**
         * <i>“The app list in this bundle package”</i>
         * 
         * @param childApps
         *            value of {@code childApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childApps(MacOSLobChildApp... childApps) {
            return childApps(Arrays.asList(childApps));
        }

        /**
         * <i>“The app list in this bundle package”</i>
         * 
         * @param childAppsNextLink
         *            value of {@code childApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childAppsNextLink(String childAppsNextLink) {
            this.childAppsNextLink = childAppsNextLink;
            this.changedFields = changedFields.add("childApps");
            return this;
        }

        /**
         * <i>“The identity version.”</i>
         * 
         * @param identityVersion
         *            value of {@code identityVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identityVersion(String identityVersion) {
            this.identityVersion = identityVersion;
            this.changedFields = changedFields.add("identityVersion");
            return this;
        }

        /**
         * <i>“A boolean to control whether the app's version will be used to detect the app
         * after it is installed on a device. Set this to true for macOS Line of Business (
         * LoB) apps that use a self update feature.”</i>
         * 
         * @param ignoreVersionDetection
         *            value of {@code ignoreVersionDetection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ignoreVersionDetection(Boolean ignoreVersionDetection) {
            this.ignoreVersionDetection = ignoreVersionDetection;
            this.changedFields = changedFields.add("ignoreVersionDetection");
            return this;
        }

        /**
         * <i>“A boolean to control whether the app will be installed as managed (requires
         * macOS 11.0 and other PKG restrictions).”</i>
         * 
         * @param installAsManaged
         *            value of {@code installAsManaged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installAsManaged(Boolean installAsManaged) {
            this.installAsManaged = installAsManaged;
            this.changedFields = changedFields.add("installAsManaged");
            return this;
        }

        /**
         * <i>“The MD5 hash codes”</i>
         * 
         * @param md5Hash
         *            value of {@code md5Hash} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder md5Hash(List<String> md5Hash) {
            this.md5Hash = md5Hash;
            this.changedFields = changedFields.add("md5Hash");
            return this;
        }

        /**
         * <i>“The MD5 hash codes”</i>
         * 
         * @param md5Hash
         *            value of {@code md5Hash} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder md5Hash(String... md5Hash) {
            return md5Hash(Arrays.asList(md5Hash));
        }

        /**
         * <i>“The MD5 hash codes”</i>
         * 
         * @param md5HashNextLink
         *            value of {@code md5Hash@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder md5HashNextLink(String md5HashNextLink) {
            this.md5HashNextLink = md5HashNextLink;
            this.changedFields = changedFields.add("md5Hash");
            return this;
        }

        /**
         * <i>“The chunk size for MD5 hash”</i>
         * 
         * @param md5HashChunkSize
         *            value of {@code md5HashChunkSize} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder md5HashChunkSize(Integer md5HashChunkSize) {
            this.md5HashChunkSize = md5HashChunkSize;
            this.changedFields = changedFields.add("md5HashChunkSize");
            return this;
        }

        /**
         * <i>“The value for the minimum applicable operating system.”</i>
         * 
         * @param minimumSupportedOperatingSystem
         *            value of {@code minimumSupportedOperatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedOperatingSystem(MacOSMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        /**
         * <i>“The version number of MacOS Line of Business (LoB) app.”</i>
         * 
         * @param versionNumber
         *            value of {@code versionNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            this.changedFields = changedFields.add("versionNumber");
            return this;
        }

        public MacOSLobApp build() {
            MacOSLobApp _x = new MacOSLobApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSLobApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.contentVersions = contentVersions;
            _x.buildNumber = buildNumber;
            _x.bundleId = bundleId;
            _x.childApps = childApps;
            _x.childAppsNextLink = childAppsNextLink;
            _x.identityVersion = identityVersion;
            _x.ignoreVersionDetection = ignoreVersionDetection;
            _x.installAsManaged = installAsManaged;
            _x.md5Hash = md5Hash;
            _x.md5HashNextLink = md5HashNextLink;
            _x.md5HashChunkSize = md5HashChunkSize;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            _x.versionNumber = versionNumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The build number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @return property buildNumber
     */
    @Property(name="buildNumber")
    @JsonIgnore
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(buildNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code buildNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The build number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @param buildNumber
     *            new value of {@code buildNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code buildNumber} field changed
     */
    public MacOSLobApp withBuildNumber(String buildNumber) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("buildNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.buildNumber = buildNumber;
        return _x;
    }

    /**
     * <i>“The bundle id.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The bundle id.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public MacOSLobApp withBundleId(String bundleId) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("bundleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.bundleId = bundleId;
        return _x;
    }

    /**
     * <i>“The app list in this bundle package”</i>
     * 
     * @return property childApps
     */
    @Property(name="childApps")
    @JsonIgnore
    public CollectionPage<MacOSLobChildApp> getChildApps() {
        return new CollectionPage<MacOSLobChildApp>(contextPath, MacOSLobChildApp.class, this.childApps, Optional.ofNullable(childAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code childApps} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app list in this bundle package”</i>
     * 
     * @param childApps
     *            new value of {@code childApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code childApps} field changed
     */
    public MacOSLobApp withChildApps(List<MacOSLobChildApp> childApps) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("childApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.childApps = childApps;
        return _x;
    }

    /**
     * <i>“The app list in this bundle package”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property childApps
     */
    @Property(name="childApps")
    @JsonIgnore
    public CollectionPage<MacOSLobChildApp> getChildApps(HttpRequestOptions options) {
        return new CollectionPage<MacOSLobChildApp>(contextPath, MacOSLobChildApp.class, this.childApps, Optional.ofNullable(childAppsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The identity version.”</i>
     * 
     * @return property identityVersion
     */
    @Property(name="identityVersion")
    @JsonIgnore
    public Optional<String> getIdentityVersion() {
        return Optional.ofNullable(identityVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identityVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The identity version.”</i>
     * 
     * @param identityVersion
     *            new value of {@code identityVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identityVersion} field changed
     */
    public MacOSLobApp withIdentityVersion(String identityVersion) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("identityVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.identityVersion = identityVersion;
        return _x;
    }

    /**
     * <i>“A boolean to control whether the app's version will be used to detect the app
     * after it is installed on a device. Set this to true for macOS Line of Business (
     * LoB) apps that use a self update feature.”</i>
     * 
     * @return property ignoreVersionDetection
     */
    @Property(name="ignoreVersionDetection")
    @JsonIgnore
    public Optional<Boolean> getIgnoreVersionDetection() {
        return Optional.ofNullable(ignoreVersionDetection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ignoreVersionDetection} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A boolean to control whether the app's version will be used to detect the app
     * after it is installed on a device. Set this to true for macOS Line of Business (
     * LoB) apps that use a self update feature.”</i>
     * 
     * @param ignoreVersionDetection
     *            new value of {@code ignoreVersionDetection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ignoreVersionDetection} field changed
     */
    public MacOSLobApp withIgnoreVersionDetection(Boolean ignoreVersionDetection) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("ignoreVersionDetection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.ignoreVersionDetection = ignoreVersionDetection;
        return _x;
    }

    /**
     * <i>“A boolean to control whether the app will be installed as managed (requires
     * macOS 11.0 and other PKG restrictions).”</i>
     * 
     * @return property installAsManaged
     */
    @Property(name="installAsManaged")
    @JsonIgnore
    public Optional<Boolean> getInstallAsManaged() {
        return Optional.ofNullable(installAsManaged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code installAsManaged}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A boolean to control whether the app will be installed as managed (requires
     * macOS 11.0 and other PKG restrictions).”</i>
     * 
     * @param installAsManaged
     *            new value of {@code installAsManaged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installAsManaged} field changed
     */
    public MacOSLobApp withInstallAsManaged(Boolean installAsManaged) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("installAsManaged");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.installAsManaged = installAsManaged;
        return _x;
    }

    /**
     * <i>“The MD5 hash codes”</i>
     * 
     * @return property md5Hash
     */
    @Property(name="md5Hash")
    @JsonIgnore
    public CollectionPage<String> getMd5Hash() {
        return new CollectionPage<String>(contextPath, String.class, this.md5Hash, Optional.ofNullable(md5HashNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code md5Hash} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The MD5 hash codes”</i>
     * 
     * @param md5Hash
     *            new value of {@code md5Hash} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code md5Hash} field changed
     */
    public MacOSLobApp withMd5Hash(List<String> md5Hash) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("md5Hash");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.md5Hash = md5Hash;
        return _x;
    }

    /**
     * <i>“The MD5 hash codes”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property md5Hash
     */
    @Property(name="md5Hash")
    @JsonIgnore
    public CollectionPage<String> getMd5Hash(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.md5Hash, Optional.ofNullable(md5HashNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The chunk size for MD5 hash”</i>
     * 
     * @return property md5HashChunkSize
     */
    @Property(name="md5HashChunkSize")
    @JsonIgnore
    public Optional<Integer> getMd5HashChunkSize() {
        return Optional.ofNullable(md5HashChunkSize);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code md5HashChunkSize}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The chunk size for MD5 hash”</i>
     * 
     * @param md5HashChunkSize
     *            new value of {@code md5HashChunkSize} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code md5HashChunkSize} field changed
     */
    public MacOSLobApp withMd5HashChunkSize(Integer md5HashChunkSize) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("md5HashChunkSize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.md5HashChunkSize = md5HashChunkSize;
        return _x;
    }

    /**
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @return property minimumSupportedOperatingSystem
     */
    @Property(name="minimumSupportedOperatingSystem")
    @JsonIgnore
    public Optional<MacOSMinimumOperatingSystem> getMinimumSupportedOperatingSystem() {
        return Optional.ofNullable(minimumSupportedOperatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedOperatingSystem} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @param minimumSupportedOperatingSystem
     *            new value of {@code minimumSupportedOperatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedOperatingSystem} field changed
     */
    public MacOSLobApp withMinimumSupportedOperatingSystem(MacOSMinimumOperatingSystem minimumSupportedOperatingSystem) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumSupportedOperatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        return _x;
    }

    /**
     * <i>“The version number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @return property versionNumber
     */
    @Property(name="versionNumber")
    @JsonIgnore
    public Optional<String> getVersionNumber() {
        return Optional.ofNullable(versionNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code versionNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The version number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @param versionNumber
     *            new value of {@code versionNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code versionNumber} field changed
     */
    public MacOSLobApp withVersionNumber(String versionNumber) {
        MacOSLobApp _x = _copy();
        _x.changedFields = changedFields.add("versionNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobApp");
        _x.versionNumber = versionNumber;
        return _x;
    }

    public MacOSLobApp withUnmappedField(String name, Object value) {
        MacOSLobApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSLobApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSLobApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSLobApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSLobApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSLobApp _copy() {
        MacOSLobApp _x = new MacOSLobApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.contentVersions = contentVersions;
        _x.buildNumber = buildNumber;
        _x.bundleId = bundleId;
        _x.childApps = childApps;
        _x.identityVersion = identityVersion;
        _x.ignoreVersionDetection = ignoreVersionDetection;
        _x.installAsManaged = installAsManaged;
        _x.md5Hash = md5Hash;
        _x.md5HashChunkSize = md5HashChunkSize;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        _x.versionNumber = versionNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSLobApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("contentVersions=");
        b.append(this.contentVersions);
        b.append(", ");
        b.append("buildNumber=");
        b.append(this.buildNumber);
        b.append(", ");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append(", ");
        b.append("childApps=");
        b.append(this.childApps);
        b.append(", ");
        b.append("identityVersion=");
        b.append(this.identityVersion);
        b.append(", ");
        b.append("ignoreVersionDetection=");
        b.append(this.ignoreVersionDetection);
        b.append(", ");
        b.append("installAsManaged=");
        b.append(this.installAsManaged);
        b.append(", ");
        b.append("md5Hash=");
        b.append(this.md5Hash);
        b.append(", ");
        b.append("md5HashChunkSize=");
        b.append(this.md5HashChunkSize);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append(", ");
        b.append("versionNumber=");
        b.append(this.versionNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
