package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.MacOSKernelExtension;
import odata.msgraph.client.beta.complex.MacOSSystemExtension;
import odata.msgraph.client.beta.complex.MacOSSystemExtensionTypeMapping;


/**
 * <i>“MacOS extensions configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "kernelExtensionAllowedTeamIdentifiers", 
    "kernelExtensionOverridesAllowed", 
    "kernelExtensionsAllowed", 
    "systemExtensionsAllowed", 
    "systemExtensionsAllowedTeamIdentifiers", 
    "systemExtensionsAllowedTypes", 
    "systemExtensionsBlockOverride"})
@JsonInclude(Include.NON_NULL)
public class MacOSExtensionsConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSExtensionsConfiguration";
    }

    @JsonProperty("kernelExtensionAllowedTeamIdentifiers")
    protected List<String> kernelExtensionAllowedTeamIdentifiers;

    @JsonProperty("kernelExtensionAllowedTeamIdentifiers@nextLink")
    protected String kernelExtensionAllowedTeamIdentifiersNextLink;

    @JsonProperty("kernelExtensionOverridesAllowed")
    protected Boolean kernelExtensionOverridesAllowed;

    @JsonProperty("kernelExtensionsAllowed")
    protected List<MacOSKernelExtension> kernelExtensionsAllowed;

    @JsonProperty("kernelExtensionsAllowed@nextLink")
    protected String kernelExtensionsAllowedNextLink;

    @JsonProperty("systemExtensionsAllowed")
    protected List<MacOSSystemExtension> systemExtensionsAllowed;

    @JsonProperty("systemExtensionsAllowed@nextLink")
    protected String systemExtensionsAllowedNextLink;

    @JsonProperty("systemExtensionsAllowedTeamIdentifiers")
    protected List<String> systemExtensionsAllowedTeamIdentifiers;

    @JsonProperty("systemExtensionsAllowedTeamIdentifiers@nextLink")
    protected String systemExtensionsAllowedTeamIdentifiersNextLink;

    @JsonProperty("systemExtensionsAllowedTypes")
    protected List<MacOSSystemExtensionTypeMapping> systemExtensionsAllowedTypes;

    @JsonProperty("systemExtensionsAllowedTypes@nextLink")
    protected String systemExtensionsAllowedTypesNextLink;

    @JsonProperty("systemExtensionsBlockOverride")
    protected Boolean systemExtensionsBlockOverride;

    protected MacOSExtensionsConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSExtensionsConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private List<String> kernelExtensionAllowedTeamIdentifiers;
        private String kernelExtensionAllowedTeamIdentifiersNextLink;
        private Boolean kernelExtensionOverridesAllowed;
        private List<MacOSKernelExtension> kernelExtensionsAllowed;
        private String kernelExtensionsAllowedNextLink;
        private List<MacOSSystemExtension> systemExtensionsAllowed;
        private String systemExtensionsAllowedNextLink;
        private List<String> systemExtensionsAllowedTeamIdentifiers;
        private String systemExtensionsAllowedTeamIdentifiersNextLink;
        private List<MacOSSystemExtensionTypeMapping> systemExtensionsAllowedTypes;
        private String systemExtensionsAllowedTypesNextLink;
        private Boolean systemExtensionsBlockOverride;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“All kernel extensions validly signed by the team identifiers in this list will
         * be allowed to load.”</i>
         * 
         * @param kernelExtensionAllowedTeamIdentifiers
         *            value of {@code kernelExtensionAllowedTeamIdentifiers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kernelExtensionAllowedTeamIdentifiers(List<String> kernelExtensionAllowedTeamIdentifiers) {
            this.kernelExtensionAllowedTeamIdentifiers = kernelExtensionAllowedTeamIdentifiers;
            this.changedFields = changedFields.add("kernelExtensionAllowedTeamIdentifiers");
            return this;
        }

        /**
         * <i>“All kernel extensions validly signed by the team identifiers in this list will
         * be allowed to load.”</i>
         * 
         * @param kernelExtensionAllowedTeamIdentifiers
         *            value of {@code kernelExtensionAllowedTeamIdentifiers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kernelExtensionAllowedTeamIdentifiers(String... kernelExtensionAllowedTeamIdentifiers) {
            return kernelExtensionAllowedTeamIdentifiers(Arrays.asList(kernelExtensionAllowedTeamIdentifiers));
        }

        /**
         * <i>“All kernel extensions validly signed by the team identifiers in this list will
         * be allowed to load.”</i>
         * 
         * @param kernelExtensionAllowedTeamIdentifiersNextLink
         *            value of {@code kernelExtensionAllowedTeamIdentifiers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kernelExtensionAllowedTeamIdentifiersNextLink(String kernelExtensionAllowedTeamIdentifiersNextLink) {
            this.kernelExtensionAllowedTeamIdentifiersNextLink = kernelExtensionAllowedTeamIdentifiersNextLink;
            this.changedFields = changedFields.add("kernelExtensionAllowedTeamIdentifiers");
            return this;
        }

        /**
         * <i>“If set to true, users can approve additional kernel extensions not explicitly
         * allowed by configurations profiles.”</i>
         * 
         * @param kernelExtensionOverridesAllowed
         *            value of {@code kernelExtensionOverridesAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kernelExtensionOverridesAllowed(Boolean kernelExtensionOverridesAllowed) {
            this.kernelExtensionOverridesAllowed = kernelExtensionOverridesAllowed;
            this.changedFields = changedFields.add("kernelExtensionOverridesAllowed");
            return this;
        }

        /**
         * <i>“A list of kernel extensions that will be allowed to load. . This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param kernelExtensionsAllowed
         *            value of {@code kernelExtensionsAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kernelExtensionsAllowed(List<MacOSKernelExtension> kernelExtensionsAllowed) {
            this.kernelExtensionsAllowed = kernelExtensionsAllowed;
            this.changedFields = changedFields.add("kernelExtensionsAllowed");
            return this;
        }

        /**
         * <i>“A list of kernel extensions that will be allowed to load. . This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param kernelExtensionsAllowed
         *            value of {@code kernelExtensionsAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kernelExtensionsAllowed(MacOSKernelExtension... kernelExtensionsAllowed) {
            return kernelExtensionsAllowed(Arrays.asList(kernelExtensionsAllowed));
        }

        /**
         * <i>“A list of kernel extensions that will be allowed to load. . This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param kernelExtensionsAllowedNextLink
         *            value of {@code kernelExtensionsAllowed@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kernelExtensionsAllowedNextLink(String kernelExtensionsAllowedNextLink) {
            this.kernelExtensionsAllowedNextLink = kernelExtensionsAllowedNextLink;
            this.changedFields = changedFields.add("kernelExtensionsAllowed");
            return this;
        }

        /**
         * <i>“Gets or sets a list of allowed macOS system extensions. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param systemExtensionsAllowed
         *            value of {@code systemExtensionsAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowed(List<MacOSSystemExtension> systemExtensionsAllowed) {
            this.systemExtensionsAllowed = systemExtensionsAllowed;
            this.changedFields = changedFields.add("systemExtensionsAllowed");
            return this;
        }

        /**
         * <i>“Gets or sets a list of allowed macOS system extensions. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param systemExtensionsAllowed
         *            value of {@code systemExtensionsAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowed(MacOSSystemExtension... systemExtensionsAllowed) {
            return systemExtensionsAllowed(Arrays.asList(systemExtensionsAllowed));
        }

        /**
         * <i>“Gets or sets a list of allowed macOS system extensions. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param systemExtensionsAllowedNextLink
         *            value of {@code systemExtensionsAllowed@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowedNextLink(String systemExtensionsAllowedNextLink) {
            this.systemExtensionsAllowedNextLink = systemExtensionsAllowedNextLink;
            this.changedFields = changedFields.add("systemExtensionsAllowed");
            return this;
        }

        /**
         * <i>“Gets or sets a list of allowed team identifiers. Any system extension signed
         * with any of the specified team identifiers will be approved.”</i>
         * 
         * @param systemExtensionsAllowedTeamIdentifiers
         *            value of {@code systemExtensionsAllowedTeamIdentifiers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowedTeamIdentifiers(List<String> systemExtensionsAllowedTeamIdentifiers) {
            this.systemExtensionsAllowedTeamIdentifiers = systemExtensionsAllowedTeamIdentifiers;
            this.changedFields = changedFields.add("systemExtensionsAllowedTeamIdentifiers");
            return this;
        }

        /**
         * <i>“Gets or sets a list of allowed team identifiers. Any system extension signed
         * with any of the specified team identifiers will be approved.”</i>
         * 
         * @param systemExtensionsAllowedTeamIdentifiers
         *            value of {@code systemExtensionsAllowedTeamIdentifiers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowedTeamIdentifiers(String... systemExtensionsAllowedTeamIdentifiers) {
            return systemExtensionsAllowedTeamIdentifiers(Arrays.asList(systemExtensionsAllowedTeamIdentifiers));
        }

        /**
         * <i>“Gets or sets a list of allowed team identifiers. Any system extension signed
         * with any of the specified team identifiers will be approved.”</i>
         * 
         * @param systemExtensionsAllowedTeamIdentifiersNextLink
         *            value of {@code systemExtensionsAllowedTeamIdentifiers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowedTeamIdentifiersNextLink(String systemExtensionsAllowedTeamIdentifiersNextLink) {
            this.systemExtensionsAllowedTeamIdentifiersNextLink = systemExtensionsAllowedTeamIdentifiersNextLink;
            this.changedFields = changedFields.add("systemExtensionsAllowedTeamIdentifiers");
            return this;
        }

        /**
         * <i>“Gets or sets a list of allowed macOS system extension types. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param systemExtensionsAllowedTypes
         *            value of {@code systemExtensionsAllowedTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowedTypes(List<MacOSSystemExtensionTypeMapping> systemExtensionsAllowedTypes) {
            this.systemExtensionsAllowedTypes = systemExtensionsAllowedTypes;
            this.changedFields = changedFields.add("systemExtensionsAllowedTypes");
            return this;
        }

        /**
         * <i>“Gets or sets a list of allowed macOS system extension types. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param systemExtensionsAllowedTypes
         *            value of {@code systemExtensionsAllowedTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowedTypes(MacOSSystemExtensionTypeMapping... systemExtensionsAllowedTypes) {
            return systemExtensionsAllowedTypes(Arrays.asList(systemExtensionsAllowedTypes));
        }

        /**
         * <i>“Gets or sets a list of allowed macOS system extension types. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param systemExtensionsAllowedTypesNextLink
         *            value of {@code systemExtensionsAllowedTypes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsAllowedTypesNextLink(String systemExtensionsAllowedTypesNextLink) {
            this.systemExtensionsAllowedTypesNextLink = systemExtensionsAllowedTypesNextLink;
            this.changedFields = changedFields.add("systemExtensionsAllowedTypes");
            return this;
        }

        /**
         * <i>“Gets or sets whether to allow the user to approve additional system extensions
         * not explicitly allowed by configuration profiles.”</i>
         * 
         * @param systemExtensionsBlockOverride
         *            value of {@code systemExtensionsBlockOverride} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemExtensionsBlockOverride(Boolean systemExtensionsBlockOverride) {
            this.systemExtensionsBlockOverride = systemExtensionsBlockOverride;
            this.changedFields = changedFields.add("systemExtensionsBlockOverride");
            return this;
        }

        public MacOSExtensionsConfiguration build() {
            MacOSExtensionsConfiguration _x = new MacOSExtensionsConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSExtensionsConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.kernelExtensionAllowedTeamIdentifiers = kernelExtensionAllowedTeamIdentifiers;
            _x.kernelExtensionAllowedTeamIdentifiersNextLink = kernelExtensionAllowedTeamIdentifiersNextLink;
            _x.kernelExtensionOverridesAllowed = kernelExtensionOverridesAllowed;
            _x.kernelExtensionsAllowed = kernelExtensionsAllowed;
            _x.kernelExtensionsAllowedNextLink = kernelExtensionsAllowedNextLink;
            _x.systemExtensionsAllowed = systemExtensionsAllowed;
            _x.systemExtensionsAllowedNextLink = systemExtensionsAllowedNextLink;
            _x.systemExtensionsAllowedTeamIdentifiers = systemExtensionsAllowedTeamIdentifiers;
            _x.systemExtensionsAllowedTeamIdentifiersNextLink = systemExtensionsAllowedTeamIdentifiersNextLink;
            _x.systemExtensionsAllowedTypes = systemExtensionsAllowedTypes;
            _x.systemExtensionsAllowedTypesNextLink = systemExtensionsAllowedTypesNextLink;
            _x.systemExtensionsBlockOverride = systemExtensionsBlockOverride;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“All kernel extensions validly signed by the team identifiers in this list will
     * be allowed to load.”</i>
     * 
     * @return property kernelExtensionAllowedTeamIdentifiers
     */
    @Property(name="kernelExtensionAllowedTeamIdentifiers")
    @JsonIgnore
    public CollectionPage<String> getKernelExtensionAllowedTeamIdentifiers() {
        return new CollectionPage<String>(contextPath, String.class, this.kernelExtensionAllowedTeamIdentifiers, Optional.ofNullable(kernelExtensionAllowedTeamIdentifiersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kernelExtensionAllowedTeamIdentifiers} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“All kernel extensions validly signed by the team identifiers in this list will
     * be allowed to load.”</i>
     * 
     * @param kernelExtensionAllowedTeamIdentifiers
     *            new value of {@code kernelExtensionAllowedTeamIdentifiers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kernelExtensionAllowedTeamIdentifiers} field changed
     */
    public MacOSExtensionsConfiguration withKernelExtensionAllowedTeamIdentifiers(List<String> kernelExtensionAllowedTeamIdentifiers) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kernelExtensionAllowedTeamIdentifiers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSExtensionsConfiguration");
        _x.kernelExtensionAllowedTeamIdentifiers = kernelExtensionAllowedTeamIdentifiers;
        return _x;
    }

    /**
     * <i>“All kernel extensions validly signed by the team identifiers in this list will
     * be allowed to load.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property kernelExtensionAllowedTeamIdentifiers
     */
    @Property(name="kernelExtensionAllowedTeamIdentifiers")
    @JsonIgnore
    public CollectionPage<String> getKernelExtensionAllowedTeamIdentifiers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.kernelExtensionAllowedTeamIdentifiers, Optional.ofNullable(kernelExtensionAllowedTeamIdentifiersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“If set to true, users can approve additional kernel extensions not explicitly
     * allowed by configurations profiles.”</i>
     * 
     * @return property kernelExtensionOverridesAllowed
     */
    @Property(name="kernelExtensionOverridesAllowed")
    @JsonIgnore
    public Optional<Boolean> getKernelExtensionOverridesAllowed() {
        return Optional.ofNullable(kernelExtensionOverridesAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kernelExtensionOverridesAllowed} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“If set to true, users can approve additional kernel extensions not explicitly
     * allowed by configurations profiles.”</i>
     * 
     * @param kernelExtensionOverridesAllowed
     *            new value of {@code kernelExtensionOverridesAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kernelExtensionOverridesAllowed} field changed
     */
    public MacOSExtensionsConfiguration withKernelExtensionOverridesAllowed(Boolean kernelExtensionOverridesAllowed) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kernelExtensionOverridesAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSExtensionsConfiguration");
        _x.kernelExtensionOverridesAllowed = kernelExtensionOverridesAllowed;
        return _x;
    }

    /**
     * <i>“A list of kernel extensions that will be allowed to load. . This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property kernelExtensionsAllowed
     */
    @Property(name="kernelExtensionsAllowed")
    @JsonIgnore
    public CollectionPage<MacOSKernelExtension> getKernelExtensionsAllowed() {
        return new CollectionPage<MacOSKernelExtension>(contextPath, MacOSKernelExtension.class, this.kernelExtensionsAllowed, Optional.ofNullable(kernelExtensionsAllowedNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kernelExtensionsAllowed} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A list of kernel extensions that will be allowed to load. . This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param kernelExtensionsAllowed
     *            new value of {@code kernelExtensionsAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kernelExtensionsAllowed} field changed
     */
    public MacOSExtensionsConfiguration withKernelExtensionsAllowed(List<MacOSKernelExtension> kernelExtensionsAllowed) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kernelExtensionsAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSExtensionsConfiguration");
        _x.kernelExtensionsAllowed = kernelExtensionsAllowed;
        return _x;
    }

    /**
     * <i>“A list of kernel extensions that will be allowed to load. . This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property kernelExtensionsAllowed
     */
    @Property(name="kernelExtensionsAllowed")
    @JsonIgnore
    public CollectionPage<MacOSKernelExtension> getKernelExtensionsAllowed(HttpRequestOptions options) {
        return new CollectionPage<MacOSKernelExtension>(contextPath, MacOSKernelExtension.class, this.kernelExtensionsAllowed, Optional.ofNullable(kernelExtensionsAllowedNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a list of allowed macOS system extensions. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property systemExtensionsAllowed
     */
    @Property(name="systemExtensionsAllowed")
    @JsonIgnore
    public CollectionPage<MacOSSystemExtension> getSystemExtensionsAllowed() {
        return new CollectionPage<MacOSSystemExtension>(contextPath, MacOSSystemExtension.class, this.systemExtensionsAllowed, Optional.ofNullable(systemExtensionsAllowedNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemExtensionsAllowed} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a list of allowed macOS system extensions. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param systemExtensionsAllowed
     *            new value of {@code systemExtensionsAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemExtensionsAllowed} field changed
     */
    public MacOSExtensionsConfiguration withSystemExtensionsAllowed(List<MacOSSystemExtension> systemExtensionsAllowed) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemExtensionsAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSExtensionsConfiguration");
        _x.systemExtensionsAllowed = systemExtensionsAllowed;
        return _x;
    }

    /**
     * <i>“Gets or sets a list of allowed macOS system extensions. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property systemExtensionsAllowed
     */
    @Property(name="systemExtensionsAllowed")
    @JsonIgnore
    public CollectionPage<MacOSSystemExtension> getSystemExtensionsAllowed(HttpRequestOptions options) {
        return new CollectionPage<MacOSSystemExtension>(contextPath, MacOSSystemExtension.class, this.systemExtensionsAllowed, Optional.ofNullable(systemExtensionsAllowedNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a list of allowed team identifiers. Any system extension signed
     * with any of the specified team identifiers will be approved.”</i>
     * 
     * @return property systemExtensionsAllowedTeamIdentifiers
     */
    @Property(name="systemExtensionsAllowedTeamIdentifiers")
    @JsonIgnore
    public CollectionPage<String> getSystemExtensionsAllowedTeamIdentifiers() {
        return new CollectionPage<String>(contextPath, String.class, this.systemExtensionsAllowedTeamIdentifiers, Optional.ofNullable(systemExtensionsAllowedTeamIdentifiersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemExtensionsAllowedTeamIdentifiers} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a list of allowed team identifiers. Any system extension signed
     * with any of the specified team identifiers will be approved.”</i>
     * 
     * @param systemExtensionsAllowedTeamIdentifiers
     *            new value of {@code systemExtensionsAllowedTeamIdentifiers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemExtensionsAllowedTeamIdentifiers} field changed
     */
    public MacOSExtensionsConfiguration withSystemExtensionsAllowedTeamIdentifiers(List<String> systemExtensionsAllowedTeamIdentifiers) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemExtensionsAllowedTeamIdentifiers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSExtensionsConfiguration");
        _x.systemExtensionsAllowedTeamIdentifiers = systemExtensionsAllowedTeamIdentifiers;
        return _x;
    }

    /**
     * <i>“Gets or sets a list of allowed team identifiers. Any system extension signed
     * with any of the specified team identifiers will be approved.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property systemExtensionsAllowedTeamIdentifiers
     */
    @Property(name="systemExtensionsAllowedTeamIdentifiers")
    @JsonIgnore
    public CollectionPage<String> getSystemExtensionsAllowedTeamIdentifiers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.systemExtensionsAllowedTeamIdentifiers, Optional.ofNullable(systemExtensionsAllowedTeamIdentifiersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a list of allowed macOS system extension types. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property systemExtensionsAllowedTypes
     */
    @Property(name="systemExtensionsAllowedTypes")
    @JsonIgnore
    public CollectionPage<MacOSSystemExtensionTypeMapping> getSystemExtensionsAllowedTypes() {
        return new CollectionPage<MacOSSystemExtensionTypeMapping>(contextPath, MacOSSystemExtensionTypeMapping.class, this.systemExtensionsAllowedTypes, Optional.ofNullable(systemExtensionsAllowedTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemExtensionsAllowedTypes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a list of allowed macOS system extension types. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param systemExtensionsAllowedTypes
     *            new value of {@code systemExtensionsAllowedTypes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemExtensionsAllowedTypes} field changed
     */
    public MacOSExtensionsConfiguration withSystemExtensionsAllowedTypes(List<MacOSSystemExtensionTypeMapping> systemExtensionsAllowedTypes) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemExtensionsAllowedTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSExtensionsConfiguration");
        _x.systemExtensionsAllowedTypes = systemExtensionsAllowedTypes;
        return _x;
    }

    /**
     * <i>“Gets or sets a list of allowed macOS system extension types. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property systemExtensionsAllowedTypes
     */
    @Property(name="systemExtensionsAllowedTypes")
    @JsonIgnore
    public CollectionPage<MacOSSystemExtensionTypeMapping> getSystemExtensionsAllowedTypes(HttpRequestOptions options) {
        return new CollectionPage<MacOSSystemExtensionTypeMapping>(contextPath, MacOSSystemExtensionTypeMapping.class, this.systemExtensionsAllowedTypes, Optional.ofNullable(systemExtensionsAllowedTypesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets whether to allow the user to approve additional system extensions
     * not explicitly allowed by configuration profiles.”</i>
     * 
     * @return property systemExtensionsBlockOverride
     */
    @Property(name="systemExtensionsBlockOverride")
    @JsonIgnore
    public Optional<Boolean> getSystemExtensionsBlockOverride() {
        return Optional.ofNullable(systemExtensionsBlockOverride);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemExtensionsBlockOverride} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets whether to allow the user to approve additional system extensions
     * not explicitly allowed by configuration profiles.”</i>
     * 
     * @param systemExtensionsBlockOverride
     *            new value of {@code systemExtensionsBlockOverride} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemExtensionsBlockOverride} field changed
     */
    public MacOSExtensionsConfiguration withSystemExtensionsBlockOverride(Boolean systemExtensionsBlockOverride) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemExtensionsBlockOverride");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSExtensionsConfiguration");
        _x.systemExtensionsBlockOverride = systemExtensionsBlockOverride;
        return _x;
    }

    public MacOSExtensionsConfiguration withUnmappedField(String name, Object value) {
        MacOSExtensionsConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSExtensionsConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSExtensionsConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSExtensionsConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSExtensionsConfiguration _copy() {
        MacOSExtensionsConfiguration _x = new MacOSExtensionsConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.kernelExtensionAllowedTeamIdentifiers = kernelExtensionAllowedTeamIdentifiers;
        _x.kernelExtensionOverridesAllowed = kernelExtensionOverridesAllowed;
        _x.kernelExtensionsAllowed = kernelExtensionsAllowed;
        _x.systemExtensionsAllowed = systemExtensionsAllowed;
        _x.systemExtensionsAllowedTeamIdentifiers = systemExtensionsAllowedTeamIdentifiers;
        _x.systemExtensionsAllowedTypes = systemExtensionsAllowedTypes;
        _x.systemExtensionsBlockOverride = systemExtensionsBlockOverride;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSExtensionsConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("kernelExtensionAllowedTeamIdentifiers=");
        b.append(this.kernelExtensionAllowedTeamIdentifiers);
        b.append(", ");
        b.append("kernelExtensionOverridesAllowed=");
        b.append(this.kernelExtensionOverridesAllowed);
        b.append(", ");
        b.append("kernelExtensionsAllowed=");
        b.append(this.kernelExtensionsAllowed);
        b.append(", ");
        b.append("systemExtensionsAllowed=");
        b.append(this.systemExtensionsAllowed);
        b.append(", ");
        b.append("systemExtensionsAllowedTeamIdentifiers=");
        b.append(this.systemExtensionsAllowedTeamIdentifiers);
        b.append(", ");
        b.append("systemExtensionsAllowedTypes=");
        b.append(this.systemExtensionsAllowedTypes);
        b.append(", ");
        b.append("systemExtensionsBlockOverride=");
        b.append(this.systemExtensionsBlockOverride);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
