package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.PublicationFacet;
import odata.msgraph.client.beta.entity.request.FieldValueSetRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "fields"})
@JsonInclude(Include.NON_NULL)
public class ListItemVersion extends BaseItemVersion implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.listItemVersion";
    }

    @JsonProperty("fields")
    protected FieldValueSet fields;

    protected ListItemVersion() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderListItemVersion() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PublicationFacet publication;
        private FieldValueSet fields;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder publication(PublicationFacet publication) {
            this.publication = publication;
            this.changedFields = changedFields.add("publication");
            return this;
        }

        public Builder fields(FieldValueSet fields) {
            this.fields = fields;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public ListItemVersion build() {
            ListItemVersion _x = new ListItemVersion();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.listItemVersion";
            _x.id = id;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.publication = publication;
            _x.fields = fields;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public ListItemVersion withUnmappedField(String name, Object value) {
        ListItemVersion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="fields")
    @JsonIgnore
    public FieldValueSetRequest getFields() {
        return new FieldValueSetRequest(contextPath.addSegment("fields"), Optional.ofNullable(fields));
    }

    public ListItemVersion withFields(FieldValueSet fields) {
        ListItemVersion _x = _copy();
        _x.changedFields = changedFields.add("fields");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItemVersion");
        _x.fields = fields;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ListItemVersion patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ListItemVersion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ListItemVersion put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ListItemVersion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ListItemVersion _copy() {
        ListItemVersion _x = new ListItemVersion();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.publication = publication;
        _x.fields = fields;
        return _x;
    }

    @Action(name = "restoreVersion")
    @JsonIgnore
    public ActionRequestNoReturn restoreVersion() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restoreVersion"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ListItemVersion[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("publication=");
        b.append(this.publication);
        b.append(", ");
        b.append("fields=");
        b.append(this.fields);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
