package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.ListInfo;
import odata.msgraph.client.beta.complex.SharepointIds;
import odata.msgraph.client.beta.complex.SystemFacet;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RichLongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SubscriptionCollectionRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "list", 
    "sharepointIds", 
    "system", 
    "activities", 
    "columns", 
    "contentTypes", 
    "drive", 
    "items", 
    "operations", 
    "subscriptions"})
@JsonInclude(Include.NON_NULL)
public class List extends BaseItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.list";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("list")
    protected ListInfo list;

    @JsonProperty("sharepointIds")
    protected SharepointIds sharepointIds;

    @JsonProperty("system")
    protected SystemFacet system;

    @JsonProperty("activities")
    protected java.util.List<ItemActivityOLD> activities;

    @JsonProperty("columns")
    protected java.util.List<ColumnDefinition> columns;

    @JsonProperty("contentTypes")
    protected java.util.List<ContentType> contentTypes;

    @JsonProperty("drive")
    protected Drive drive;

    @JsonProperty("items")
    protected java.util.List<ListItem> items;

    @JsonProperty("operations")
    protected java.util.List<RichLongRunningOperation> operations;

    @JsonProperty("subscriptions")
    protected java.util.List<Subscription> subscriptions;

    protected List() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderList() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String eTag;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private ItemReference parentReference;
        private String webUrl;
        private String displayName;
        private ListInfo list;
        private SharepointIds sharepointIds;
        private SystemFacet system;
        private java.util.List<ItemActivityOLD> activities;
        private java.util.List<ColumnDefinition> columns;
        private java.util.List<ContentType> contentTypes;
        private Drive drive;
        private java.util.List<ListItem> items;
        private java.util.List<RichLongRunningOperation> operations;
        private java.util.List<Subscription> subscriptions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentReference(ItemReference parentReference) {
            this.parentReference = parentReference;
            this.changedFields = changedFields.add("parentReference");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder list(ListInfo list) {
            this.list = list;
            this.changedFields = changedFields.add("list");
            return this;
        }

        public Builder sharepointIds(SharepointIds sharepointIds) {
            this.sharepointIds = sharepointIds;
            this.changedFields = changedFields.add("sharepointIds");
            return this;
        }

        public Builder system(SystemFacet system) {
            this.system = system;
            this.changedFields = changedFields.add("system");
            return this;
        }

        public Builder activities(java.util.List<ItemActivityOLD> activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder activities(ItemActivityOLD... activities) {
            return activities(Arrays.asList(activities));
        }

        public Builder columns(java.util.List<ColumnDefinition> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("columns");
            return this;
        }

        public Builder columns(ColumnDefinition... columns) {
            return columns(Arrays.asList(columns));
        }

        public Builder contentTypes(java.util.List<ContentType> contentTypes) {
            this.contentTypes = contentTypes;
            this.changedFields = changedFields.add("contentTypes");
            return this;
        }

        public Builder contentTypes(ContentType... contentTypes) {
            return contentTypes(Arrays.asList(contentTypes));
        }

        public Builder drive(Drive drive) {
            this.drive = drive;
            this.changedFields = changedFields.add("drive");
            return this;
        }

        public Builder items(java.util.List<ListItem> items) {
            this.items = items;
            this.changedFields = changedFields.add("items");
            return this;
        }

        public Builder items(ListItem... items) {
            return items(Arrays.asList(items));
        }

        public Builder operations(java.util.List<RichLongRunningOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(RichLongRunningOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder subscriptions(java.util.List<Subscription> subscriptions) {
            this.subscriptions = subscriptions;
            this.changedFields = changedFields.add("subscriptions");
            return this;
        }

        public Builder subscriptions(Subscription... subscriptions) {
            return subscriptions(Arrays.asList(subscriptions));
        }

        public List build() {
            List _x = new List();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.list";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.eTag = eTag;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.parentReference = parentReference;
            _x.webUrl = webUrl;
            _x.displayName = displayName;
            _x.list = list;
            _x.sharepointIds = sharepointIds;
            _x.system = system;
            _x.activities = activities;
            _x.columns = columns;
            _x.contentTypes = contentTypes;
            _x.drive = drive;
            _x.items = items;
            _x.operations = operations;
            _x.subscriptions = subscriptions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public List withDisplayName(String displayName) {
        List _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="list")
    @JsonIgnore
    public Optional<ListInfo> getList() {
        return Optional.ofNullable(list);
    }

    public List withList(ListInfo list) {
        List _x = _copy();
        _x.changedFields = changedFields.add("list");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.list = list;
        return _x;
    }

    @Property(name="sharepointIds")
    @JsonIgnore
    public Optional<SharepointIds> getSharepointIds() {
        return Optional.ofNullable(sharepointIds);
    }

    public List withSharepointIds(SharepointIds sharepointIds) {
        List _x = _copy();
        _x.changedFields = changedFields.add("sharepointIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.sharepointIds = sharepointIds;
        return _x;
    }

    @Property(name="system")
    @JsonIgnore
    public Optional<SystemFacet> getSystem() {
        return Optional.ofNullable(system);
    }

    public List withSystem(SystemFacet system) {
        List _x = _copy();
        _x.changedFields = changedFields.add("system");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.system = system;
        return _x;
    }

    public List withUnmappedField(String name, Object value) {
        List _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activities")
    @JsonIgnore
    public ItemActivityOLDCollectionRequest getActivities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"), Optional.ofNullable(activities));
    }

    @NavigationProperty(name="columns")
    @JsonIgnore
    public ColumnDefinitionCollectionRequest getColumns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"), Optional.ofNullable(columns));
    }

    @NavigationProperty(name="contentTypes")
    @JsonIgnore
    public ContentTypeCollectionRequest getContentTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("contentTypes"), Optional.ofNullable(contentTypes));
    }

    @NavigationProperty(name="drive")
    @JsonIgnore
    public DriveRequest getDrive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.ofNullable(drive));
    }

    @NavigationProperty(name="items")
    @JsonIgnore
    public ListItemCollectionRequest getItems() {
        return new ListItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.ofNullable(items));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public RichLongRunningOperationCollectionRequest getOperations() {
        return new RichLongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="subscriptions")
    @JsonIgnore
    public SubscriptionCollectionRequest getSubscriptions() {
        return new SubscriptionCollectionRequest(
                        contextPath.addSegment("subscriptions"), Optional.ofNullable(subscriptions));
    }

    public List withActivities(java.util.List<ItemActivityOLD> activities) {
        List _x = _copy();
        _x.changedFields = changedFields.add("activities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.activities = activities;
        return _x;
    }

    public List withColumns(java.util.List<ColumnDefinition> columns) {
        List _x = _copy();
        _x.changedFields = changedFields.add("columns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.columns = columns;
        return _x;
    }

    public List withContentTypes(java.util.List<ContentType> contentTypes) {
        List _x = _copy();
        _x.changedFields = changedFields.add("contentTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.contentTypes = contentTypes;
        return _x;
    }

    public List withDrive(Drive drive) {
        List _x = _copy();
        _x.changedFields = changedFields.add("drive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.drive = drive;
        return _x;
    }

    public List withItems(java.util.List<ListItem> items) {
        List _x = _copy();
        _x.changedFields = changedFields.add("items");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.items = items;
        return _x;
    }

    public List withOperations(java.util.List<RichLongRunningOperation> operations) {
        List _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.operations = operations;
        return _x;
    }

    public List withSubscriptions(java.util.List<Subscription> subscriptions) {
        List _x = _copy();
        _x.changedFields = changedFields.add("subscriptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.list");
        _x.subscriptions = subscriptions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public List patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        List _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public List put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        List _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private List _copy() {
        List _x = new List();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.eTag = eTag;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.parentReference = parentReference;
        _x.webUrl = webUrl;
        _x.displayName = displayName;
        _x.list = list;
        _x.sharepointIds = sharepointIds;
        _x.system = system;
        _x.activities = activities;
        _x.columns = columns;
        _x.contentTypes = contentTypes;
        _x.drive = drive;
        _x.items = items;
        _x.operations = operations;
        _x.subscriptions = subscriptions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("List[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentReference=");
        b.append(this.parentReference);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("list=");
        b.append(this.list);
        b.append(", ");
        b.append("sharepointIds=");
        b.append(this.sharepointIds);
        b.append(", ");
        b.append("system=");
        b.append(this.system);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("contentTypes=");
        b.append(this.contentTypes);
        b.append(", ");
        b.append("drive=");
        b.append(this.drive);
        b.append(", ");
        b.append("items=");
        b.append(this.items);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("subscriptions=");
        b.append(this.subscriptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
