package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.request.AccountRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountId", 
    "accountNumber", 
    "amount", 
    "comment", 
    "description", 
    "documentNumber", 
    "externalDocumentNumber", 
    "journalDisplayName", 
    "lastModifiedDateTime", 
    "lineNumber", 
    "postingDate", 
    "account"})
@JsonInclude(Include.NON_NULL)
public class JournalLine extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.journalLine";
    }

    @JsonProperty("accountId")
    protected UUID accountId;

    @JsonProperty("accountNumber")
    protected String accountNumber;

    @JsonProperty("amount")
    protected BigDecimal amount;

    @JsonProperty("comment")
    protected String comment;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("documentNumber")
    protected String documentNumber;

    @JsonProperty("externalDocumentNumber")
    protected String externalDocumentNumber;

    @JsonProperty("journalDisplayName")
    protected String journalDisplayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lineNumber")
    protected Integer lineNumber;

    @JsonProperty("postingDate")
    protected LocalDate postingDate;

    @JsonProperty("account")
    protected Account account;

    protected JournalLine() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderJournalLine() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UUID accountId;
        private String accountNumber;
        private BigDecimal amount;
        private String comment;
        private String description;
        private String documentNumber;
        private String externalDocumentNumber;
        private String journalDisplayName;
        private OffsetDateTime lastModifiedDateTime;
        private Integer lineNumber;
        private LocalDate postingDate;
        private Account account;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accountId(UUID accountId) {
            this.accountId = accountId;
            this.changedFields = changedFields.add("accountId");
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            this.changedFields = changedFields.add("accountNumber");
            return this;
        }

        public Builder amount(BigDecimal amount) {
            this.amount = amount;
            this.changedFields = changedFields.add("amount");
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.changedFields = changedFields.add("comment");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder documentNumber(String documentNumber) {
            this.documentNumber = documentNumber;
            this.changedFields = changedFields.add("documentNumber");
            return this;
        }

        public Builder externalDocumentNumber(String externalDocumentNumber) {
            this.externalDocumentNumber = externalDocumentNumber;
            this.changedFields = changedFields.add("externalDocumentNumber");
            return this;
        }

        public Builder journalDisplayName(String journalDisplayName) {
            this.journalDisplayName = journalDisplayName;
            this.changedFields = changedFields.add("journalDisplayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            this.changedFields = changedFields.add("lineNumber");
            return this;
        }

        public Builder postingDate(LocalDate postingDate) {
            this.postingDate = postingDate;
            this.changedFields = changedFields.add("postingDate");
            return this;
        }

        public Builder account(Account account) {
            this.account = account;
            this.changedFields = changedFields.add("account");
            return this;
        }

        public JournalLine build() {
            JournalLine _x = new JournalLine();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.journalLine";
            _x.id = id;
            _x.accountId = accountId;
            _x.accountNumber = accountNumber;
            _x.amount = amount;
            _x.comment = comment;
            _x.description = description;
            _x.documentNumber = documentNumber;
            _x.externalDocumentNumber = externalDocumentNumber;
            _x.journalDisplayName = journalDisplayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lineNumber = lineNumber;
            _x.postingDate = postingDate;
            _x.account = account;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accountId")
    @JsonIgnore
    public Optional<UUID> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    public JournalLine withAccountId(UUID accountId) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("accountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.accountId = accountId;
        return _x;
    }

    @Property(name="accountNumber")
    @JsonIgnore
    public Optional<String> getAccountNumber() {
        return Optional.ofNullable(accountNumber);
    }

    public JournalLine withAccountNumber(String accountNumber) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("accountNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.accountNumber = accountNumber;
        return _x;
    }

    @Property(name="amount")
    @JsonIgnore
    public Optional<BigDecimal> getAmount() {
        return Optional.ofNullable(amount);
    }

    public JournalLine withAmount(BigDecimal amount) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("amount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.amount = amount;
        return _x;
    }

    @Property(name="comment")
    @JsonIgnore
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    public JournalLine withComment(String comment) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("comment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.comment = comment;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public JournalLine withDescription(String description) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.description = description;
        return _x;
    }

    @Property(name="documentNumber")
    @JsonIgnore
    public Optional<String> getDocumentNumber() {
        return Optional.ofNullable(documentNumber);
    }

    public JournalLine withDocumentNumber(String documentNumber) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("documentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.documentNumber = documentNumber;
        return _x;
    }

    @Property(name="externalDocumentNumber")
    @JsonIgnore
    public Optional<String> getExternalDocumentNumber() {
        return Optional.ofNullable(externalDocumentNumber);
    }

    public JournalLine withExternalDocumentNumber(String externalDocumentNumber) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("externalDocumentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.externalDocumentNumber = externalDocumentNumber;
        return _x;
    }

    @Property(name="journalDisplayName")
    @JsonIgnore
    public Optional<String> getJournalDisplayName() {
        return Optional.ofNullable(journalDisplayName);
    }

    public JournalLine withJournalDisplayName(String journalDisplayName) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("journalDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.journalDisplayName = journalDisplayName;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public JournalLine withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lineNumber")
    @JsonIgnore
    public Optional<Integer> getLineNumber() {
        return Optional.ofNullable(lineNumber);
    }

    public JournalLine withLineNumber(Integer lineNumber) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("lineNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.lineNumber = lineNumber;
        return _x;
    }

    @Property(name="postingDate")
    @JsonIgnore
    public Optional<LocalDate> getPostingDate() {
        return Optional.ofNullable(postingDate);
    }

    public JournalLine withPostingDate(LocalDate postingDate) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("postingDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.postingDate = postingDate;
        return _x;
    }

    public JournalLine withUnmappedField(String name, Object value) {
        JournalLine _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public AccountRequest getAccount() {
        return new AccountRequest(contextPath.addSegment("account"), Optional.ofNullable(account));
    }

    public JournalLine withAccount(Account account) {
        JournalLine _x = _copy();
        _x.changedFields = changedFields.add("account");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journalLine");
        _x.account = account;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public JournalLine patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        JournalLine _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public JournalLine put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        JournalLine _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private JournalLine _copy() {
        JournalLine _x = new JournalLine();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accountId = accountId;
        _x.accountNumber = accountNumber;
        _x.amount = amount;
        _x.comment = comment;
        _x.description = description;
        _x.documentNumber = documentNumber;
        _x.externalDocumentNumber = externalDocumentNumber;
        _x.journalDisplayName = journalDisplayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lineNumber = lineNumber;
        _x.postingDate = postingDate;
        _x.account = account;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("JournalLine[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accountId=");
        b.append(this.accountId);
        b.append(", ");
        b.append("accountNumber=");
        b.append(this.accountNumber);
        b.append(", ");
        b.append("amount=");
        b.append(this.amount);
        b.append(", ");
        b.append("comment=");
        b.append(this.comment);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("documentNumber=");
        b.append(this.documentNumber);
        b.append(", ");
        b.append("externalDocumentNumber=");
        b.append(this.externalDocumentNumber);
        b.append(", ");
        b.append("journalDisplayName=");
        b.append(this.journalDisplayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lineNumber=");
        b.append(this.lineNumber);
        b.append(", ");
        b.append("postingDate=");
        b.append(this.postingDate);
        b.append(", ");
        b.append("account=");
        b.append(this.account);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
