package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSources;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "isPending", 
    "issuedDate", 
    "issuingAuthority", 
    "number", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class ItemPatent extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemPatent";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isPending")
    protected Boolean isPending;

    @JsonProperty("issuedDate")
    protected LocalDate issuedDate;

    @JsonProperty("issuingAuthority")
    protected String issuingAuthority;

    @JsonProperty("number")
    protected String number;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected ItemPatent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItemPatent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private InferenceData inference;
        private Boolean isSearchable;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PersonDataSources source;
        private String description;
        private String displayName;
        private Boolean isPending;
        private LocalDate issuedDate;
        private String issuingAuthority;
        private String number;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder source(PersonDataSources source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isPending(Boolean isPending) {
            this.isPending = isPending;
            this.changedFields = changedFields.add("isPending");
            return this;
        }

        public Builder issuedDate(LocalDate issuedDate) {
            this.issuedDate = issuedDate;
            this.changedFields = changedFields.add("issuedDate");
            return this;
        }

        public Builder issuingAuthority(String issuingAuthority) {
            this.issuingAuthority = issuingAuthority;
            this.changedFields = changedFields.add("issuingAuthority");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public ItemPatent build() {
            ItemPatent _x = new ItemPatent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemPatent";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.inference = inference;
            _x.isSearchable = isSearchable;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.source = source;
            _x.description = description;
            _x.displayName = displayName;
            _x.isPending = isPending;
            _x.issuedDate = issuedDate;
            _x.issuingAuthority = issuingAuthority;
            _x.number = number;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ItemPatent withDescription(String description) {
        ItemPatent _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPatent");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ItemPatent withDisplayName(String displayName) {
        ItemPatent _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPatent");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isPending")
    @JsonIgnore
    public Optional<Boolean> getIsPending() {
        return Optional.ofNullable(isPending);
    }

    public ItemPatent withIsPending(Boolean isPending) {
        ItemPatent _x = _copy();
        _x.changedFields = changedFields.add("isPending");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPatent");
        _x.isPending = isPending;
        return _x;
    }

    @Property(name="issuedDate")
    @JsonIgnore
    public Optional<LocalDate> getIssuedDate() {
        return Optional.ofNullable(issuedDate);
    }

    public ItemPatent withIssuedDate(LocalDate issuedDate) {
        ItemPatent _x = _copy();
        _x.changedFields = changedFields.add("issuedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPatent");
        _x.issuedDate = issuedDate;
        return _x;
    }

    @Property(name="issuingAuthority")
    @JsonIgnore
    public Optional<String> getIssuingAuthority() {
        return Optional.ofNullable(issuingAuthority);
    }

    public ItemPatent withIssuingAuthority(String issuingAuthority) {
        ItemPatent _x = _copy();
        _x.changedFields = changedFields.add("issuingAuthority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPatent");
        _x.issuingAuthority = issuingAuthority;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public ItemPatent withNumber(String number) {
        ItemPatent _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPatent");
        _x.number = number;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public ItemPatent withWebUrl(String webUrl) {
        ItemPatent _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPatent");
        _x.webUrl = webUrl;
        return _x;
    }

    public ItemPatent withUnmappedField(String name, Object value) {
        ItemPatent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemPatent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ItemPatent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemPatent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ItemPatent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ItemPatent _copy() {
        ItemPatent _x = new ItemPatent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.inference = inference;
        _x.isSearchable = isSearchable;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.source = source;
        _x.description = description;
        _x.displayName = displayName;
        _x.isPending = isPending;
        _x.issuedDate = issuedDate;
        _x.issuingAuthority = issuingAuthority;
        _x.number = number;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemPatent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isPending=");
        b.append(this.isPending);
        b.append(", ");
        b.append("issuedDate=");
        b.append(this.issuedDate);
        b.append(", ");
        b.append("issuingAuthority=");
        b.append(this.issuingAuthority);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
