package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.OutlookItemRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "item"})
@JsonInclude(Include.NON_NULL)
public class ItemAttachment extends Attachment implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemAttachment";
    }

    @JsonProperty("item")
    protected OutlookItem item;

    protected ItemAttachment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItemAttachment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String contentType;
        private Boolean isInline;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private Integer size;
        private OutlookItem item;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder isInline(Boolean isInline) {
            this.isInline = isInline;
            this.changedFields = changedFields.add("isInline");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param item
         *            value of {@code item} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder item(OutlookItem item) {
            this.item = item;
            this.changedFields = changedFields.add("item");
            return this;
        }

        public ItemAttachment build() {
            ItemAttachment _x = new ItemAttachment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemAttachment";
            _x.id = id;
            _x.contentType = contentType;
            _x.isInline = isInline;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.size = size;
            _x.item = item;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public ItemAttachment withUnmappedField(String name, Object value) {
        ItemAttachment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property item
     */
    @NavigationProperty(name="item")
    @JsonIgnore
    public OutlookItemRequest getItem() {
        return new OutlookItemRequest(contextPath.addSegment("item"), Optional.ofNullable(item));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code item} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param item
     *            new value of {@code item} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code item} field changed
     */
    public ItemAttachment withItem(OutlookItem item) {
        ItemAttachment _x = _copy();
        _x.changedFields = changedFields.add("item");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemAttachment");
        _x.item = item;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemAttachment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ItemAttachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemAttachment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ItemAttachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ItemAttachment _copy() {
        ItemAttachment _x = new ItemAttachment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contentType = contentType;
        _x.isInline = isInline;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.size = size;
        _x.item = item;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemAttachment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("isInline=");
        b.append(this.isInline);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("item=");
        b.append(this.item);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
