package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IncompleteData;
import odata.msgraph.client.beta.complex.ItemActionStat;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "access", 
    "create", 
    "delete", 
    "edit", 
    "endDateTime", 
    "incompleteData", 
    "isTrending", 
    "move", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class ItemActivityStat extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemActivityStat";
    }

    @JsonProperty("access")
    protected ItemActionStat access;

    @JsonProperty("create")
    protected ItemActionStat create;

    @JsonProperty("delete")
    protected ItemActionStat delete;

    @JsonProperty("edit")
    protected ItemActionStat edit;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("incompleteData")
    protected IncompleteData incompleteData;

    @JsonProperty("isTrending")
    protected Boolean isTrending;

    @JsonProperty("move")
    protected ItemActionStat move;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected ItemActivityStat() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItemActivityStat() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ItemActionStat access;
        private ItemActionStat create;
        private ItemActionStat delete;
        private ItemActionStat edit;
        private OffsetDateTime endDateTime;
        private IncompleteData incompleteData;
        private Boolean isTrending;
        private ItemActionStat move;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder access(ItemActionStat access) {
            this.access = access;
            this.changedFields = changedFields.add("access");
            return this;
        }

        public Builder create(ItemActionStat create) {
            this.create = create;
            this.changedFields = changedFields.add("create");
            return this;
        }

        public Builder delete(ItemActionStat delete) {
            this.delete = delete;
            this.changedFields = changedFields.add("delete");
            return this;
        }

        public Builder edit(ItemActionStat edit) {
            this.edit = edit;
            this.changedFields = changedFields.add("edit");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder incompleteData(IncompleteData incompleteData) {
            this.incompleteData = incompleteData;
            this.changedFields = changedFields.add("incompleteData");
            return this;
        }

        public Builder isTrending(Boolean isTrending) {
            this.isTrending = isTrending;
            this.changedFields = changedFields.add("isTrending");
            return this;
        }

        public Builder move(ItemActionStat move) {
            this.move = move;
            this.changedFields = changedFields.add("move");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public ItemActivityStat build() {
            ItemActivityStat _x = new ItemActivityStat();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemActivityStat";
            _x.id = id;
            _x.access = access;
            _x.create = create;
            _x.delete = delete;
            _x.edit = edit;
            _x.endDateTime = endDateTime;
            _x.incompleteData = incompleteData;
            _x.isTrending = isTrending;
            _x.move = move;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="access")
    @JsonIgnore
    public Optional<ItemActionStat> getAccess() {
        return Optional.ofNullable(access);
    }

    public ItemActivityStat withAccess(ItemActionStat access) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("access");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.access = access;
        return _x;
    }

    @Property(name="create")
    @JsonIgnore
    public Optional<ItemActionStat> getCreate() {
        return Optional.ofNullable(create);
    }

    public ItemActivityStat withCreate(ItemActionStat create) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("create");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.create = create;
        return _x;
    }

    @Property(name="delete")
    @JsonIgnore
    public Optional<ItemActionStat> getDelete() {
        return Optional.ofNullable(delete);
    }

    public ItemActivityStat withDelete(ItemActionStat delete) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("delete");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.delete = delete;
        return _x;
    }

    @Property(name="edit")
    @JsonIgnore
    public Optional<ItemActionStat> getEdit() {
        return Optional.ofNullable(edit);
    }

    public ItemActivityStat withEdit(ItemActionStat edit) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("edit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.edit = edit;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public ItemActivityStat withEndDateTime(OffsetDateTime endDateTime) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="incompleteData")
    @JsonIgnore
    public Optional<IncompleteData> getIncompleteData() {
        return Optional.ofNullable(incompleteData);
    }

    public ItemActivityStat withIncompleteData(IncompleteData incompleteData) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("incompleteData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.incompleteData = incompleteData;
        return _x;
    }

    @Property(name="isTrending")
    @JsonIgnore
    public Optional<Boolean> getIsTrending() {
        return Optional.ofNullable(isTrending);
    }

    public ItemActivityStat withIsTrending(Boolean isTrending) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("isTrending");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.isTrending = isTrending;
        return _x;
    }

    @Property(name="move")
    @JsonIgnore
    public Optional<ItemActionStat> getMove() {
        return Optional.ofNullable(move);
    }

    public ItemActivityStat withMove(ItemActionStat move) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("move");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.move = move;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public ItemActivityStat withStartDateTime(OffsetDateTime startDateTime) {
        ItemActivityStat _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityStat");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public ItemActivityStat withUnmappedField(String name, Object value) {
        ItemActivityStat _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activities")
    @JsonIgnore
    public ItemActivityCollectionRequest getActivities() {
        return new ItemActivityCollectionRequest(
                        contextPath.addSegment("activities"), RequestHelper.getValue(unmappedFields, "activities"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemActivityStat patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ItemActivityStat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemActivityStat put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ItemActivityStat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ItemActivityStat _copy() {
        ItemActivityStat _x = new ItemActivityStat();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.access = access;
        _x.create = create;
        _x.delete = delete;
        _x.edit = edit;
        _x.endDateTime = endDateTime;
        _x.incompleteData = incompleteData;
        _x.isTrending = isTrending;
        _x.move = move;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemActivityStat[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("access=");
        b.append(this.access);
        b.append(", ");
        b.append("create=");
        b.append(this.create);
        b.append(", ");
        b.append("delete=");
        b.append(this.delete);
        b.append(", ");
        b.append("edit=");
        b.append(this.edit);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("incompleteData=");
        b.append(this.incompleteData);
        b.append(", ");
        b.append("isTrending=");
        b.append(this.isTrending);
        b.append(", ");
        b.append("move=");
        b.append(this.move);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
