package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IpRange;

@JsonPropertyOrder({
    "@odata.type", 
    "ipRanges", 
    "isTrusted"})
@JsonInclude(Include.NON_NULL)
public class IpNamedLocation extends NamedLocation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ipNamedLocation";
    }

    @JsonProperty("ipRanges")
    protected List<IpRange> ipRanges;

    @JsonProperty("ipRanges@nextLink")
    protected String ipRangesNextLink;

    @JsonProperty("isTrusted")
    protected Boolean isTrusted;

    protected IpNamedLocation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIpNamedLocation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime modifiedDateTime;
        private List<IpRange> ipRanges;
        private String ipRangesNextLink;
        private Boolean isTrusted;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder ipRanges(List<IpRange> ipRanges) {
            this.ipRanges = ipRanges;
            this.changedFields = changedFields.add("ipRanges");
            return this;
        }

        public Builder ipRanges(IpRange... ipRanges) {
            return ipRanges(Arrays.asList(ipRanges));
        }

        public Builder ipRangesNextLink(String ipRangesNextLink) {
            this.ipRangesNextLink = ipRangesNextLink;
            this.changedFields = changedFields.add("ipRanges");
            return this;
        }

        public Builder isTrusted(Boolean isTrusted) {
            this.isTrusted = isTrusted;
            this.changedFields = changedFields.add("isTrusted");
            return this;
        }

        public IpNamedLocation build() {
            IpNamedLocation _x = new IpNamedLocation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ipNamedLocation";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.modifiedDateTime = modifiedDateTime;
            _x.ipRanges = ipRanges;
            _x.ipRangesNextLink = ipRangesNextLink;
            _x.isTrusted = isTrusted;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="ipRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getIpRanges() {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, this.ipRanges, Optional.ofNullable(ipRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public IpNamedLocation withIpRanges(List<IpRange> ipRanges) {
        IpNamedLocation _x = _copy();
        _x.changedFields = changedFields.add("ipRanges");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipNamedLocation");
        _x.ipRanges = ipRanges;
        return _x;
    }

    @Property(name="ipRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getIpRanges(HttpRequestOptions options) {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, this.ipRanges, Optional.ofNullable(ipRangesNextLink), Collections.emptyList(), options);
    }

    @Property(name="isTrusted")
    @JsonIgnore
    public Optional<Boolean> getIsTrusted() {
        return Optional.ofNullable(isTrusted);
    }

    public IpNamedLocation withIsTrusted(Boolean isTrusted) {
        IpNamedLocation _x = _copy();
        _x.changedFields = changedFields.add("isTrusted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipNamedLocation");
        _x.isTrusted = isTrusted;
        return _x;
    }

    public IpNamedLocation withUnmappedField(String name, Object value) {
        IpNamedLocation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IpNamedLocation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IpNamedLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IpNamedLocation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IpNamedLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IpNamedLocation _copy() {
        IpNamedLocation _x = new IpNamedLocation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.modifiedDateTime = modifiedDateTime;
        _x.ipRanges = ipRanges;
        _x.isTrusted = isTrusted;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IpNamedLocation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("ipRanges=");
        b.append(this.ipRanges);
        b.append(", ");
        b.append("isTrusted=");
        b.append(this.isTrusted);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
