package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;


/**
 * <i>“iOS Volume Purchase Program user license assignment. This class does not support
 * Create, Delete, or Update.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class IosVppAppAssignedUserLicense extends IosVppAppAssignedLicense implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosVppAppAssignedUserLicense";
    }

    protected IosVppAppAssignedUserLicense() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosVppAppAssignedUserLicense() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userEmailAddress;
        private String userId;
        private String userName;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder userEmailAddress(String userEmailAddress) {
            this.userEmailAddress = userEmailAddress;
            this.changedFields = changedFields.add("userEmailAddress");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public IosVppAppAssignedUserLicense build() {
            IosVppAppAssignedUserLicense _x = new IosVppAppAssignedUserLicense();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosVppAppAssignedUserLicense";
            _x.id = id;
            _x.userEmailAddress = userEmailAddress;
            _x.userId = userId;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public IosVppAppAssignedUserLicense withUnmappedField(String name, Object value) {
        IosVppAppAssignedUserLicense _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppAppAssignedUserLicense patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosVppAppAssignedUserLicense _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppAppAssignedUserLicense put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosVppAppAssignedUserLicense _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosVppAppAssignedUserLicense _copy() {
        IosVppAppAssignedUserLicense _x = new IosVppAppAssignedUserLicense();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.userEmailAddress = userEmailAddress;
        _x.userId = userId;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosVppAppAssignedUserLicense[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userEmailAddress=");
        b.append(this.userEmailAddress);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
