package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“iOS Volume Purchase Program license assignment. This class does not support
 * Create, Delete, or Update.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userEmailAddress", 
    "userId", 
    "userName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class IosVppAppAssignedLicense extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosVppAppAssignedLicense";
    }

    @JsonProperty("userEmailAddress")
    protected String userEmailAddress;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected IosVppAppAssignedLicense() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosVppAppAssignedLicense() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userEmailAddress;
        private String userId;
        private String userName;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user email address.”</i>
         * 
         * @param userEmailAddress
         *            value of {@code userEmailAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userEmailAddress(String userEmailAddress) {
            this.userEmailAddress = userEmailAddress;
            this.changedFields = changedFields.add("userEmailAddress");
            return this;
        }

        /**
         * <i>“The user ID.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“The user name.”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“The user principal name.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public IosVppAppAssignedLicense build() {
            IosVppAppAssignedLicense _x = new IosVppAppAssignedLicense();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosVppAppAssignedLicense";
            _x.id = id;
            _x.userEmailAddress = userEmailAddress;
            _x.userId = userId;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The user email address.”</i>
     * 
     * @return property userEmailAddress
     */
    @Property(name="userEmailAddress")
    @JsonIgnore
    public Optional<String> getUserEmailAddress() {
        return Optional.ofNullable(userEmailAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userEmailAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user email address.”</i>
     * 
     * @param userEmailAddress
     *            new value of {@code userEmailAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userEmailAddress} field changed
     */
    public IosVppAppAssignedLicense withUserEmailAddress(String userEmailAddress) {
        IosVppAppAssignedLicense _x = _copy();
        _x.changedFields = changedFields.add("userEmailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppAssignedLicense");
        _x.userEmailAddress = userEmailAddress;
        return _x;
    }

    /**
     * <i>“The user ID.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user ID.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public IosVppAppAssignedLicense withUserId(String userId) {
        IosVppAppAssignedLicense _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppAssignedLicense");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“The user name.”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user name.”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public IosVppAppAssignedLicense withUserName(String userName) {
        IosVppAppAssignedLicense _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppAssignedLicense");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“The user principal name.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user principal name.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public IosVppAppAssignedLicense withUserPrincipalName(String userPrincipalName) {
        IosVppAppAssignedLicense _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppAssignedLicense");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public IosVppAppAssignedLicense withUnmappedField(String name, Object value) {
        IosVppAppAssignedLicense _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppAppAssignedLicense patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosVppAppAssignedLicense _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppAppAssignedLicense put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosVppAppAssignedLicense _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosVppAppAssignedLicense _copy() {
        IosVppAppAssignedLicense _x = new IosVppAppAssignedLicense();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.userEmailAddress = userEmailAddress;
        _x.userId = userId;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosVppAppAssignedLicense[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userEmailAddress=");
        b.append(this.userEmailAddress);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
