package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.IosLobAppProvisioningConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppProvisioningConfigGroupAssignmentCollectionRequest;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the iOS Lob App Provisioning Configuration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "expirationDateTime", 
    "lastModifiedDateTime", 
    "payload", 
    "payloadFileName", 
    "roleScopeTagIds", 
    "version", 
    "assignments", 
    "deviceStatuses", 
    "groupAssignments", 
    "userStatuses"})
@JsonInclude(Include.NON_NULL)
public class IosLobAppProvisioningConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosLobAppProvisioningConfiguration";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("payload")
    protected byte[] payload;

    @JsonProperty("payloadFileName")
    protected String payloadFileName;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("assignments")
    protected List<IosLobAppProvisioningConfigurationAssignment> assignments;

    @JsonProperty("deviceStatuses")
    protected List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses;

    @JsonProperty("groupAssignments")
    protected List<MobileAppProvisioningConfigGroupAssignment> groupAssignments;

    @JsonProperty("userStatuses")
    protected List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses;

    protected IosLobAppProvisioningConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosLobAppProvisioningConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime expirationDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private byte[] payload;
        private String payloadFileName;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<IosLobAppProvisioningConfigurationAssignment> assignments;
        private List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses;
        private List<MobileAppProvisioningConfigGroupAssignment> groupAssignments;
        private List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“DateTime the object was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Admin provided description of the Device Configuration.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Admin provided name of the device configuration.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Optional profile expiration date and time.”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“DateTime the object was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Payload. (UTF8 encoded byte array)”</i>
         * 
         * @param payload
         *            value of {@code payload} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder payload(byte[] payload) {
            this.payload = payload;
            this.changedFields = changedFields.add("payload");
            return this;
        }

        /**
         * <i>“Payload file name (*.mobileprovision | *.xml).”</i>
         * 
         * @param payloadFileName
         *            value of {@code payloadFileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder payloadFileName(String payloadFileName) {
            this.payloadFileName = payloadFileName;
            this.changedFields = changedFields.add("payloadFileName");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this iOS LOB app provisioning configuration entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this iOS LOB app provisioning configuration entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this iOS LOB app provisioning configuration entity.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Version of the device configuration.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“The associated group assignments for IosLobAppProvisioningConfiguration.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<IosLobAppProvisioningConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“The associated group assignments for IosLobAppProvisioningConfiguration.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(IosLobAppProvisioningConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“The list of device installation states for this mobile app configuration.”</i>
         * 
         * @param deviceStatuses
         *            value of {@code deviceStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStatuses(List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        /**
         * <i>“The list of device installation states for this mobile app configuration.”</i>
         * 
         * @param deviceStatuses
         *            value of {@code deviceStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStatuses(ManagedDeviceMobileAppConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        /**
         * <i>“The associated group assignments.”</i>
         * 
         * @param groupAssignments
         *            value of {@code groupAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupAssignments(List<MobileAppProvisioningConfigGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        /**
         * <i>“The associated group assignments.”</i>
         * 
         * @param groupAssignments
         *            value of {@code groupAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupAssignments(MobileAppProvisioningConfigGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        /**
         * <i>“The list of user installation states for this mobile app configuration.”</i>
         * 
         * @param userStatuses
         *            value of {@code userStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userStatuses(List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        /**
         * <i>“The list of user installation states for this mobile app configuration.”</i>
         * 
         * @param userStatuses
         *            value of {@code userStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userStatuses(ManagedDeviceMobileAppConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public IosLobAppProvisioningConfiguration build() {
            IosLobAppProvisioningConfiguration _x = new IosLobAppProvisioningConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosLobAppProvisioningConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.expirationDateTime = expirationDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.payload = payload;
            _x.payloadFileName = payloadFileName;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public IosLobAppProvisioningConfiguration withCreatedDateTime(OffsetDateTime createdDateTime) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public IosLobAppProvisioningConfiguration withDescription(String description) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public IosLobAppProvisioningConfiguration withDisplayName(String displayName) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Optional profile expiration date and time.”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Optional profile expiration date and time.”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public IosLobAppProvisioningConfiguration withExpirationDateTime(OffsetDateTime expirationDateTime) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public IosLobAppProvisioningConfiguration withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Payload. (UTF8 encoded byte array)”</i>
     * 
     * @return property payload
     */
    @Property(name="payload")
    @JsonIgnore
    public Optional<byte[]> getPayload() {
        return Optional.ofNullable(payload);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code payload} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Payload. (UTF8 encoded byte array)”</i>
     * 
     * @param payload
     *            new value of {@code payload} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code payload} field changed
     */
    public IosLobAppProvisioningConfiguration withPayload(byte[] payload) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("payload");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.payload = payload;
        return _x;
    }

    /**
     * <i>“Payload file name (*.mobileprovision | *.xml).”</i>
     * 
     * @return property payloadFileName
     */
    @Property(name="payloadFileName")
    @JsonIgnore
    public Optional<String> getPayloadFileName() {
        return Optional.ofNullable(payloadFileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code payloadFileName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Payload file name (*.mobileprovision | *.xml).”</i>
     * 
     * @param payloadFileName
     *            new value of {@code payloadFileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code payloadFileName} field changed
     */
    public IosLobAppProvisioningConfiguration withPayloadFileName(String payloadFileName) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("payloadFileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.payloadFileName = payloadFileName;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this iOS LOB app provisioning configuration entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this iOS LOB app provisioning configuration entity.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public IosLobAppProvisioningConfiguration withRoleScopeTagIds(List<String> roleScopeTagIds) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this iOS LOB app provisioning configuration entity.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Version of the device configuration.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device configuration.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public IosLobAppProvisioningConfiguration withVersion(Integer version) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.version = version;
        return _x;
    }

    public IosLobAppProvisioningConfiguration withUnmappedField(String name, Object value) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The associated group assignments for IosLobAppProvisioningConfiguration.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public IosLobAppProvisioningConfigurationAssignmentCollectionRequest getAssignments() {
        return new IosLobAppProvisioningConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“The list of device installation states for this mobile app configuration.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest getDeviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.ofNullable(deviceStatuses));
    }

    /**
     * <i>“The associated group assignments.”</i>
     * 
     * @return navigational property groupAssignments
     */
    @NavigationProperty(name="groupAssignments")
    @JsonIgnore
    public MobileAppProvisioningConfigGroupAssignmentCollectionRequest getGroupAssignments() {
        return new MobileAppProvisioningConfigGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"), Optional.ofNullable(groupAssignments));
    }

    /**
     * <i>“The list of user installation states for this mobile app configuration.”</i>
     * 
     * @return navigational property userStatuses
     */
    @NavigationProperty(name="userStatuses")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest getUserStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.ofNullable(userStatuses));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The associated group assignments for IosLobAppProvisioningConfiguration.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public IosLobAppProvisioningConfiguration withAssignments(List<IosLobAppProvisioningConfigurationAssignment> assignments) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of device installation states for this mobile app configuration.”</i>
     * 
     * @param deviceStatuses
     *            new value of {@code deviceStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStatuses} field changed
     */
    public IosLobAppProvisioningConfiguration withDeviceStatuses(List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.deviceStatuses = deviceStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupAssignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The associated group assignments.”</i>
     * 
     * @param groupAssignments
     *            new value of {@code groupAssignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupAssignments} field changed
     */
    public IosLobAppProvisioningConfiguration withGroupAssignments(List<MobileAppProvisioningConfigGroupAssignment> groupAssignments) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("groupAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.groupAssignments = groupAssignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of user installation states for this mobile app configuration.”</i>
     * 
     * @param userStatuses
     *            new value of {@code userStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStatuses} field changed
     */
    public IosLobAppProvisioningConfiguration withUserStatuses(List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses) {
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppProvisioningConfiguration");
        _x.userStatuses = userStatuses;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosLobAppProvisioningConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosLobAppProvisioningConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosLobAppProvisioningConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosLobAppProvisioningConfiguration _copy() {
        IosLobAppProvisioningConfiguration _x = new IosLobAppProvisioningConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.expirationDateTime = expirationDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.payload = payload;
        _x.payloadFileName = payloadFileName;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<MobileAppProvisioningConfigGroupAssignment> appProvisioningConfigurationGroupAssignments, List<IosLobAppProvisioningConfigurationAssignment> iOSLobAppProvisioningConfigAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("appProvisioningConfigurationGroupAssignments", "Collection(microsoft.graph.mobileAppProvisioningConfigGroupAssignment)", appProvisioningConfigurationGroupAssignments)
            .put("iOSLobAppProvisioningConfigAssignments", "Collection(microsoft.graph.iosLobAppProvisioningConfigurationAssignment)", iOSLobAppProvisioningConfigAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosLobAppProvisioningConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("payload=");
        b.append(this.payload);
        b.append(", ");
        b.append("payloadFileName=");
        b.append(this.payloadFileName);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
