package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ParentLabelDetails;


/**
 * <p>
 * <b>Org.OData.Core.V1.Revisions</b>
 */@JsonPropertyOrder({
    "@odata.type", 
    "color", 
    "description", 
    "isActive", 
    "name", 
    "parent", 
    "sensitivity", 
    "tooltip"})
@JsonInclude(Include.NON_NULL)
public class InformationProtectionLabel extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.informationProtectionLabel";
    }

    @JsonProperty("color")
    protected String color;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("parent")
    protected ParentLabelDetails parent;

    @JsonProperty("sensitivity")
    protected Integer sensitivity;

    @JsonProperty("tooltip")
    protected String tooltip;

    protected InformationProtectionLabel() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInformationProtectionLabel() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String color;
        private String description;
        private Boolean isActive;
        private String name;
        private ParentLabelDetails parent;
        private Integer sensitivity;
        private String tooltip;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parent(ParentLabelDetails parent) {
            this.parent = parent;
            this.changedFields = changedFields.add("parent");
            return this;
        }

        public Builder sensitivity(Integer sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder tooltip(String tooltip) {
            this.tooltip = tooltip;
            this.changedFields = changedFields.add("tooltip");
            return this;
        }

        public InformationProtectionLabel build() {
            InformationProtectionLabel _x = new InformationProtectionLabel();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.informationProtectionLabel";
            _x.id = id;
            _x.color = color;
            _x.description = description;
            _x.isActive = isActive;
            _x.name = name;
            _x.parent = parent;
            _x.sensitivity = sensitivity;
            _x.tooltip = tooltip;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public InformationProtectionLabel withColor(String color) {
        InformationProtectionLabel _x = _copy();
        _x.changedFields = changedFields.add("color");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionLabel");
        _x.color = color;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public InformationProtectionLabel withDescription(String description) {
        InformationProtectionLabel _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionLabel");
        _x.description = description;
        return _x;
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public InformationProtectionLabel withIsActive(Boolean isActive) {
        InformationProtectionLabel _x = _copy();
        _x.changedFields = changedFields.add("isActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionLabel");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public InformationProtectionLabel withName(String name) {
        InformationProtectionLabel _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionLabel");
        _x.name = name;
        return _x;
    }

    @Property(name="parent")
    @JsonIgnore
    public Optional<ParentLabelDetails> getParent() {
        return Optional.ofNullable(parent);
    }

    public InformationProtectionLabel withParent(ParentLabelDetails parent) {
        InformationProtectionLabel _x = _copy();
        _x.changedFields = changedFields.add("parent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionLabel");
        _x.parent = parent;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Integer> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public InformationProtectionLabel withSensitivity(Integer sensitivity) {
        InformationProtectionLabel _x = _copy();
        _x.changedFields = changedFields.add("sensitivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionLabel");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="tooltip")
    @JsonIgnore
    public Optional<String> getTooltip() {
        return Optional.ofNullable(tooltip);
    }

    public InformationProtectionLabel withTooltip(String tooltip) {
        InformationProtectionLabel _x = _copy();
        _x.changedFields = changedFields.add("tooltip");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionLabel");
        _x.tooltip = tooltip;
        return _x;
    }

    public InformationProtectionLabel withUnmappedField(String name, Object value) {
        InformationProtectionLabel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InformationProtectionLabel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InformationProtectionLabel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InformationProtectionLabel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InformationProtectionLabel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InformationProtectionLabel _copy() {
        InformationProtectionLabel _x = new InformationProtectionLabel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.color = color;
        _x.description = description;
        _x.isActive = isActive;
        _x.name = name;
        _x.parent = parent;
        _x.sensitivity = sensitivity;
        _x.tooltip = tooltip;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InformationProtectionLabel[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parent=");
        b.append(this.parent);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("tooltip=");
        b.append(this.tooltip);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
