package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.BufferDecryptionResult;
import odata.msgraph.client.beta.complex.BufferEncryptionResult;
import odata.msgraph.client.beta.complex.SigningResult;
import odata.msgraph.client.beta.complex.VerificationResult;
import odata.msgraph.client.beta.entity.collection.request.DataLossPreventionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ThreatAssessmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.request.BitlockerRequest;
import odata.msgraph.client.beta.entity.request.InformationProtectionPolicyRequest;
import odata.msgraph.client.beta.entity.request.SensitivityPolicySettingsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "bitlocker", 
    "dataLossPreventionPolicies", 
    "sensitivityLabels", 
    "sensitivityPolicySettings", 
    "policy", 
    "threatAssessmentRequests"})
@JsonInclude(Include.NON_NULL)
public class InformationProtection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.informationProtection";
    }

    @JsonProperty("bitlocker")
    protected Bitlocker bitlocker;

    @JsonProperty("dataLossPreventionPolicies")
    protected List<DataLossPreventionPolicy> dataLossPreventionPolicies;

    @JsonProperty("sensitivityLabels")
    protected List<SensitivityLabel> sensitivityLabels;

    @JsonProperty("sensitivityPolicySettings")
    protected SensitivityPolicySettings sensitivityPolicySettings;

    @JsonProperty("policy")
    protected InformationProtectionPolicy policy;

    @JsonProperty("threatAssessmentRequests")
    protected List<ThreatAssessmentRequest> threatAssessmentRequests;

    protected InformationProtection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInformationProtection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Bitlocker bitlocker;
        private List<DataLossPreventionPolicy> dataLossPreventionPolicies;
        private List<SensitivityLabel> sensitivityLabels;
        private SensitivityPolicySettings sensitivityPolicySettings;
        private InformationProtectionPolicy policy;
        private List<ThreatAssessmentRequest> threatAssessmentRequests;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder bitlocker(Bitlocker bitlocker) {
            this.bitlocker = bitlocker;
            this.changedFields = changedFields.add("bitlocker");
            return this;
        }

        public Builder dataLossPreventionPolicies(List<DataLossPreventionPolicy> dataLossPreventionPolicies) {
            this.dataLossPreventionPolicies = dataLossPreventionPolicies;
            this.changedFields = changedFields.add("dataLossPreventionPolicies");
            return this;
        }

        public Builder dataLossPreventionPolicies(DataLossPreventionPolicy... dataLossPreventionPolicies) {
            return dataLossPreventionPolicies(Arrays.asList(dataLossPreventionPolicies));
        }

        public Builder sensitivityLabels(List<SensitivityLabel> sensitivityLabels) {
            this.sensitivityLabels = sensitivityLabels;
            this.changedFields = changedFields.add("sensitivityLabels");
            return this;
        }

        public Builder sensitivityLabels(SensitivityLabel... sensitivityLabels) {
            return sensitivityLabels(Arrays.asList(sensitivityLabels));
        }

        public Builder sensitivityPolicySettings(SensitivityPolicySettings sensitivityPolicySettings) {
            this.sensitivityPolicySettings = sensitivityPolicySettings;
            this.changedFields = changedFields.add("sensitivityPolicySettings");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param policy
         *            value of {@code policy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policy(InformationProtectionPolicy policy) {
            this.policy = policy;
            this.changedFields = changedFields.add("policy");
            return this;
        }

        public Builder threatAssessmentRequests(List<ThreatAssessmentRequest> threatAssessmentRequests) {
            this.threatAssessmentRequests = threatAssessmentRequests;
            this.changedFields = changedFields.add("threatAssessmentRequests");
            return this;
        }

        public Builder threatAssessmentRequests(ThreatAssessmentRequest... threatAssessmentRequests) {
            return threatAssessmentRequests(Arrays.asList(threatAssessmentRequests));
        }

        public InformationProtection build() {
            InformationProtection _x = new InformationProtection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.informationProtection";
            _x.id = id;
            _x.bitlocker = bitlocker;
            _x.dataLossPreventionPolicies = dataLossPreventionPolicies;
            _x.sensitivityLabels = sensitivityLabels;
            _x.sensitivityPolicySettings = sensitivityPolicySettings;
            _x.policy = policy;
            _x.threatAssessmentRequests = threatAssessmentRequests;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public InformationProtection withUnmappedField(String name, Object value) {
        InformationProtection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="bitlocker")
    @JsonIgnore
    public BitlockerRequest getBitlocker() {
        return new BitlockerRequest(contextPath.addSegment("bitlocker"), Optional.ofNullable(bitlocker));
    }

    @NavigationProperty(name="dataLossPreventionPolicies")
    @JsonIgnore
    public DataLossPreventionPolicyCollectionRequest getDataLossPreventionPolicies() {
        return new DataLossPreventionPolicyCollectionRequest(
                        contextPath.addSegment("dataLossPreventionPolicies"), Optional.ofNullable(dataLossPreventionPolicies));
    }

    @NavigationProperty(name="sensitivityLabels")
    @JsonIgnore
    public SensitivityLabelCollectionRequest getSensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"), Optional.ofNullable(sensitivityLabels));
    }

    @NavigationProperty(name="sensitivityPolicySettings")
    @JsonIgnore
    public SensitivityPolicySettingsRequest getSensitivityPolicySettings() {
        return new SensitivityPolicySettingsRequest(contextPath.addSegment("sensitivityPolicySettings"), Optional.ofNullable(sensitivityPolicySettings));
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return navigational property policy
     */
    @NavigationProperty(name="policy")
    @JsonIgnore
    public InformationProtectionPolicyRequest getPolicy() {
        return new InformationProtectionPolicyRequest(contextPath.addSegment("policy"), Optional.ofNullable(policy));
    }

    @NavigationProperty(name="threatAssessmentRequests")
    @JsonIgnore
    public ThreatAssessmentRequestCollectionRequest getThreatAssessmentRequests() {
        return new ThreatAssessmentRequestCollectionRequest(
                        contextPath.addSegment("threatAssessmentRequests"), Optional.ofNullable(threatAssessmentRequests));
    }

    public InformationProtection withBitlocker(Bitlocker bitlocker) {
        InformationProtection _x = _copy();
        _x.changedFields = changedFields.add("bitlocker");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtection");
        _x.bitlocker = bitlocker;
        return _x;
    }

    public InformationProtection withDataLossPreventionPolicies(List<DataLossPreventionPolicy> dataLossPreventionPolicies) {
        InformationProtection _x = _copy();
        _x.changedFields = changedFields.add("dataLossPreventionPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtection");
        _x.dataLossPreventionPolicies = dataLossPreventionPolicies;
        return _x;
    }

    public InformationProtection withSensitivityLabels(List<SensitivityLabel> sensitivityLabels) {
        InformationProtection _x = _copy();
        _x.changedFields = changedFields.add("sensitivityLabels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtection");
        _x.sensitivityLabels = sensitivityLabels;
        return _x;
    }

    public InformationProtection withSensitivityPolicySettings(SensitivityPolicySettings sensitivityPolicySettings) {
        InformationProtection _x = _copy();
        _x.changedFields = changedFields.add("sensitivityPolicySettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtection");
        _x.sensitivityPolicySettings = sensitivityPolicySettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param policy
     *            new value of {@code policy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policy} field changed
     */
    public InformationProtection withPolicy(InformationProtectionPolicy policy) {
        InformationProtection _x = _copy();
        _x.changedFields = changedFields.add("policy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtection");
        _x.policy = policy;
        return _x;
    }

    public InformationProtection withThreatAssessmentRequests(List<ThreatAssessmentRequest> threatAssessmentRequests) {
        InformationProtection _x = _copy();
        _x.changedFields = changedFields.add("threatAssessmentRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtection");
        _x.threatAssessmentRequests = threatAssessmentRequests;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InformationProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InformationProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InformationProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InformationProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InformationProtection _copy() {
        InformationProtection _x = new InformationProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.bitlocker = bitlocker;
        _x.dataLossPreventionPolicies = dataLossPreventionPolicies;
        _x.sensitivityLabels = sensitivityLabels;
        _x.sensitivityPolicySettings = sensitivityPolicySettings;
        _x.policy = policy;
        _x.threatAssessmentRequests = threatAssessmentRequests;
        return _x;
    }

    @Action(name = "decryptBuffer")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BufferDecryptionResult> decryptBuffer(byte[] encryptedBuffer, byte[] publishingLicense) {
        Preconditions.checkNotNull(encryptedBuffer, "encryptedBuffer cannot be null");
        Preconditions.checkNotNull(publishingLicense, "publishingLicense cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("encryptedBuffer", "Edm.Binary", encryptedBuffer)
            .put("publishingLicense", "Edm.Binary", publishingLicense)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BufferDecryptionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decryptBuffer"), BufferDecryptionResult.class, _parameters);
    }

    @Action(name = "encryptBuffer")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BufferEncryptionResult> encryptBuffer(byte[] buffer, UUID labelId) {
        Preconditions.checkNotNull(buffer, "buffer cannot be null");
        Preconditions.checkNotNull(labelId, "labelId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("buffer", "Edm.Binary", buffer)
            .put("labelId", "Edm.Guid", labelId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BufferEncryptionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.encryptBuffer"), BufferEncryptionResult.class, _parameters);
    }

    @Action(name = "signDigest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SigningResult> signDigest(byte[] digest) {
        Preconditions.checkNotNull(digest, "digest cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("digest", "Edm.Binary", digest)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SigningResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.signDigest"), SigningResult.class, _parameters);
    }

    @Action(name = "verifySignature")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<VerificationResult> verifySignature(byte[] digest, byte[] signature, String signingKeyId) {
        Preconditions.checkNotNull(digest, "digest cannot be null");
        Preconditions.checkNotNull(signature, "signature cannot be null");
        Preconditions.checkNotNull(signingKeyId, "signingKeyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("digest", "Edm.Binary", digest)
            .put("signature", "Edm.Binary", signature)
            .put("signingKeyId", "Edm.String", Checks.checkIsAscii(signingKeyId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<VerificationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verifySignature"), VerificationResult.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InformationProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("bitlocker=");
        b.append(this.bitlocker);
        b.append(", ");
        b.append("dataLossPreventionPolicies=");
        b.append(this.dataLossPreventionPolicies);
        b.append(", ");
        b.append("sensitivityLabels=");
        b.append(this.sensitivityLabels);
        b.append(", ");
        b.append("sensitivityPolicySettings=");
        b.append(this.sensitivityPolicySettings);
        b.append(", ");
        b.append("policy=");
        b.append(this.policy);
        b.append(", ");
        b.append("threatAssessmentRequests=");
        b.append(this.threatAssessmentRequests);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
