package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.InferenceClassificationOverrideCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overrides"})
@JsonInclude(Include.NON_NULL)
public class InferenceClassification extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.inferenceClassification";
    }

    @JsonProperty("overrides")
    protected List<InferenceClassificationOverride> overrides;

    protected InferenceClassification() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInferenceClassification() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<InferenceClassificationOverride> overrides;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param overrides
         *            value of {@code overrides} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder overrides(List<InferenceClassificationOverride> overrides) {
            this.overrides = overrides;
            this.changedFields = changedFields.add("overrides");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param overrides
         *            value of {@code overrides} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder overrides(InferenceClassificationOverride... overrides) {
            return overrides(Arrays.asList(overrides));
        }

        public InferenceClassification build() {
            InferenceClassification _x = new InferenceClassification();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.inferenceClassification";
            _x.id = id;
            _x.overrides = overrides;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public InferenceClassification withUnmappedField(String name, Object value) {
        InferenceClassification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property overrides
     */
    @NavigationProperty(name="overrides")
    @JsonIgnore
    public InferenceClassificationOverrideCollectionRequest getOverrides() {
        return new InferenceClassificationOverrideCollectionRequest(
                        contextPath.addSegment("overrides"), Optional.ofNullable(overrides));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code overrides} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param overrides
     *            new value of {@code overrides} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code overrides} field changed
     */
    public InferenceClassification withOverrides(List<InferenceClassificationOverride> overrides) {
        InferenceClassification _x = _copy();
        _x.changedFields = changedFields.add("overrides");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inferenceClassification");
        _x.overrides = overrides;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InferenceClassification patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InferenceClassification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InferenceClassification put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InferenceClassification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InferenceClassification _copy() {
        InferenceClassification _x = new InferenceClassification();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.overrides = overrides;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InferenceClassification[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("overrides=");
        b.append(this.overrides);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
