package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EnrollmentState;
import odata.msgraph.client.beta.enums.ImportedDeviceIdentityType;
import odata.msgraph.client.beta.enums.Platform;


/**
 * <i>“The importedDeviceIdentity resource represents a unique hardware identity of a
 * device that has been pre-staged for pre-enrollment configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "enrollmentState", 
    "importedDeviceIdentifier", 
    "importedDeviceIdentityType", 
    "lastContactedDateTime", 
    "lastModifiedDateTime", 
    "platform"})
@JsonInclude(Include.NON_NULL)
public class ImportedDeviceIdentity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.importedDeviceIdentity";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("enrollmentState")
    protected EnrollmentState enrollmentState;

    @JsonProperty("importedDeviceIdentifier")
    protected String importedDeviceIdentifier;

    @JsonProperty("importedDeviceIdentityType")
    protected ImportedDeviceIdentityType importedDeviceIdentityType;

    @JsonProperty("lastContactedDateTime")
    protected OffsetDateTime lastContactedDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("platform")
    protected Platform platform;

    protected ImportedDeviceIdentity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportedDeviceIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private EnrollmentState enrollmentState;
        private String importedDeviceIdentifier;
        private ImportedDeviceIdentityType importedDeviceIdentityType;
        private OffsetDateTime lastContactedDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Platform platform;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Created Date Time of the device”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The description of the device”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The state of the device in Intune”</i>
         * 
         * @param enrollmentState
         *            value of {@code enrollmentState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentState(EnrollmentState enrollmentState) {
            this.enrollmentState = enrollmentState;
            this.changedFields = changedFields.add("enrollmentState");
            return this;
        }

        /**
         * <i>“Imported Device Identifier”</i>
         * 
         * @param importedDeviceIdentifier
         *            value of {@code importedDeviceIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder importedDeviceIdentifier(String importedDeviceIdentifier) {
            this.importedDeviceIdentifier = importedDeviceIdentifier;
            this.changedFields = changedFields.add("importedDeviceIdentifier");
            return this;
        }

        /**
         * <i>“Type of Imported Device Identity”</i>
         * 
         * @param importedDeviceIdentityType
         *            value of {@code importedDeviceIdentityType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder importedDeviceIdentityType(ImportedDeviceIdentityType importedDeviceIdentityType) {
            this.importedDeviceIdentityType = importedDeviceIdentityType;
            this.changedFields = changedFields.add("importedDeviceIdentityType");
            return this;
        }

        /**
         * <i>“Last Contacted Date Time of the device”</i>
         * 
         * @param lastContactedDateTime
         *            value of {@code lastContactedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastContactedDateTime(OffsetDateTime lastContactedDateTime) {
            this.lastContactedDateTime = lastContactedDateTime;
            this.changedFields = changedFields.add("lastContactedDateTime");
            return this;
        }

        /**
         * <i>“Last Modified DateTime of the description”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The platform of the Device.”</i>
         * 
         * @param platform
         *            value of {@code platform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platform(Platform platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public ImportedDeviceIdentity build() {
            ImportedDeviceIdentity _x = new ImportedDeviceIdentity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.importedDeviceIdentity";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.enrollmentState = enrollmentState;
            _x.importedDeviceIdentifier = importedDeviceIdentifier;
            _x.importedDeviceIdentityType = importedDeviceIdentityType;
            _x.lastContactedDateTime = lastContactedDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.platform = platform;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Created Date Time of the device”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Created Date Time of the device”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ImportedDeviceIdentity withCreatedDateTime(OffsetDateTime createdDateTime) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The description of the device”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the device”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ImportedDeviceIdentity withDescription(String description) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The state of the device in Intune”</i>
     * 
     * @return property enrollmentState
     */
    @Property(name="enrollmentState")
    @JsonIgnore
    public Optional<EnrollmentState> getEnrollmentState() {
        return Optional.ofNullable(enrollmentState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The state of the device in Intune”</i>
     * 
     * @param enrollmentState
     *            new value of {@code enrollmentState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentState} field changed
     */
    public ImportedDeviceIdentity withEnrollmentState(EnrollmentState enrollmentState) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("enrollmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.enrollmentState = enrollmentState;
        return _x;
    }

    /**
     * <i>“Imported Device Identifier”</i>
     * 
     * @return property importedDeviceIdentifier
     */
    @Property(name="importedDeviceIdentifier")
    @JsonIgnore
    public Optional<String> getImportedDeviceIdentifier() {
        return Optional.ofNullable(importedDeviceIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * importedDeviceIdentifier} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Imported Device Identifier”</i>
     * 
     * @param importedDeviceIdentifier
     *            new value of {@code importedDeviceIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code importedDeviceIdentifier} field changed
     */
    public ImportedDeviceIdentity withImportedDeviceIdentifier(String importedDeviceIdentifier) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("importedDeviceIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.importedDeviceIdentifier = importedDeviceIdentifier;
        return _x;
    }

    /**
     * <i>“Type of Imported Device Identity”</i>
     * 
     * @return property importedDeviceIdentityType
     */
    @Property(name="importedDeviceIdentityType")
    @JsonIgnore
    public Optional<ImportedDeviceIdentityType> getImportedDeviceIdentityType() {
        return Optional.ofNullable(importedDeviceIdentityType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * importedDeviceIdentityType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Type of Imported Device Identity”</i>
     * 
     * @param importedDeviceIdentityType
     *            new value of {@code importedDeviceIdentityType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code importedDeviceIdentityType} field changed
     */
    public ImportedDeviceIdentity withImportedDeviceIdentityType(ImportedDeviceIdentityType importedDeviceIdentityType) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("importedDeviceIdentityType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.importedDeviceIdentityType = importedDeviceIdentityType;
        return _x;
    }

    /**
     * <i>“Last Contacted Date Time of the device”</i>
     * 
     * @return property lastContactedDateTime
     */
    @Property(name="lastContactedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastContactedDateTime() {
        return Optional.ofNullable(lastContactedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastContactedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last Contacted Date Time of the device”</i>
     * 
     * @param lastContactedDateTime
     *            new value of {@code lastContactedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastContactedDateTime} field changed
     */
    public ImportedDeviceIdentity withLastContactedDateTime(OffsetDateTime lastContactedDateTime) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("lastContactedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.lastContactedDateTime = lastContactedDateTime;
        return _x;
    }

    /**
     * <i>“Last Modified DateTime of the description”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last Modified DateTime of the description”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ImportedDeviceIdentity withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The platform of the Device.”</i>
     * 
     * @return property platform
     */
    @Property(name="platform")
    @JsonIgnore
    public Optional<Platform> getPlatform() {
        return Optional.ofNullable(platform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platform} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The platform of the Device.”</i>
     * 
     * @param platform
     *            new value of {@code platform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platform} field changed
     */
    public ImportedDeviceIdentity withPlatform(Platform platform) {
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("platform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedDeviceIdentity");
        _x.platform = platform;
        return _x;
    }

    public ImportedDeviceIdentity withUnmappedField(String name, Object value) {
        ImportedDeviceIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedDeviceIdentity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedDeviceIdentity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ImportedDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ImportedDeviceIdentity _copy() {
        ImportedDeviceIdentity _x = new ImportedDeviceIdentity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.enrollmentState = enrollmentState;
        _x.importedDeviceIdentifier = importedDeviceIdentifier;
        _x.importedDeviceIdentityType = importedDeviceIdentityType;
        _x.lastContactedDateTime = lastContactedDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.platform = platform;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImportedDeviceIdentity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("enrollmentState=");
        b.append(this.enrollmentState);
        b.append(", ");
        b.append("importedDeviceIdentifier=");
        b.append(this.importedDeviceIdentifier);
        b.append(", ");
        b.append("importedDeviceIdentityType=");
        b.append(this.importedDeviceIdentityType);
        b.append(", ");
        b.append("lastContactedDateTime=");
        b.append(this.lastContactedDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
