package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DiscoverySource;
import odata.msgraph.client.beta.enums.EnrollmentState;
import odata.msgraph.client.beta.enums.Platform;


/**
 * <i>“The importedAppleDeviceIdentityResult resource represents the result of
 * attempting to import Apple devices identities.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class ImportedAppleDeviceIdentityResult extends ImportedAppleDeviceIdentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.importedAppleDeviceIdentityResult";
    }

    @JsonProperty("status")
    protected Boolean status;

    protected ImportedAppleDeviceIdentityResult() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportedAppleDeviceIdentityResult() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DiscoverySource discoverySource;
        private EnrollmentState enrollmentState;
        private Boolean isDeleted;
        private Boolean isSupervised;
        private OffsetDateTime lastContactedDateTime;
        private Platform platform;
        private OffsetDateTime requestedEnrollmentProfileAssignmentDateTime;
        private String requestedEnrollmentProfileId;
        private String serialNumber;
        private Boolean status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder discoverySource(DiscoverySource discoverySource) {
            this.discoverySource = discoverySource;
            this.changedFields = changedFields.add("discoverySource");
            return this;
        }

        public Builder enrollmentState(EnrollmentState enrollmentState) {
            this.enrollmentState = enrollmentState;
            this.changedFields = changedFields.add("enrollmentState");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder isSupervised(Boolean isSupervised) {
            this.isSupervised = isSupervised;
            this.changedFields = changedFields.add("isSupervised");
            return this;
        }

        public Builder lastContactedDateTime(OffsetDateTime lastContactedDateTime) {
            this.lastContactedDateTime = lastContactedDateTime;
            this.changedFields = changedFields.add("lastContactedDateTime");
            return this;
        }

        public Builder platform(Platform platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder requestedEnrollmentProfileAssignmentDateTime(OffsetDateTime requestedEnrollmentProfileAssignmentDateTime) {
            this.requestedEnrollmentProfileAssignmentDateTime = requestedEnrollmentProfileAssignmentDateTime;
            this.changedFields = changedFields.add("requestedEnrollmentProfileAssignmentDateTime");
            return this;
        }

        public Builder requestedEnrollmentProfileId(String requestedEnrollmentProfileId) {
            this.requestedEnrollmentProfileId = requestedEnrollmentProfileId;
            this.changedFields = changedFields.add("requestedEnrollmentProfileId");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“Status of imported device identity”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(Boolean status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public ImportedAppleDeviceIdentityResult build() {
            ImportedAppleDeviceIdentityResult _x = new ImportedAppleDeviceIdentityResult();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.importedAppleDeviceIdentityResult";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.discoverySource = discoverySource;
            _x.enrollmentState = enrollmentState;
            _x.isDeleted = isDeleted;
            _x.isSupervised = isSupervised;
            _x.lastContactedDateTime = lastContactedDateTime;
            _x.platform = platform;
            _x.requestedEnrollmentProfileAssignmentDateTime = requestedEnrollmentProfileAssignmentDateTime;
            _x.requestedEnrollmentProfileId = requestedEnrollmentProfileId;
            _x.serialNumber = serialNumber;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Status of imported device identity”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<Boolean> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Status of imported device identity”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public ImportedAppleDeviceIdentityResult withStatus(Boolean status) {
        ImportedAppleDeviceIdentityResult _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentityResult");
        _x.status = status;
        return _x;
    }

    public ImportedAppleDeviceIdentityResult withUnmappedField(String name, Object value) {
        ImportedAppleDeviceIdentityResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedAppleDeviceIdentityResult patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ImportedAppleDeviceIdentityResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedAppleDeviceIdentityResult put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ImportedAppleDeviceIdentityResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ImportedAppleDeviceIdentityResult _copy() {
        ImportedAppleDeviceIdentityResult _x = new ImportedAppleDeviceIdentityResult();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.discoverySource = discoverySource;
        _x.enrollmentState = enrollmentState;
        _x.isDeleted = isDeleted;
        _x.isSupervised = isSupervised;
        _x.lastContactedDateTime = lastContactedDateTime;
        _x.platform = platform;
        _x.requestedEnrollmentProfileAssignmentDateTime = requestedEnrollmentProfileAssignmentDateTime;
        _x.requestedEnrollmentProfileId = requestedEnrollmentProfileId;
        _x.serialNumber = serialNumber;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImportedAppleDeviceIdentityResult[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("discoverySource=");
        b.append(this.discoverySource);
        b.append(", ");
        b.append("enrollmentState=");
        b.append(this.enrollmentState);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("isSupervised=");
        b.append(this.isSupervised);
        b.append(", ");
        b.append("lastContactedDateTime=");
        b.append(this.lastContactedDateTime);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("requestedEnrollmentProfileAssignmentDateTime=");
        b.append(this.requestedEnrollmentProfileAssignmentDateTime);
        b.append(", ");
        b.append("requestedEnrollmentProfileId=");
        b.append(this.requestedEnrollmentProfileId);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
