package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.RiskDetectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RiskyServicePrincipalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RiskyUserCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServicePrincipalRiskDetectionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "riskDetections", 
    "riskyServicePrincipals", 
    "riskyUsers", 
    "servicePrincipalRiskDetections"})
@JsonInclude(Include.NON_NULL)
public class IdentityProtectionRoot implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.identityProtectionRoot";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("riskDetections")
    protected List<RiskDetection> riskDetections;

    @JsonProperty("riskyServicePrincipals")
    protected List<RiskyServicePrincipal> riskyServicePrincipals;

    @JsonProperty("riskyUsers")
    protected List<RiskyUser> riskyUsers;

    @JsonProperty("servicePrincipalRiskDetections")
    protected List<ServicePrincipalRiskDetection> servicePrincipalRiskDetections;

    protected IdentityProtectionRoot() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<RiskDetection> riskDetections;
        private List<RiskyServicePrincipal> riskyServicePrincipals;
        private List<RiskyUser> riskyUsers;
        private List<ServicePrincipalRiskDetection> servicePrincipalRiskDetections;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder riskDetections(List<RiskDetection> riskDetections) {
            this.riskDetections = riskDetections;
            this.changedFields = changedFields.add("riskDetections");
            return this;
        }

        public Builder riskDetections(RiskDetection... riskDetections) {
            return riskDetections(Arrays.asList(riskDetections));
        }

        public Builder riskyServicePrincipals(List<RiskyServicePrincipal> riskyServicePrincipals) {
            this.riskyServicePrincipals = riskyServicePrincipals;
            this.changedFields = changedFields.add("riskyServicePrincipals");
            return this;
        }

        public Builder riskyServicePrincipals(RiskyServicePrincipal... riskyServicePrincipals) {
            return riskyServicePrincipals(Arrays.asList(riskyServicePrincipals));
        }

        public Builder riskyUsers(List<RiskyUser> riskyUsers) {
            this.riskyUsers = riskyUsers;
            this.changedFields = changedFields.add("riskyUsers");
            return this;
        }

        public Builder riskyUsers(RiskyUser... riskyUsers) {
            return riskyUsers(Arrays.asList(riskyUsers));
        }

        public Builder servicePrincipalRiskDetections(List<ServicePrincipalRiskDetection> servicePrincipalRiskDetections) {
            this.servicePrincipalRiskDetections = servicePrincipalRiskDetections;
            this.changedFields = changedFields.add("servicePrincipalRiskDetections");
            return this;
        }

        public Builder servicePrincipalRiskDetections(ServicePrincipalRiskDetection... servicePrincipalRiskDetections) {
            return servicePrincipalRiskDetections(Arrays.asList(servicePrincipalRiskDetections));
        }

        public IdentityProtectionRoot build() {
            IdentityProtectionRoot _x = new IdentityProtectionRoot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.identityProtectionRoot";
            _x.riskDetections = riskDetections;
            _x.riskyServicePrincipals = riskyServicePrincipals;
            _x.riskyUsers = riskyUsers;
            _x.servicePrincipalRiskDetections = servicePrincipalRiskDetections;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public IdentityProtectionRoot withUnmappedField(String name, Object value) {
        IdentityProtectionRoot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="riskDetections")
    @JsonIgnore
    public RiskDetectionCollectionRequest getRiskDetections() {
        return new RiskDetectionCollectionRequest(
                        contextPath.addSegment("riskDetections"), Optional.ofNullable(riskDetections));
    }

    @NavigationProperty(name="riskyServicePrincipals")
    @JsonIgnore
    public RiskyServicePrincipalCollectionRequest getRiskyServicePrincipals() {
        return new RiskyServicePrincipalCollectionRequest(
                        contextPath.addSegment("riskyServicePrincipals"), Optional.ofNullable(riskyServicePrincipals));
    }

    @NavigationProperty(name="riskyUsers")
    @JsonIgnore
    public RiskyUserCollectionRequest getRiskyUsers() {
        return new RiskyUserCollectionRequest(
                        contextPath.addSegment("riskyUsers"), Optional.ofNullable(riskyUsers));
    }

    @NavigationProperty(name="servicePrincipalRiskDetections")
    @JsonIgnore
    public ServicePrincipalRiskDetectionCollectionRequest getServicePrincipalRiskDetections() {
        return new ServicePrincipalRiskDetectionCollectionRequest(
                        contextPath.addSegment("servicePrincipalRiskDetections"), Optional.ofNullable(servicePrincipalRiskDetections));
    }

    public IdentityProtectionRoot withRiskDetections(List<RiskDetection> riskDetections) {
        IdentityProtectionRoot _x = _copy();
        _x.changedFields = changedFields.add("riskDetections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProtectionRoot");
        _x.riskDetections = riskDetections;
        return _x;
    }

    public IdentityProtectionRoot withRiskyServicePrincipals(List<RiskyServicePrincipal> riskyServicePrincipals) {
        IdentityProtectionRoot _x = _copy();
        _x.changedFields = changedFields.add("riskyServicePrincipals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProtectionRoot");
        _x.riskyServicePrincipals = riskyServicePrincipals;
        return _x;
    }

    public IdentityProtectionRoot withRiskyUsers(List<RiskyUser> riskyUsers) {
        IdentityProtectionRoot _x = _copy();
        _x.changedFields = changedFields.add("riskyUsers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProtectionRoot");
        _x.riskyUsers = riskyUsers;
        return _x;
    }

    public IdentityProtectionRoot withServicePrincipalRiskDetections(List<ServicePrincipalRiskDetection> servicePrincipalRiskDetections) {
        IdentityProtectionRoot _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalRiskDetections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProtectionRoot");
        _x.servicePrincipalRiskDetections = servicePrincipalRiskDetections;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityProtectionRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IdentityProtectionRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityProtectionRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IdentityProtectionRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IdentityProtectionRoot _copy() {
        IdentityProtectionRoot _x = new IdentityProtectionRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.riskDetections = riskDetections;
        _x.riskyServicePrincipals = riskyServicePrincipals;
        _x.riskyUsers = riskyUsers;
        _x.servicePrincipalRiskDetections = servicePrincipalRiskDetections;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IdentityProtectionRoot[");
        b.append("riskDetections=");
        b.append(this.riskDetections);
        b.append(", ");
        b.append("riskyServicePrincipals=");
        b.append(this.riskyServicePrincipals);
        b.append(", ");
        b.append("riskyUsers=");
        b.append(this.riskyUsers);
        b.append(", ");
        b.append("servicePrincipalRiskDetections=");
        b.append(this.servicePrincipalRiskDetections);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
