package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GroupPolicyUploadedLanguageFile;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyOperationCollectionRequest;
import odata.msgraph.client.beta.enums.GroupPolicyType;
import odata.msgraph.client.beta.enums.GroupPolicyUploadedDefinitionFileStatus;


/**
 * <i>“The entity represents an ADMX (Administrative Template) XML file uploaded by
 * Administrator. The ADMX file contains a collection of group policy definitions
 * and their locations by category path. The group policy definition file also
 * contains the languages supported as determined by the language dependent ADML (
 * Administrative Template) language files.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "defaultLanguageCode", 
    "groupPolicyUploadedLanguageFiles", 
    "status", 
    "uploadDateTime"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyUploadedDefinitionFile extends GroupPolicyDefinitionFile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyUploadedDefinitionFile";
    }

    @JsonProperty("content")
    protected byte[] content;

    @JsonProperty("defaultLanguageCode")
    protected String defaultLanguageCode;

    @JsonProperty("groupPolicyUploadedLanguageFiles")
    protected List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles;

    @JsonProperty("groupPolicyUploadedLanguageFiles@nextLink")
    protected String groupPolicyUploadedLanguageFilesNextLink;

    @JsonProperty("status")
    protected GroupPolicyUploadedDefinitionFileStatus status;

    @JsonProperty("uploadDateTime")
    protected OffsetDateTime uploadDateTime;

    protected GroupPolicyUploadedDefinitionFile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyUploadedDefinitionFile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private String fileName;
        private List<String> languageCodes;
        private String languageCodesNextLink;
        private OffsetDateTime lastModifiedDateTime;
        private GroupPolicyType policyType;
        private String revision;
        private String targetNamespace;
        private String targetPrefix;
        private byte[] content;
        private String defaultLanguageCode;
        private List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles;
        private String groupPolicyUploadedLanguageFilesNextLink;
        private GroupPolicyUploadedDefinitionFileStatus status;
        private OffsetDateTime uploadDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder languageCodes(List<String> languageCodes) {
            this.languageCodes = languageCodes;
            this.changedFields = changedFields.add("languageCodes");
            return this;
        }

        public Builder languageCodes(String... languageCodes) {
            return languageCodes(Arrays.asList(languageCodes));
        }

        public Builder languageCodesNextLink(String languageCodesNextLink) {
            this.languageCodesNextLink = languageCodesNextLink;
            this.changedFields = changedFields.add("languageCodes");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder policyType(GroupPolicyType policyType) {
            this.policyType = policyType;
            this.changedFields = changedFields.add("policyType");
            return this;
        }

        public Builder revision(String revision) {
            this.revision = revision;
            this.changedFields = changedFields.add("revision");
            return this;
        }

        public Builder targetNamespace(String targetNamespace) {
            this.targetNamespace = targetNamespace;
            this.changedFields = changedFields.add("targetNamespace");
            return this;
        }

        public Builder targetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
            this.changedFields = changedFields.add("targetPrefix");
            return this;
        }

        /**
         * <i>“The contents of the uploaded ADMX file.”</i>
         * 
         * @param content
         *            value of {@code content} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder content(byte[] content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        /**
         * <i>“The default language of the uploaded ADMX file.”</i>
         * 
         * @param defaultLanguageCode
         *            value of {@code defaultLanguageCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultLanguageCode(String defaultLanguageCode) {
            this.defaultLanguageCode = defaultLanguageCode;
            this.changedFields = changedFields.add("defaultLanguageCode");
            return this;
        }

        /**
         * <i>“The list of ADML files associated with the uploaded ADMX file.”</i>
         * 
         * @param groupPolicyUploadedLanguageFiles
         *            value of {@code groupPolicyUploadedLanguageFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyUploadedLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
            this.groupPolicyUploadedLanguageFiles = groupPolicyUploadedLanguageFiles;
            this.changedFields = changedFields.add("groupPolicyUploadedLanguageFiles");
            return this;
        }

        /**
         * <i>“The list of ADML files associated with the uploaded ADMX file.”</i>
         * 
         * @param groupPolicyUploadedLanguageFiles
         *            value of {@code groupPolicyUploadedLanguageFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyUploadedLanguageFiles(GroupPolicyUploadedLanguageFile... groupPolicyUploadedLanguageFiles) {
            return groupPolicyUploadedLanguageFiles(Arrays.asList(groupPolicyUploadedLanguageFiles));
        }

        /**
         * <i>“The list of ADML files associated with the uploaded ADMX file.”</i>
         * 
         * @param groupPolicyUploadedLanguageFilesNextLink
         *            value of {@code groupPolicyUploadedLanguageFiles@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyUploadedLanguageFilesNextLink(String groupPolicyUploadedLanguageFilesNextLink) {
            this.groupPolicyUploadedLanguageFilesNextLink = groupPolicyUploadedLanguageFilesNextLink;
            this.changedFields = changedFields.add("groupPolicyUploadedLanguageFiles");
            return this;
        }

        /**
         * <i>“The upload status of the uploaded ADMX file.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(GroupPolicyUploadedDefinitionFileStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“The uploaded time of the uploaded ADMX file.”</i>
         * 
         * @param uploadDateTime
         *            value of {@code uploadDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uploadDateTime(OffsetDateTime uploadDateTime) {
            this.uploadDateTime = uploadDateTime;
            this.changedFields = changedFields.add("uploadDateTime");
            return this;
        }

        public GroupPolicyUploadedDefinitionFile build() {
            GroupPolicyUploadedDefinitionFile _x = new GroupPolicyUploadedDefinitionFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyUploadedDefinitionFile";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.fileName = fileName;
            _x.languageCodes = languageCodes;
            _x.languageCodesNextLink = languageCodesNextLink;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.policyType = policyType;
            _x.revision = revision;
            _x.targetNamespace = targetNamespace;
            _x.targetPrefix = targetPrefix;
            _x.content = content;
            _x.defaultLanguageCode = defaultLanguageCode;
            _x.groupPolicyUploadedLanguageFiles = groupPolicyUploadedLanguageFiles;
            _x.groupPolicyUploadedLanguageFilesNextLink = groupPolicyUploadedLanguageFilesNextLink;
            _x.status = status;
            _x.uploadDateTime = uploadDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The contents of the uploaded ADMX file.”</i>
     * 
     * @return property content
     */
    @Property(name="content")
    @JsonIgnore
    public Optional<byte[]> getContent() {
        return Optional.ofNullable(content);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code content} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The contents of the uploaded ADMX file.”</i>
     * 
     * @param content
     *            new value of {@code content} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code content} field changed
     */
    public GroupPolicyUploadedDefinitionFile withContent(byte[] content) {
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedDefinitionFile");
        _x.content = content;
        return _x;
    }

    /**
     * <i>“The default language of the uploaded ADMX file.”</i>
     * 
     * @return property defaultLanguageCode
     */
    @Property(name="defaultLanguageCode")
    @JsonIgnore
    public Optional<String> getDefaultLanguageCode() {
        return Optional.ofNullable(defaultLanguageCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultLanguageCode} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The default language of the uploaded ADMX file.”</i>
     * 
     * @param defaultLanguageCode
     *            new value of {@code defaultLanguageCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultLanguageCode} field changed
     */
    public GroupPolicyUploadedDefinitionFile withDefaultLanguageCode(String defaultLanguageCode) {
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("defaultLanguageCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedDefinitionFile");
        _x.defaultLanguageCode = defaultLanguageCode;
        return _x;
    }

    /**
     * <i>“The list of ADML files associated with the uploaded ADMX file.”</i>
     * 
     * @return property groupPolicyUploadedLanguageFiles
     */
    @Property(name="groupPolicyUploadedLanguageFiles")
    @JsonIgnore
    public CollectionPage<GroupPolicyUploadedLanguageFile> getGroupPolicyUploadedLanguageFiles() {
        return new CollectionPage<GroupPolicyUploadedLanguageFile>(contextPath, GroupPolicyUploadedLanguageFile.class, this.groupPolicyUploadedLanguageFiles, Optional.ofNullable(groupPolicyUploadedLanguageFilesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyUploadedLanguageFiles} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The list of ADML files associated with the uploaded ADMX file.”</i>
     * 
     * @param groupPolicyUploadedLanguageFiles
     *            new value of {@code groupPolicyUploadedLanguageFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyUploadedLanguageFiles} field changed
     */
    public GroupPolicyUploadedDefinitionFile withGroupPolicyUploadedLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyUploadedLanguageFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedDefinitionFile");
        _x.groupPolicyUploadedLanguageFiles = groupPolicyUploadedLanguageFiles;
        return _x;
    }

    /**
     * <i>“The list of ADML files associated with the uploaded ADMX file.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property groupPolicyUploadedLanguageFiles
     */
    @Property(name="groupPolicyUploadedLanguageFiles")
    @JsonIgnore
    public CollectionPage<GroupPolicyUploadedLanguageFile> getGroupPolicyUploadedLanguageFiles(HttpRequestOptions options) {
        return new CollectionPage<GroupPolicyUploadedLanguageFile>(contextPath, GroupPolicyUploadedLanguageFile.class, this.groupPolicyUploadedLanguageFiles, Optional.ofNullable(groupPolicyUploadedLanguageFilesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The upload status of the uploaded ADMX file.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<GroupPolicyUploadedDefinitionFileStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The upload status of the uploaded ADMX file.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public GroupPolicyUploadedDefinitionFile withStatus(GroupPolicyUploadedDefinitionFileStatus status) {
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedDefinitionFile");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“The uploaded time of the uploaded ADMX file.”</i>
     * 
     * @return property uploadDateTime
     */
    @Property(name="uploadDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUploadDateTime() {
        return Optional.ofNullable(uploadDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code uploadDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The uploaded time of the uploaded ADMX file.”</i>
     * 
     * @param uploadDateTime
     *            new value of {@code uploadDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uploadDateTime} field changed
     */
    public GroupPolicyUploadedDefinitionFile withUploadDateTime(OffsetDateTime uploadDateTime) {
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("uploadDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedDefinitionFile");
        _x.uploadDateTime = uploadDateTime;
        return _x;
    }

    public GroupPolicyUploadedDefinitionFile withUnmappedField(String name, Object value) {
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of operations on the uploaded ADMX file.”</i>
     * 
     * @return navigational property groupPolicyOperations
     */
    @NavigationProperty(name="groupPolicyOperations")
    @JsonIgnore
    public GroupPolicyOperationCollectionRequest getGroupPolicyOperations() {
        return new GroupPolicyOperationCollectionRequest(
                        contextPath.addSegment("groupPolicyOperations"), RequestHelper.getValue(unmappedFields, "groupPolicyOperations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyUploadedDefinitionFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyUploadedDefinitionFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyUploadedDefinitionFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyUploadedDefinitionFile _copy() {
        GroupPolicyUploadedDefinitionFile _x = new GroupPolicyUploadedDefinitionFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.fileName = fileName;
        _x.languageCodes = languageCodes;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.policyType = policyType;
        _x.revision = revision;
        _x.targetNamespace = targetNamespace;
        _x.targetPrefix = targetPrefix;
        _x.content = content;
        _x.defaultLanguageCode = defaultLanguageCode;
        _x.groupPolicyUploadedLanguageFiles = groupPolicyUploadedLanguageFiles;
        _x.status = status;
        _x.uploadDateTime = uploadDateTime;
        return _x;
    }

    @Action(name = "remove")
    @JsonIgnore
    public ActionRequestNoReturn remove() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.remove"), _parameters);
    }

    @Action(name = "addLanguageFiles")
    @JsonIgnore
    public ActionRequestNoReturn addLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addLanguageFiles"), _parameters);
    }

    @Action(name = "removeLanguageFiles")
    @JsonIgnore
    public ActionRequestNoReturn removeLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeLanguageFiles"), _parameters);
    }

    @Action(name = "updateLanguageFiles")
    @JsonIgnore
    public ActionRequestNoReturn updateLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateLanguageFiles"), _parameters);
    }

    @Action(name = "uploadNewVersion")
    @JsonIgnore
    public ActionRequestNoReturn uploadNewVersion(byte[] content, List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Preconditions.checkNotNull(content, "content cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("content", "Edm.Binary", content)
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadNewVersion"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyUploadedDefinitionFile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("languageCodes=");
        b.append(this.languageCodes);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("policyType=");
        b.append(this.policyType);
        b.append(", ");
        b.append("revision=");
        b.append(this.revision);
        b.append(", ");
        b.append("targetNamespace=");
        b.append(this.targetNamespace);
        b.append(", ");
        b.append("targetPrefix=");
        b.append(this.targetPrefix);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("defaultLanguageCode=");
        b.append(this.defaultLanguageCode);
        b.append(", ");
        b.append("groupPolicyUploadedLanguageFiles=");
        b.append(this.groupPolicyUploadedLanguageFiles);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("uploadDateTime=");
        b.append(this.uploadDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
