package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.GroupPolicySettingScope;
import odata.msgraph.client.beta.enums.GroupPolicySettingType;
import odata.msgraph.client.beta.enums.MdmSupportedState;


/**
 * <i>“The Group Policy setting to MDM/Intune mapping.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "admxSettingDefinitionId", 
    "childIdList", 
    "intuneSettingDefinitionId", 
    "intuneSettingUriList", 
    "isMdmSupported", 
    "mdmCspName", 
    "mdmMinimumOSVersion", 
    "mdmSettingUri", 
    "mdmSupportedState", 
    "parentId", 
    "settingCategory", 
    "settingDisplayName", 
    "settingDisplayValue", 
    "settingDisplayValueType", 
    "settingName", 
    "settingScope", 
    "settingType", 
    "settingValue", 
    "settingValueDisplayUnits", 
    "settingValueType"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicySettingMapping extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicySettingMapping";
    }

    @JsonProperty("admxSettingDefinitionId")
    protected String admxSettingDefinitionId;

    @JsonProperty("childIdList")
    protected List<String> childIdList;

    @JsonProperty("childIdList@nextLink")
    protected String childIdListNextLink;

    @JsonProperty("intuneSettingDefinitionId")
    protected String intuneSettingDefinitionId;

    @JsonProperty("intuneSettingUriList")
    protected List<String> intuneSettingUriList;

    @JsonProperty("intuneSettingUriList@nextLink")
    protected String intuneSettingUriListNextLink;

    @JsonProperty("isMdmSupported")
    protected Boolean isMdmSupported;

    @JsonProperty("mdmCspName")
    protected String mdmCspName;

    @JsonProperty("mdmMinimumOSVersion")
    protected Integer mdmMinimumOSVersion;

    @JsonProperty("mdmSettingUri")
    protected String mdmSettingUri;

    @JsonProperty("mdmSupportedState")
    protected MdmSupportedState mdmSupportedState;

    @JsonProperty("parentId")
    protected String parentId;

    @JsonProperty("settingCategory")
    protected String settingCategory;

    @JsonProperty("settingDisplayName")
    protected String settingDisplayName;

    @JsonProperty("settingDisplayValue")
    protected String settingDisplayValue;

    @JsonProperty("settingDisplayValueType")
    protected String settingDisplayValueType;

    @JsonProperty("settingName")
    protected String settingName;

    @JsonProperty("settingScope")
    protected GroupPolicySettingScope settingScope;

    @JsonProperty("settingType")
    protected GroupPolicySettingType settingType;

    @JsonProperty("settingValue")
    protected String settingValue;

    @JsonProperty("settingValueDisplayUnits")
    protected String settingValueDisplayUnits;

    @JsonProperty("settingValueType")
    protected String settingValueType;

    protected GroupPolicySettingMapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicySettingMapping() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String admxSettingDefinitionId;
        private List<String> childIdList;
        private String childIdListNextLink;
        private String intuneSettingDefinitionId;
        private List<String> intuneSettingUriList;
        private String intuneSettingUriListNextLink;
        private Boolean isMdmSupported;
        private String mdmCspName;
        private Integer mdmMinimumOSVersion;
        private String mdmSettingUri;
        private MdmSupportedState mdmSupportedState;
        private String parentId;
        private String settingCategory;
        private String settingDisplayName;
        private String settingDisplayValue;
        private String settingDisplayValueType;
        private String settingName;
        private GroupPolicySettingScope settingScope;
        private GroupPolicySettingType settingType;
        private String settingValue;
        private String settingValueDisplayUnits;
        private String settingValueType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Admx Group Policy Id”</i>
         * 
         * @param admxSettingDefinitionId
         *            value of {@code admxSettingDefinitionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder admxSettingDefinitionId(String admxSettingDefinitionId) {
            this.admxSettingDefinitionId = admxSettingDefinitionId;
            this.changedFields = changedFields.add("admxSettingDefinitionId");
            return this;
        }

        /**
         * <i>“List of Child Ids of the group policy setting.”</i>
         * 
         * @param childIdList
         *            value of {@code childIdList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childIdList(List<String> childIdList) {
            this.childIdList = childIdList;
            this.changedFields = changedFields.add("childIdList");
            return this;
        }

        /**
         * <i>“List of Child Ids of the group policy setting.”</i>
         * 
         * @param childIdList
         *            value of {@code childIdList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childIdList(String... childIdList) {
            return childIdList(Arrays.asList(childIdList));
        }

        /**
         * <i>“List of Child Ids of the group policy setting.”</i>
         * 
         * @param childIdListNextLink
         *            value of {@code childIdList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childIdListNextLink(String childIdListNextLink) {
            this.childIdListNextLink = childIdListNextLink;
            this.changedFields = changedFields.add("childIdList");
            return this;
        }

        /**
         * <i>“The Intune Setting Definition Id”</i>
         * 
         * @param intuneSettingDefinitionId
         *            value of {@code intuneSettingDefinitionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneSettingDefinitionId(String intuneSettingDefinitionId) {
            this.intuneSettingDefinitionId = intuneSettingDefinitionId;
            this.changedFields = changedFields.add("intuneSettingDefinitionId");
            return this;
        }

        /**
         * <i>“The list of Intune Setting URIs this group policy setting maps to”</i>
         * 
         * @param intuneSettingUriList
         *            value of {@code intuneSettingUriList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneSettingUriList(List<String> intuneSettingUriList) {
            this.intuneSettingUriList = intuneSettingUriList;
            this.changedFields = changedFields.add("intuneSettingUriList");
            return this;
        }

        /**
         * <i>“The list of Intune Setting URIs this group policy setting maps to”</i>
         * 
         * @param intuneSettingUriList
         *            value of {@code intuneSettingUriList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneSettingUriList(String... intuneSettingUriList) {
            return intuneSettingUriList(Arrays.asList(intuneSettingUriList));
        }

        /**
         * <i>“The list of Intune Setting URIs this group policy setting maps to”</i>
         * 
         * @param intuneSettingUriListNextLink
         *            value of {@code intuneSettingUriList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneSettingUriListNextLink(String intuneSettingUriListNextLink) {
            this.intuneSettingUriListNextLink = intuneSettingUriListNextLink;
            this.changedFields = changedFields.add("intuneSettingUriList");
            return this;
        }

        /**
         * <i>“Indicates if the setting is supported by Intune or not”</i>
         * 
         * @param isMdmSupported
         *            value of {@code isMdmSupported} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isMdmSupported(Boolean isMdmSupported) {
            this.isMdmSupported = isMdmSupported;
            this.changedFields = changedFields.add("isMdmSupported");
            return this;
        }

        /**
         * <i>“The CSP name this group policy setting maps to.”</i>
         * 
         * @param mdmCspName
         *            value of {@code mdmCspName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmCspName(String mdmCspName) {
            this.mdmCspName = mdmCspName;
            this.changedFields = changedFields.add("mdmCspName");
            return this;
        }

        /**
         * <i>“The minimum OS version this mdm setting supports.”</i>
         * 
         * @param mdmMinimumOSVersion
         *            value of {@code mdmMinimumOSVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmMinimumOSVersion(Integer mdmMinimumOSVersion) {
            this.mdmMinimumOSVersion = mdmMinimumOSVersion;
            this.changedFields = changedFields.add("mdmMinimumOSVersion");
            return this;
        }

        /**
         * <i>“The MDM CSP URI this group policy setting maps to.”</i>
         * 
         * @param mdmSettingUri
         *            value of {@code mdmSettingUri} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmSettingUri(String mdmSettingUri) {
            this.mdmSettingUri = mdmSettingUri;
            this.changedFields = changedFields.add("mdmSettingUri");
            return this;
        }

        /**
         * <i>“Indicates if the setting is supported in Mdm or not”</i>
         * 
         * @param mdmSupportedState
         *            value of {@code mdmSupportedState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmSupportedState(MdmSupportedState mdmSupportedState) {
            this.mdmSupportedState = mdmSupportedState;
            this.changedFields = changedFields.add("mdmSupportedState");
            return this;
        }

        /**
         * <i>“Parent Id of the group policy setting.”</i>
         * 
         * @param parentId
         *            value of {@code parentId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.changedFields = changedFields.add("parentId");
            return this;
        }

        /**
         * <i>“The category the group policy setting is in.”</i>
         * 
         * @param settingCategory
         *            value of {@code settingCategory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingCategory(String settingCategory) {
            this.settingCategory = settingCategory;
            this.changedFields = changedFields.add("settingCategory");
            return this;
        }

        /**
         * <i>“The display name of this group policy setting.”</i>
         * 
         * @param settingDisplayName
         *            value of {@code settingDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDisplayName(String settingDisplayName) {
            this.settingDisplayName = settingDisplayName;
            this.changedFields = changedFields.add("settingDisplayName");
            return this;
        }

        /**
         * <i>“The display value of this group policy setting.”</i>
         * 
         * @param settingDisplayValue
         *            value of {@code settingDisplayValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDisplayValue(String settingDisplayValue) {
            this.settingDisplayValue = settingDisplayValue;
            this.changedFields = changedFields.add("settingDisplayValue");
            return this;
        }

        /**
         * <i>“The display value type of this group policy setting.”</i>
         * 
         * @param settingDisplayValueType
         *            value of {@code settingDisplayValueType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDisplayValueType(String settingDisplayValueType) {
            this.settingDisplayValueType = settingDisplayValueType;
            this.changedFields = changedFields.add("settingDisplayValueType");
            return this;
        }

        /**
         * <i>“The name of this group policy setting.”</i>
         * 
         * @param settingName
         *            value of {@code settingName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        /**
         * <i>“The scope of the setting”</i>
         * 
         * @param settingScope
         *            value of {@code settingScope} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingScope(GroupPolicySettingScope settingScope) {
            this.settingScope = settingScope;
            this.changedFields = changedFields.add("settingScope");
            return this;
        }

        /**
         * <i>“The setting type (security or admx) of the Group Policy.”</i>
         * 
         * @param settingType
         *            value of {@code settingType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingType(GroupPolicySettingType settingType) {
            this.settingType = settingType;
            this.changedFields = changedFields.add("settingType");
            return this;
        }

        /**
         * <i>“The value of this group policy setting.”</i>
         * 
         * @param settingValue
         *            value of {@code settingValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingValue(String settingValue) {
            this.settingValue = settingValue;
            this.changedFields = changedFields.add("settingValue");
            return this;
        }

        /**
         * <i>“The display units of this group policy setting value”</i>
         * 
         * @param settingValueDisplayUnits
         *            value of {@code settingValueDisplayUnits} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingValueDisplayUnits(String settingValueDisplayUnits) {
            this.settingValueDisplayUnits = settingValueDisplayUnits;
            this.changedFields = changedFields.add("settingValueDisplayUnits");
            return this;
        }

        /**
         * <i>“The value type of this group policy setting.”</i>
         * 
         * @param settingValueType
         *            value of {@code settingValueType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingValueType(String settingValueType) {
            this.settingValueType = settingValueType;
            this.changedFields = changedFields.add("settingValueType");
            return this;
        }

        public GroupPolicySettingMapping build() {
            GroupPolicySettingMapping _x = new GroupPolicySettingMapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicySettingMapping";
            _x.id = id;
            _x.admxSettingDefinitionId = admxSettingDefinitionId;
            _x.childIdList = childIdList;
            _x.childIdListNextLink = childIdListNextLink;
            _x.intuneSettingDefinitionId = intuneSettingDefinitionId;
            _x.intuneSettingUriList = intuneSettingUriList;
            _x.intuneSettingUriListNextLink = intuneSettingUriListNextLink;
            _x.isMdmSupported = isMdmSupported;
            _x.mdmCspName = mdmCspName;
            _x.mdmMinimumOSVersion = mdmMinimumOSVersion;
            _x.mdmSettingUri = mdmSettingUri;
            _x.mdmSupportedState = mdmSupportedState;
            _x.parentId = parentId;
            _x.settingCategory = settingCategory;
            _x.settingDisplayName = settingDisplayName;
            _x.settingDisplayValue = settingDisplayValue;
            _x.settingDisplayValueType = settingDisplayValueType;
            _x.settingName = settingName;
            _x.settingScope = settingScope;
            _x.settingType = settingType;
            _x.settingValue = settingValue;
            _x.settingValueDisplayUnits = settingValueDisplayUnits;
            _x.settingValueType = settingValueType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Admx Group Policy Id”</i>
     * 
     * @return property admxSettingDefinitionId
     */
    @Property(name="admxSettingDefinitionId")
    @JsonIgnore
    public Optional<String> getAdmxSettingDefinitionId() {
        return Optional.ofNullable(admxSettingDefinitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * admxSettingDefinitionId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Admx Group Policy Id”</i>
     * 
     * @param admxSettingDefinitionId
     *            new value of {@code admxSettingDefinitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code admxSettingDefinitionId} field changed
     */
    public GroupPolicySettingMapping withAdmxSettingDefinitionId(String admxSettingDefinitionId) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("admxSettingDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.admxSettingDefinitionId = admxSettingDefinitionId;
        return _x;
    }

    /**
     * <i>“List of Child Ids of the group policy setting.”</i>
     * 
     * @return property childIdList
     */
    @Property(name="childIdList")
    @JsonIgnore
    public CollectionPage<String> getChildIdList() {
        return new CollectionPage<String>(contextPath, String.class, this.childIdList, Optional.ofNullable(childIdListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code childIdList}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Child Ids of the group policy setting.”</i>
     * 
     * @param childIdList
     *            new value of {@code childIdList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code childIdList} field changed
     */
    public GroupPolicySettingMapping withChildIdList(List<String> childIdList) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("childIdList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.childIdList = childIdList;
        return _x;
    }

    /**
     * <i>“List of Child Ids of the group policy setting.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property childIdList
     */
    @Property(name="childIdList")
    @JsonIgnore
    public CollectionPage<String> getChildIdList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.childIdList, Optional.ofNullable(childIdListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The Intune Setting Definition Id”</i>
     * 
     * @return property intuneSettingDefinitionId
     */
    @Property(name="intuneSettingDefinitionId")
    @JsonIgnore
    public Optional<String> getIntuneSettingDefinitionId() {
        return Optional.ofNullable(intuneSettingDefinitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * intuneSettingDefinitionId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Intune Setting Definition Id”</i>
     * 
     * @param intuneSettingDefinitionId
     *            new value of {@code intuneSettingDefinitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneSettingDefinitionId} field changed
     */
    public GroupPolicySettingMapping withIntuneSettingDefinitionId(String intuneSettingDefinitionId) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("intuneSettingDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.intuneSettingDefinitionId = intuneSettingDefinitionId;
        return _x;
    }

    /**
     * <i>“The list of Intune Setting URIs this group policy setting maps to”</i>
     * 
     * @return property intuneSettingUriList
     */
    @Property(name="intuneSettingUriList")
    @JsonIgnore
    public CollectionPage<String> getIntuneSettingUriList() {
        return new CollectionPage<String>(contextPath, String.class, this.intuneSettingUriList, Optional.ofNullable(intuneSettingUriListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * intuneSettingUriList} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of Intune Setting URIs this group policy setting maps to”</i>
     * 
     * @param intuneSettingUriList
     *            new value of {@code intuneSettingUriList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneSettingUriList} field changed
     */
    public GroupPolicySettingMapping withIntuneSettingUriList(List<String> intuneSettingUriList) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("intuneSettingUriList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.intuneSettingUriList = intuneSettingUriList;
        return _x;
    }

    /**
     * <i>“The list of Intune Setting URIs this group policy setting maps to”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property intuneSettingUriList
     */
    @Property(name="intuneSettingUriList")
    @JsonIgnore
    public CollectionPage<String> getIntuneSettingUriList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.intuneSettingUriList, Optional.ofNullable(intuneSettingUriListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates if the setting is supported by Intune or not”</i>
     * 
     * @return property isMdmSupported
     */
    @Property(name="isMdmSupported")
    @JsonIgnore
    public Optional<Boolean> getIsMdmSupported() {
        return Optional.ofNullable(isMdmSupported);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isMdmSupported}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if the setting is supported by Intune or not”</i>
     * 
     * @param isMdmSupported
     *            new value of {@code isMdmSupported} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isMdmSupported} field changed
     */
    public GroupPolicySettingMapping withIsMdmSupported(Boolean isMdmSupported) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("isMdmSupported");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.isMdmSupported = isMdmSupported;
        return _x;
    }

    /**
     * <i>“The CSP name this group policy setting maps to.”</i>
     * 
     * @return property mdmCspName
     */
    @Property(name="mdmCspName")
    @JsonIgnore
    public Optional<String> getMdmCspName() {
        return Optional.ofNullable(mdmCspName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mdmCspName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The CSP name this group policy setting maps to.”</i>
     * 
     * @param mdmCspName
     *            new value of {@code mdmCspName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmCspName} field changed
     */
    public GroupPolicySettingMapping withMdmCspName(String mdmCspName) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("mdmCspName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.mdmCspName = mdmCspName;
        return _x;
    }

    /**
     * <i>“The minimum OS version this mdm setting supports.”</i>
     * 
     * @return property mdmMinimumOSVersion
     */
    @Property(name="mdmMinimumOSVersion")
    @JsonIgnore
    public Optional<Integer> getMdmMinimumOSVersion() {
        return Optional.ofNullable(mdmMinimumOSVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mdmMinimumOSVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The minimum OS version this mdm setting supports.”</i>
     * 
     * @param mdmMinimumOSVersion
     *            new value of {@code mdmMinimumOSVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmMinimumOSVersion} field changed
     */
    public GroupPolicySettingMapping withMdmMinimumOSVersion(Integer mdmMinimumOSVersion) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("mdmMinimumOSVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.mdmMinimumOSVersion = mdmMinimumOSVersion;
        return _x;
    }

    /**
     * <i>“The MDM CSP URI this group policy setting maps to.”</i>
     * 
     * @return property mdmSettingUri
     */
    @Property(name="mdmSettingUri")
    @JsonIgnore
    public Optional<String> getMdmSettingUri() {
        return Optional.ofNullable(mdmSettingUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mdmSettingUri}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MDM CSP URI this group policy setting maps to.”</i>
     * 
     * @param mdmSettingUri
     *            new value of {@code mdmSettingUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmSettingUri} field changed
     */
    public GroupPolicySettingMapping withMdmSettingUri(String mdmSettingUri) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("mdmSettingUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.mdmSettingUri = mdmSettingUri;
        return _x;
    }

    /**
     * <i>“Indicates if the setting is supported in Mdm or not”</i>
     * 
     * @return property mdmSupportedState
     */
    @Property(name="mdmSupportedState")
    @JsonIgnore
    public Optional<MdmSupportedState> getMdmSupportedState() {
        return Optional.ofNullable(mdmSupportedState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mdmSupportedState
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if the setting is supported in Mdm or not”</i>
     * 
     * @param mdmSupportedState
     *            new value of {@code mdmSupportedState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmSupportedState} field changed
     */
    public GroupPolicySettingMapping withMdmSupportedState(MdmSupportedState mdmSupportedState) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("mdmSupportedState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.mdmSupportedState = mdmSupportedState;
        return _x;
    }

    /**
     * <i>“Parent Id of the group policy setting.”</i>
     * 
     * @return property parentId
     */
    @Property(name="parentId")
    @JsonIgnore
    public Optional<String> getParentId() {
        return Optional.ofNullable(parentId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code parentId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Parent Id of the group policy setting.”</i>
     * 
     * @param parentId
     *            new value of {@code parentId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code parentId} field changed
     */
    public GroupPolicySettingMapping withParentId(String parentId) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("parentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.parentId = parentId;
        return _x;
    }

    /**
     * <i>“The category the group policy setting is in.”</i>
     * 
     * @return property settingCategory
     */
    @Property(name="settingCategory")
    @JsonIgnore
    public Optional<String> getSettingCategory() {
        return Optional.ofNullable(settingCategory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingCategory}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The category the group policy setting is in.”</i>
     * 
     * @param settingCategory
     *            new value of {@code settingCategory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingCategory} field changed
     */
    public GroupPolicySettingMapping withSettingCategory(String settingCategory) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingCategory = settingCategory;
        return _x;
    }

    /**
     * <i>“The display name of this group policy setting.”</i>
     * 
     * @return property settingDisplayName
     */
    @Property(name="settingDisplayName")
    @JsonIgnore
    public Optional<String> getSettingDisplayName() {
        return Optional.ofNullable(settingDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDisplayName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The display name of this group policy setting.”</i>
     * 
     * @param settingDisplayName
     *            new value of {@code settingDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDisplayName} field changed
     */
    public GroupPolicySettingMapping withSettingDisplayName(String settingDisplayName) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingDisplayName = settingDisplayName;
        return _x;
    }

    /**
     * <i>“The display value of this group policy setting.”</i>
     * 
     * @return property settingDisplayValue
     */
    @Property(name="settingDisplayValue")
    @JsonIgnore
    public Optional<String> getSettingDisplayValue() {
        return Optional.ofNullable(settingDisplayValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDisplayValue} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The display value of this group policy setting.”</i>
     * 
     * @param settingDisplayValue
     *            new value of {@code settingDisplayValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDisplayValue} field changed
     */
    public GroupPolicySettingMapping withSettingDisplayValue(String settingDisplayValue) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingDisplayValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingDisplayValue = settingDisplayValue;
        return _x;
    }

    /**
     * <i>“The display value type of this group policy setting.”</i>
     * 
     * @return property settingDisplayValueType
     */
    @Property(name="settingDisplayValueType")
    @JsonIgnore
    public Optional<String> getSettingDisplayValueType() {
        return Optional.ofNullable(settingDisplayValueType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDisplayValueType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The display value type of this group policy setting.”</i>
     * 
     * @param settingDisplayValueType
     *            new value of {@code settingDisplayValueType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDisplayValueType} field changed
     */
    public GroupPolicySettingMapping withSettingDisplayValueType(String settingDisplayValueType) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingDisplayValueType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingDisplayValueType = settingDisplayValueType;
        return _x;
    }

    /**
     * <i>“The name of this group policy setting.”</i>
     * 
     * @return property settingName
     */
    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of this group policy setting.”</i>
     * 
     * @param settingName
     *            new value of {@code settingName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingName} field changed
     */
    public GroupPolicySettingMapping withSettingName(String settingName) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingName = settingName;
        return _x;
    }

    /**
     * <i>“The scope of the setting”</i>
     * 
     * @return property settingScope
     */
    @Property(name="settingScope")
    @JsonIgnore
    public Optional<GroupPolicySettingScope> getSettingScope() {
        return Optional.ofNullable(settingScope);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingScope}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The scope of the setting”</i>
     * 
     * @param settingScope
     *            new value of {@code settingScope} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingScope} field changed
     */
    public GroupPolicySettingMapping withSettingScope(GroupPolicySettingScope settingScope) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingScope = settingScope;
        return _x;
    }

    /**
     * <i>“The setting type (security or admx) of the Group Policy.”</i>
     * 
     * @return property settingType
     */
    @Property(name="settingType")
    @JsonIgnore
    public Optional<GroupPolicySettingType> getSettingType() {
        return Optional.ofNullable(settingType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting type (security or admx) of the Group Policy.”</i>
     * 
     * @param settingType
     *            new value of {@code settingType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingType} field changed
     */
    public GroupPolicySettingMapping withSettingType(GroupPolicySettingType settingType) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingType = settingType;
        return _x;
    }

    /**
     * <i>“The value of this group policy setting.”</i>
     * 
     * @return property settingValue
     */
    @Property(name="settingValue")
    @JsonIgnore
    public Optional<String> getSettingValue() {
        return Optional.ofNullable(settingValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The value of this group policy setting.”</i>
     * 
     * @param settingValue
     *            new value of {@code settingValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingValue} field changed
     */
    public GroupPolicySettingMapping withSettingValue(String settingValue) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingValue = settingValue;
        return _x;
    }

    /**
     * <i>“The display units of this group policy setting value”</i>
     * 
     * @return property settingValueDisplayUnits
     */
    @Property(name="settingValueDisplayUnits")
    @JsonIgnore
    public Optional<String> getSettingValueDisplayUnits() {
        return Optional.ofNullable(settingValueDisplayUnits);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingValueDisplayUnits} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The display units of this group policy setting value”</i>
     * 
     * @param settingValueDisplayUnits
     *            new value of {@code settingValueDisplayUnits} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingValueDisplayUnits} field changed
     */
    public GroupPolicySettingMapping withSettingValueDisplayUnits(String settingValueDisplayUnits) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingValueDisplayUnits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingValueDisplayUnits = settingValueDisplayUnits;
        return _x;
    }

    /**
     * <i>“The value type of this group policy setting.”</i>
     * 
     * @return property settingValueType
     */
    @Property(name="settingValueType")
    @JsonIgnore
    public Optional<String> getSettingValueType() {
        return Optional.ofNullable(settingValueType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingValueType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The value type of this group policy setting.”</i>
     * 
     * @param settingValueType
     *            new value of {@code settingValueType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingValueType} field changed
     */
    public GroupPolicySettingMapping withSettingValueType(String settingValueType) {
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = changedFields.add("settingValueType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicySettingMapping");
        _x.settingValueType = settingValueType;
        return _x;
    }

    public GroupPolicySettingMapping withUnmappedField(String name, Object value) {
        GroupPolicySettingMapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicySettingMapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicySettingMapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicySettingMapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicySettingMapping _copy() {
        GroupPolicySettingMapping _x = new GroupPolicySettingMapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.admxSettingDefinitionId = admxSettingDefinitionId;
        _x.childIdList = childIdList;
        _x.intuneSettingDefinitionId = intuneSettingDefinitionId;
        _x.intuneSettingUriList = intuneSettingUriList;
        _x.isMdmSupported = isMdmSupported;
        _x.mdmCspName = mdmCspName;
        _x.mdmMinimumOSVersion = mdmMinimumOSVersion;
        _x.mdmSettingUri = mdmSettingUri;
        _x.mdmSupportedState = mdmSupportedState;
        _x.parentId = parentId;
        _x.settingCategory = settingCategory;
        _x.settingDisplayName = settingDisplayName;
        _x.settingDisplayValue = settingDisplayValue;
        _x.settingDisplayValueType = settingDisplayValueType;
        _x.settingName = settingName;
        _x.settingScope = settingScope;
        _x.settingType = settingType;
        _x.settingValue = settingValue;
        _x.settingValueDisplayUnits = settingValueDisplayUnits;
        _x.settingValueType = settingValueType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicySettingMapping[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("admxSettingDefinitionId=");
        b.append(this.admxSettingDefinitionId);
        b.append(", ");
        b.append("childIdList=");
        b.append(this.childIdList);
        b.append(", ");
        b.append("intuneSettingDefinitionId=");
        b.append(this.intuneSettingDefinitionId);
        b.append(", ");
        b.append("intuneSettingUriList=");
        b.append(this.intuneSettingUriList);
        b.append(", ");
        b.append("isMdmSupported=");
        b.append(this.isMdmSupported);
        b.append(", ");
        b.append("mdmCspName=");
        b.append(this.mdmCspName);
        b.append(", ");
        b.append("mdmMinimumOSVersion=");
        b.append(this.mdmMinimumOSVersion);
        b.append(", ");
        b.append("mdmSettingUri=");
        b.append(this.mdmSettingUri);
        b.append(", ");
        b.append("mdmSupportedState=");
        b.append(this.mdmSupportedState);
        b.append(", ");
        b.append("parentId=");
        b.append(this.parentId);
        b.append(", ");
        b.append("settingCategory=");
        b.append(this.settingCategory);
        b.append(", ");
        b.append("settingDisplayName=");
        b.append(this.settingDisplayName);
        b.append(", ");
        b.append("settingDisplayValue=");
        b.append(this.settingDisplayValue);
        b.append(", ");
        b.append("settingDisplayValueType=");
        b.append(this.settingDisplayValueType);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append(", ");
        b.append("settingScope=");
        b.append(this.settingScope);
        b.append(", ");
        b.append("settingType=");
        b.append(this.settingType);
        b.append(", ");
        b.append("settingValue=");
        b.append(this.settingValue);
        b.append(", ");
        b.append("settingValueDisplayUnits=");
        b.append(this.settingValueDisplayUnits);
        b.append(", ");
        b.append("settingValueType=");
        b.append(this.settingValueType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
