package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“The entity represents a string value of a multi-line text box presentation on a
 * policy definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyPresentationValueMultiText extends GroupPolicyPresentationValue implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyPresentationValueMultiText";
    }

    @JsonProperty("values")
    protected List<String> values;

    @JsonProperty("values@nextLink")
    protected String valuesNextLink;

    protected GroupPolicyPresentationValueMultiText() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyPresentationValueMultiText() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> values;
        private String valuesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“A collection of non-empty strings for the associated presentation.”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(List<String> values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        /**
         * <i>“A collection of non-empty strings for the associated presentation.”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(String... values) {
            return values(Arrays.asList(values));
        }

        /**
         * <i>“A collection of non-empty strings for the associated presentation.”</i>
         * 
         * @param valuesNextLink
         *            value of {@code values@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public GroupPolicyPresentationValueMultiText build() {
            GroupPolicyPresentationValueMultiText _x = new GroupPolicyPresentationValueMultiText();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyPresentationValueMultiText";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“A collection of non-empty strings for the associated presentation.”</i>
     * 
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<String> getValues() {
        return new CollectionPage<String>(contextPath, String.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code values} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“A collection of non-empty strings for the associated presentation.”</i>
     * 
     * @param values
     *            new value of {@code values} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code values} field changed
     */
    public GroupPolicyPresentationValueMultiText withValues(List<String> values) {
        GroupPolicyPresentationValueMultiText _x = _copy();
        _x.changedFields = changedFields.add("values");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationValueMultiText");
        _x.values = values;
        return _x;
    }

    /**
     * <i>“A collection of non-empty strings for the associated presentation.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<String> getValues(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    public GroupPolicyPresentationValueMultiText withUnmappedField(String name, Object value) {
        GroupPolicyPresentationValueMultiText _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationValueMultiText patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationValueMultiText _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationValueMultiText put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationValueMultiText _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyPresentationValueMultiText _copy() {
        GroupPolicyPresentationValueMultiText _x = new GroupPolicyPresentationValueMultiText();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyPresentationValueMultiText[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
