package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.collection.request.GroupPolicySettingMappingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnsupportedGroupPolicyExtensionCollectionRequest;
import odata.msgraph.client.beta.enums.GroupPolicyMigrationReadiness;


/**
 * <i>“The Group Policy migration report.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "displayName", 
    "groupPolicyCreatedDateTime", 
    "groupPolicyLastModifiedDateTime", 
    "groupPolicyObjectId", 
    "lastModifiedDateTime", 
    "migrationReadiness", 
    "ouDistinguishedName", 
    "supportedSettingsCount", 
    "supportedSettingsPercent", 
    "targetedInActiveDirectory", 
    "totalSettingsCount", 
    "groupPolicySettingMappings", 
    "unsupportedGroupPolicyExtensions"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyMigrationReport extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyMigrationReport";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("groupPolicyCreatedDateTime")
    protected OffsetDateTime groupPolicyCreatedDateTime;

    @JsonProperty("groupPolicyLastModifiedDateTime")
    protected OffsetDateTime groupPolicyLastModifiedDateTime;

    @JsonProperty("groupPolicyObjectId")
    protected UUID groupPolicyObjectId;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("migrationReadiness")
    protected GroupPolicyMigrationReadiness migrationReadiness;

    @JsonProperty("ouDistinguishedName")
    protected String ouDistinguishedName;

    @JsonProperty("supportedSettingsCount")
    protected Integer supportedSettingsCount;

    @JsonProperty("supportedSettingsPercent")
    protected Integer supportedSettingsPercent;

    @JsonProperty("targetedInActiveDirectory")
    protected Boolean targetedInActiveDirectory;

    @JsonProperty("totalSettingsCount")
    protected Integer totalSettingsCount;

    @JsonProperty("groupPolicySettingMappings")
    protected List<GroupPolicySettingMapping> groupPolicySettingMappings;

    @JsonProperty("unsupportedGroupPolicyExtensions")
    protected List<UnsupportedGroupPolicyExtension> unsupportedGroupPolicyExtensions;

    protected GroupPolicyMigrationReport() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyMigrationReport() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime groupPolicyCreatedDateTime;
        private OffsetDateTime groupPolicyLastModifiedDateTime;
        private UUID groupPolicyObjectId;
        private OffsetDateTime lastModifiedDateTime;
        private GroupPolicyMigrationReadiness migrationReadiness;
        private String ouDistinguishedName;
        private Integer supportedSettingsCount;
        private Integer supportedSettingsPercent;
        private Boolean targetedInActiveDirectory;
        private Integer totalSettingsCount;
        private List<GroupPolicySettingMapping> groupPolicySettingMappings;
        private List<UnsupportedGroupPolicyExtension> unsupportedGroupPolicyExtensions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The date and time at which the GroupPolicyMigrationReport was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The name of Group Policy Object from the GPO Xml Content”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The date and time at which the GroupPolicyMigrationReport was created.”</i>
         * 
         * @param groupPolicyCreatedDateTime
         *            value of {@code groupPolicyCreatedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyCreatedDateTime(OffsetDateTime groupPolicyCreatedDateTime) {
            this.groupPolicyCreatedDateTime = groupPolicyCreatedDateTime;
            this.changedFields = changedFields.add("groupPolicyCreatedDateTime");
            return this;
        }

        /**
         * <i>“The date and time at which the GroupPolicyMigrationReport was last modified.”</i>
         * 
         * @param groupPolicyLastModifiedDateTime
         *            value of {@code groupPolicyLastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyLastModifiedDateTime(OffsetDateTime groupPolicyLastModifiedDateTime) {
            this.groupPolicyLastModifiedDateTime = groupPolicyLastModifiedDateTime;
            this.changedFields = changedFields.add("groupPolicyLastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The Group Policy Object GUID from GPO Xml content”</i>
         * 
         * @param groupPolicyObjectId
         *            value of {@code groupPolicyObjectId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyObjectId(UUID groupPolicyObjectId) {
            this.groupPolicyObjectId = groupPolicyObjectId;
            this.changedFields = changedFields.add("groupPolicyObjectId");
            return this;
        }

        /**
         * <i>“The date and time at which the GroupPolicyMigrationReport was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The Intune coverage for the associated Group Policy Object file.”</i>
         * 
         * @param migrationReadiness
         *            value of {@code migrationReadiness} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder migrationReadiness(GroupPolicyMigrationReadiness migrationReadiness) {
            this.migrationReadiness = migrationReadiness;
            this.changedFields = changedFields.add("migrationReadiness");
            return this;
        }

        /**
         * <i>“The distinguished name of the OU.”</i>
         * 
         * @param ouDistinguishedName
         *            value of {@code ouDistinguishedName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ouDistinguishedName(String ouDistinguishedName) {
            this.ouDistinguishedName = ouDistinguishedName;
            this.changedFields = changedFields.add("ouDistinguishedName");
            return this;
        }

        /**
         * <i>“The number of Group Policy Settings supported by Intune.”</i>
         * 
         * @param supportedSettingsCount
         *            value of {@code supportedSettingsCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedSettingsCount(Integer supportedSettingsCount) {
            this.supportedSettingsCount = supportedSettingsCount;
            this.changedFields = changedFields.add("supportedSettingsCount");
            return this;
        }

        /**
         * <i>“The Percentage of Group Policy Settings supported by Intune.”</i>
         * 
         * @param supportedSettingsPercent
         *            value of {@code supportedSettingsPercent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedSettingsPercent(Integer supportedSettingsPercent) {
            this.supportedSettingsPercent = supportedSettingsPercent;
            this.changedFields = changedFields.add("supportedSettingsPercent");
            return this;
        }

        /**
         * <i>“The Targeted in AD property from GPO Xml Content”</i>
         * 
         * @param targetedInActiveDirectory
         *            value of {@code targetedInActiveDirectory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedInActiveDirectory(Boolean targetedInActiveDirectory) {
            this.targetedInActiveDirectory = targetedInActiveDirectory;
            this.changedFields = changedFields.add("targetedInActiveDirectory");
            return this;
        }

        /**
         * <i>“The total number of Group Policy Settings from GPO file.”</i>
         * 
         * @param totalSettingsCount
         *            value of {@code totalSettingsCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalSettingsCount(Integer totalSettingsCount) {
            this.totalSettingsCount = totalSettingsCount;
            this.changedFields = changedFields.add("totalSettingsCount");
            return this;
        }

        /**
         * <i>“A list of group policy settings to MDM/Intune mappings.”</i>
         * 
         * @param groupPolicySettingMappings
         *            value of {@code groupPolicySettingMappings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicySettingMappings(List<GroupPolicySettingMapping> groupPolicySettingMappings) {
            this.groupPolicySettingMappings = groupPolicySettingMappings;
            this.changedFields = changedFields.add("groupPolicySettingMappings");
            return this;
        }

        /**
         * <i>“A list of group policy settings to MDM/Intune mappings.”</i>
         * 
         * @param groupPolicySettingMappings
         *            value of {@code groupPolicySettingMappings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicySettingMappings(GroupPolicySettingMapping... groupPolicySettingMappings) {
            return groupPolicySettingMappings(Arrays.asList(groupPolicySettingMappings));
        }

        /**
         * <i>“A list of unsupported group policy extensions inside the Group Policy Object.”</i>
         * 
         * @param unsupportedGroupPolicyExtensions
         *            value of {@code unsupportedGroupPolicyExtensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unsupportedGroupPolicyExtensions(List<UnsupportedGroupPolicyExtension> unsupportedGroupPolicyExtensions) {
            this.unsupportedGroupPolicyExtensions = unsupportedGroupPolicyExtensions;
            this.changedFields = changedFields.add("unsupportedGroupPolicyExtensions");
            return this;
        }

        /**
         * <i>“A list of unsupported group policy extensions inside the Group Policy Object.”</i>
         * 
         * @param unsupportedGroupPolicyExtensions
         *            value of {@code unsupportedGroupPolicyExtensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unsupportedGroupPolicyExtensions(UnsupportedGroupPolicyExtension... unsupportedGroupPolicyExtensions) {
            return unsupportedGroupPolicyExtensions(Arrays.asList(unsupportedGroupPolicyExtensions));
        }

        public GroupPolicyMigrationReport build() {
            GroupPolicyMigrationReport _x = new GroupPolicyMigrationReport();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyMigrationReport";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.groupPolicyCreatedDateTime = groupPolicyCreatedDateTime;
            _x.groupPolicyLastModifiedDateTime = groupPolicyLastModifiedDateTime;
            _x.groupPolicyObjectId = groupPolicyObjectId;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.migrationReadiness = migrationReadiness;
            _x.ouDistinguishedName = ouDistinguishedName;
            _x.supportedSettingsCount = supportedSettingsCount;
            _x.supportedSettingsPercent = supportedSettingsPercent;
            _x.targetedInActiveDirectory = targetedInActiveDirectory;
            _x.totalSettingsCount = totalSettingsCount;
            _x.groupPolicySettingMappings = groupPolicySettingMappings;
            _x.unsupportedGroupPolicyExtensions = unsupportedGroupPolicyExtensions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The date and time at which the GroupPolicyMigrationReport was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time at which the GroupPolicyMigrationReport was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public GroupPolicyMigrationReport withCreatedDateTime(OffsetDateTime createdDateTime) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The name of Group Policy Object from the GPO Xml Content”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of Group Policy Object from the GPO Xml Content”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public GroupPolicyMigrationReport withDisplayName(String displayName) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The date and time at which the GroupPolicyMigrationReport was created.”</i>
     * 
     * @return property groupPolicyCreatedDateTime
     */
    @Property(name="groupPolicyCreatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getGroupPolicyCreatedDateTime() {
        return Optional.ofNullable(groupPolicyCreatedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyCreatedDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The date and time at which the GroupPolicyMigrationReport was created.”</i>
     * 
     * @param groupPolicyCreatedDateTime
     *            new value of {@code groupPolicyCreatedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyCreatedDateTime} field changed
     */
    public GroupPolicyMigrationReport withGroupPolicyCreatedDateTime(OffsetDateTime groupPolicyCreatedDateTime) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyCreatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.groupPolicyCreatedDateTime = groupPolicyCreatedDateTime;
        return _x;
    }

    /**
     * <i>“The date and time at which the GroupPolicyMigrationReport was last modified.”</i>
     * 
     * @return property groupPolicyLastModifiedDateTime
     */
    @Property(name="groupPolicyLastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getGroupPolicyLastModifiedDateTime() {
        return Optional.ofNullable(groupPolicyLastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyLastModifiedDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The date and time at which the GroupPolicyMigrationReport was last modified.”</i>
     * 
     * @param groupPolicyLastModifiedDateTime
     *            new value of {@code groupPolicyLastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyLastModifiedDateTime} field changed
     */
    public GroupPolicyMigrationReport withGroupPolicyLastModifiedDateTime(OffsetDateTime groupPolicyLastModifiedDateTime) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyLastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.groupPolicyLastModifiedDateTime = groupPolicyLastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The Group Policy Object GUID from GPO Xml content”</i>
     * 
     * @return property groupPolicyObjectId
     */
    @Property(name="groupPolicyObjectId")
    @JsonIgnore
    public Optional<UUID> getGroupPolicyObjectId() {
        return Optional.ofNullable(groupPolicyObjectId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyObjectId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Group Policy Object GUID from GPO Xml content”</i>
     * 
     * @param groupPolicyObjectId
     *            new value of {@code groupPolicyObjectId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyObjectId} field changed
     */
    public GroupPolicyMigrationReport withGroupPolicyObjectId(UUID groupPolicyObjectId) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyObjectId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.groupPolicyObjectId = groupPolicyObjectId;
        return _x;
    }

    /**
     * <i>“The date and time at which the GroupPolicyMigrationReport was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time at which the GroupPolicyMigrationReport was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyMigrationReport withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The Intune coverage for the associated Group Policy Object file.”</i>
     * 
     * @return property migrationReadiness
     */
    @Property(name="migrationReadiness")
    @JsonIgnore
    public Optional<GroupPolicyMigrationReadiness> getMigrationReadiness() {
        return Optional.ofNullable(migrationReadiness);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * migrationReadiness} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Intune coverage for the associated Group Policy Object file.”</i>
     * 
     * @param migrationReadiness
     *            new value of {@code migrationReadiness} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code migrationReadiness} field changed
     */
    public GroupPolicyMigrationReport withMigrationReadiness(GroupPolicyMigrationReadiness migrationReadiness) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("migrationReadiness");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.migrationReadiness = migrationReadiness;
        return _x;
    }

    /**
     * <i>“The distinguished name of the OU.”</i>
     * 
     * @return property ouDistinguishedName
     */
    @Property(name="ouDistinguishedName")
    @JsonIgnore
    public Optional<String> getOuDistinguishedName() {
        return Optional.ofNullable(ouDistinguishedName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ouDistinguishedName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The distinguished name of the OU.”</i>
     * 
     * @param ouDistinguishedName
     *            new value of {@code ouDistinguishedName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ouDistinguishedName} field changed
     */
    public GroupPolicyMigrationReport withOuDistinguishedName(String ouDistinguishedName) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("ouDistinguishedName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.ouDistinguishedName = ouDistinguishedName;
        return _x;
    }

    /**
     * <i>“The number of Group Policy Settings supported by Intune.”</i>
     * 
     * @return property supportedSettingsCount
     */
    @Property(name="supportedSettingsCount")
    @JsonIgnore
    public Optional<Integer> getSupportedSettingsCount() {
        return Optional.ofNullable(supportedSettingsCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportedSettingsCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The number of Group Policy Settings supported by Intune.”</i>
     * 
     * @param supportedSettingsCount
     *            new value of {@code supportedSettingsCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportedSettingsCount} field changed
     */
    public GroupPolicyMigrationReport withSupportedSettingsCount(Integer supportedSettingsCount) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("supportedSettingsCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.supportedSettingsCount = supportedSettingsCount;
        return _x;
    }

    /**
     * <i>“The Percentage of Group Policy Settings supported by Intune.”</i>
     * 
     * @return property supportedSettingsPercent
     */
    @Property(name="supportedSettingsPercent")
    @JsonIgnore
    public Optional<Integer> getSupportedSettingsPercent() {
        return Optional.ofNullable(supportedSettingsPercent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportedSettingsPercent} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Percentage of Group Policy Settings supported by Intune.”</i>
     * 
     * @param supportedSettingsPercent
     *            new value of {@code supportedSettingsPercent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportedSettingsPercent} field changed
     */
    public GroupPolicyMigrationReport withSupportedSettingsPercent(Integer supportedSettingsPercent) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("supportedSettingsPercent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.supportedSettingsPercent = supportedSettingsPercent;
        return _x;
    }

    /**
     * <i>“The Targeted in AD property from GPO Xml Content”</i>
     * 
     * @return property targetedInActiveDirectory
     */
    @Property(name="targetedInActiveDirectory")
    @JsonIgnore
    public Optional<Boolean> getTargetedInActiveDirectory() {
        return Optional.ofNullable(targetedInActiveDirectory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedInActiveDirectory} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Targeted in AD property from GPO Xml Content”</i>
     * 
     * @param targetedInActiveDirectory
     *            new value of {@code targetedInActiveDirectory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedInActiveDirectory} field changed
     */
    public GroupPolicyMigrationReport withTargetedInActiveDirectory(Boolean targetedInActiveDirectory) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("targetedInActiveDirectory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.targetedInActiveDirectory = targetedInActiveDirectory;
        return _x;
    }

    /**
     * <i>“The total number of Group Policy Settings from GPO file.”</i>
     * 
     * @return property totalSettingsCount
     */
    @Property(name="totalSettingsCount")
    @JsonIgnore
    public Optional<Integer> getTotalSettingsCount() {
        return Optional.ofNullable(totalSettingsCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * totalSettingsCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The total number of Group Policy Settings from GPO file.”</i>
     * 
     * @param totalSettingsCount
     *            new value of {@code totalSettingsCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalSettingsCount} field changed
     */
    public GroupPolicyMigrationReport withTotalSettingsCount(Integer totalSettingsCount) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("totalSettingsCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.totalSettingsCount = totalSettingsCount;
        return _x;
    }

    public GroupPolicyMigrationReport withUnmappedField(String name, Object value) {
        GroupPolicyMigrationReport _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“A list of group policy settings to MDM/Intune mappings.”</i>
     * 
     * @return navigational property groupPolicySettingMappings
     */
    @NavigationProperty(name="groupPolicySettingMappings")
    @JsonIgnore
    public GroupPolicySettingMappingCollectionRequest getGroupPolicySettingMappings() {
        return new GroupPolicySettingMappingCollectionRequest(
                        contextPath.addSegment("groupPolicySettingMappings"), Optional.ofNullable(groupPolicySettingMappings));
    }

    /**
     * <i>“A list of unsupported group policy extensions inside the Group Policy Object.”</i>
     * 
     * @return navigational property unsupportedGroupPolicyExtensions
     */
    @NavigationProperty(name="unsupportedGroupPolicyExtensions")
    @JsonIgnore
    public UnsupportedGroupPolicyExtensionCollectionRequest getUnsupportedGroupPolicyExtensions() {
        return new UnsupportedGroupPolicyExtensionCollectionRequest(
                        contextPath.addSegment("unsupportedGroupPolicyExtensions"), Optional.ofNullable(unsupportedGroupPolicyExtensions));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicySettingMappings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A list of group policy settings to MDM/Intune mappings.”</i>
     * 
     * @param groupPolicySettingMappings
     *            new value of {@code groupPolicySettingMappings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicySettingMappings} field changed
     */
    public GroupPolicyMigrationReport withGroupPolicySettingMappings(List<GroupPolicySettingMapping> groupPolicySettingMappings) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("groupPolicySettingMappings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.groupPolicySettingMappings = groupPolicySettingMappings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unsupportedGroupPolicyExtensions} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“A list of unsupported group policy extensions inside the Group Policy Object.”</i>
     * 
     * @param unsupportedGroupPolicyExtensions
     *            new value of {@code unsupportedGroupPolicyExtensions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unsupportedGroupPolicyExtensions} field changed
     */
    public GroupPolicyMigrationReport withUnsupportedGroupPolicyExtensions(List<UnsupportedGroupPolicyExtension> unsupportedGroupPolicyExtensions) {
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = changedFields.add("unsupportedGroupPolicyExtensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyMigrationReport");
        _x.unsupportedGroupPolicyExtensions = unsupportedGroupPolicyExtensions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyMigrationReport patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyMigrationReport put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyMigrationReport _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyMigrationReport _copy() {
        GroupPolicyMigrationReport _x = new GroupPolicyMigrationReport();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.groupPolicyCreatedDateTime = groupPolicyCreatedDateTime;
        _x.groupPolicyLastModifiedDateTime = groupPolicyLastModifiedDateTime;
        _x.groupPolicyObjectId = groupPolicyObjectId;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.migrationReadiness = migrationReadiness;
        _x.ouDistinguishedName = ouDistinguishedName;
        _x.supportedSettingsCount = supportedSettingsCount;
        _x.supportedSettingsPercent = supportedSettingsPercent;
        _x.targetedInActiveDirectory = targetedInActiveDirectory;
        _x.totalSettingsCount = totalSettingsCount;
        _x.groupPolicySettingMappings = groupPolicySettingMappings;
        _x.unsupportedGroupPolicyExtensions = unsupportedGroupPolicyExtensions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyMigrationReport[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("groupPolicyCreatedDateTime=");
        b.append(this.groupPolicyCreatedDateTime);
        b.append(", ");
        b.append("groupPolicyLastModifiedDateTime=");
        b.append(this.groupPolicyLastModifiedDateTime);
        b.append(", ");
        b.append("groupPolicyObjectId=");
        b.append(this.groupPolicyObjectId);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("migrationReadiness=");
        b.append(this.migrationReadiness);
        b.append(", ");
        b.append("ouDistinguishedName=");
        b.append(this.ouDistinguishedName);
        b.append(", ");
        b.append("supportedSettingsCount=");
        b.append(this.supportedSettingsCount);
        b.append(", ");
        b.append("supportedSettingsPercent=");
        b.append(this.supportedSettingsPercent);
        b.append(", ");
        b.append("targetedInActiveDirectory=");
        b.append(this.targetedInActiveDirectory);
        b.append(", ");
        b.append("totalSettingsCount=");
        b.append(this.totalSettingsCount);
        b.append(", ");
        b.append("groupPolicySettingMappings=");
        b.append(this.groupPolicySettingMappings);
        b.append(", ");
        b.append("unsupportedGroupPolicyExtensions=");
        b.append(this.unsupportedGroupPolicyExtensions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
