package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GroupPolicyPresentationValueCollectionRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;
import odata.msgraph.client.beta.enums.GroupPolicyConfigurationType;


/**
 * <i>“The definition value entity stores the value for a single group policy
 * definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "configurationType", 
    "createdDateTime", 
    "enabled", 
    "lastModifiedDateTime", 
    "presentationValues"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyDefinitionValue extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyDefinitionValue";
    }

    @JsonProperty("configurationType")
    protected GroupPolicyConfigurationType configurationType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("presentationValues")
    protected List<GroupPolicyPresentationValue> presentationValues;

    protected GroupPolicyDefinitionValue() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyDefinitionValue() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private GroupPolicyConfigurationType configurationType;
        private OffsetDateTime createdDateTime;
        private Boolean enabled;
        private OffsetDateTime lastModifiedDateTime;
        private List<GroupPolicyPresentationValue> presentationValues;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Specifies how the value should be configured. This can be either as a Policy or
         * as a Preference.”</i>
         * 
         * @param configurationType
         *            value of {@code configurationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationType(GroupPolicyConfigurationType configurationType) {
            this.configurationType = configurationType;
            this.changedFields = changedFields.add("configurationType");
            return this;
        }

        /**
         * <i>“The date and time the object was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Enables or disables the associated group policy definition.”</i>
         * 
         * @param enabled
         *            value of {@code enabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        /**
         * <i>“The date and time the entity was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The associated group policy presentation values with the definition value.”</i>
         * 
         * @param presentationValues
         *            value of {@code presentationValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder presentationValues(List<GroupPolicyPresentationValue> presentationValues) {
            this.presentationValues = presentationValues;
            this.changedFields = changedFields.add("presentationValues");
            return this;
        }

        /**
         * <i>“The associated group policy presentation values with the definition value.”</i>
         * 
         * @param presentationValues
         *            value of {@code presentationValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder presentationValues(GroupPolicyPresentationValue... presentationValues) {
            return presentationValues(Arrays.asList(presentationValues));
        }

        public GroupPolicyDefinitionValue build() {
            GroupPolicyDefinitionValue _x = new GroupPolicyDefinitionValue();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyDefinitionValue";
            _x.id = id;
            _x.configurationType = configurationType;
            _x.createdDateTime = createdDateTime;
            _x.enabled = enabled;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.presentationValues = presentationValues;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Specifies how the value should be configured. This can be either as a Policy or
     * as a Preference.”</i>
     * 
     * @return property configurationType
     */
    @Property(name="configurationType")
    @JsonIgnore
    public Optional<GroupPolicyConfigurationType> getConfigurationType() {
        return Optional.ofNullable(configurationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code configurationType
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies how the value should be configured. This can be either as a Policy or
     * as a Preference.”</i>
     * 
     * @param configurationType
     *            new value of {@code configurationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationType} field changed
     */
    public GroupPolicyDefinitionValue withConfigurationType(GroupPolicyConfigurationType configurationType) {
        GroupPolicyDefinitionValue _x = _copy();
        _x.changedFields = changedFields.add("configurationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionValue");
        _x.configurationType = configurationType;
        return _x;
    }

    /**
     * <i>“The date and time the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public GroupPolicyDefinitionValue withCreatedDateTime(OffsetDateTime createdDateTime) {
        GroupPolicyDefinitionValue _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionValue");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Enables or disables the associated group policy definition.”</i>
     * 
     * @return property enabled
     */
    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Enables or disables the associated group policy definition.”</i>
     * 
     * @param enabled
     *            new value of {@code enabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enabled} field changed
     */
    public GroupPolicyDefinitionValue withEnabled(Boolean enabled) {
        GroupPolicyDefinitionValue _x = _copy();
        _x.changedFields = changedFields.add("enabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionValue");
        _x.enabled = enabled;
        return _x;
    }

    /**
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyDefinitionValue withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyDefinitionValue _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionValue");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public GroupPolicyDefinitionValue withUnmappedField(String name, Object value) {
        GroupPolicyDefinitionValue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The associated group policy definition with the value.”</i>
     * 
     * @return navigational property definition
     */
    @NavigationProperty(name="definition")
    @JsonIgnore
    public GroupPolicyDefinitionRequest getDefinition() {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definition"), RequestHelper.getValue(unmappedFields, "definition"));
    }

    /**
     * <i>“The associated group policy presentation values with the definition value.”</i>
     * 
     * @return navigational property presentationValues
     */
    @NavigationProperty(name="presentationValues")
    @JsonIgnore
    public GroupPolicyPresentationValueCollectionRequest getPresentationValues() {
        return new GroupPolicyPresentationValueCollectionRequest(
                        contextPath.addSegment("presentationValues"), Optional.ofNullable(presentationValues));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * presentationValues} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The associated group policy presentation values with the definition value.”</i>
     * 
     * @param presentationValues
     *            new value of {@code presentationValues} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code presentationValues} field changed
     */
    public GroupPolicyDefinitionValue withPresentationValues(List<GroupPolicyPresentationValue> presentationValues) {
        GroupPolicyDefinitionValue _x = _copy();
        _x.changedFields = changedFields.add("presentationValues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionValue");
        _x.presentationValues = presentationValues;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinitionValue patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinitionValue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinitionValue put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinitionValue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyDefinitionValue _copy() {
        GroupPolicyDefinitionValue _x = new GroupPolicyDefinitionValue();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configurationType = configurationType;
        _x.createdDateTime = createdDateTime;
        _x.enabled = enabled;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.presentationValues = presentationValues;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyDefinitionValue[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configurationType=");
        b.append(this.configurationType);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("presentationValues=");
        b.append(this.presentationValues);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
